/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class NetInitiatedActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "NetInitiatedActivity";
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private static final int POSITIVE_BUTTON = -1;
    private static final int NEGATIVE_BUTTON = -2;
    public static final String BUTTON_TEXT_ACCEPT = "Accept";
    public static final String BUTTON_TEXT_DENY = "Deny";
    private int notificationId = -1;
    private BroadcastReceiver mNetInitiatedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.d(NetInitiatedActivity.TAG, "NetInitiatedReceiver onReceive: " + intent.getAction());
            if (intent.getAction() == "android.intent.action.NETWORK_INITIATED_VERIFY") {
                NetInitiatedActivity.this.handleNIVerify(intent);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        AlertController.AlertParams p = this.mAlertParams;
        p.mIconId = 17301909;
        p.mTitle = intent.getStringExtra("title");
        p.mMessage = intent.getStringExtra("message");
        p.mPositiveButtonText = BUTTON_TEXT_ACCEPT;
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = BUTTON_TEXT_DENY;
        p.mNegativeButtonListener = this;
        this.notificationId = intent.getIntExtra("notif_id", -1);
        Log.d(TAG, "onCreate, notifId: " + this.notificationId);
        this.setupAlert();
    }

    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume");
        this.registerReceiver(this.mNetInitiatedReceiver, new IntentFilter("android.intent.action.NETWORK_INITIATED_VERIFY"));
    }

    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause");
        this.unregisterReceiver(this.mNetInitiatedReceiver);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.sendUserResponse(1);
        }
        if (which == -2) {
            this.sendUserResponse(2);
        }
        this.finish();
        this.notificationId = -1;
    }

    private void sendUserResponse(int response) {
        Log.d(TAG, "sendUserResponse, response: " + response);
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        locationManager.sendNiResponse(this.notificationId, response);
    }

    private void handleNIVerify(Intent intent) {
        int notifId;
        this.notificationId = notifId = intent.getIntExtra("notif_id", -1);
        Log.d(TAG, "handleNIVerify action: " + intent.getAction());
    }

    private void showNIError() {
        Toast.makeText((Context)this, "NI error", 1).show();
    }
}

