/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class TimePicker
extends FrameLayout {
    private static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        }
    };
    private int mCurrentHour = 0;
    private int mCurrentMinute = 0;
    private Boolean mIs24HourView = false;
    private boolean mIsAm;
    private final NumberPicker mHourPicker;
    private final NumberPicker mMinutePicker;
    private final Button mAmPmButton;
    private final String mAmText;
    private final String mPmText;
    private OnTimeChangedListener mOnTimeChangedListener;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(17367141, (ViewGroup)this, true);
        this.mHourPicker = (NumberPicker)this.findViewById(16908824);
        this.mHourPicker.setOnChangeListener(new NumberPicker.OnChangedListener(){

            public void onChanged(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.mCurrentHour = newVal;
                if (!TimePicker.this.mIs24HourView.booleanValue()) {
                    if (TimePicker.this.mCurrentHour == 12) {
                        TimePicker.this.mCurrentHour = 0;
                    }
                    if (!TimePicker.this.mIsAm) {
                        TimePicker.this.mCurrentHour += 12;
                    }
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mMinutePicker = (NumberPicker)this.findViewById(16908825);
        this.mMinutePicker.setRange(0, 59);
        this.mMinutePicker.setSpeed(100L);
        this.mMinutePicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mMinutePicker.setOnChangeListener(new NumberPicker.OnChangedListener(){

            public void onChanged(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.mCurrentMinute = newVal;
                TimePicker.this.onTimeChanged();
            }
        });
        this.mAmPmButton = (Button)this.findViewById(16908826);
        this.configurePickerRanges();
        Calendar cal = Calendar.getInstance();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(cal.get(11));
        this.setCurrentMinute(cal.get(12));
        this.mIsAm = this.mCurrentHour < 12;
        DateFormatSymbols dfs = new DateFormatSymbols();
        String[] dfsAmPm = dfs.getAmPmStrings();
        this.mAmText = dfsAmPm[0];
        this.mPmText = dfsAmPm[1];
        this.mAmPmButton.setText(this.mIsAm ? this.mAmText : this.mPmText);
        this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePicker.this.requestFocus();
                if (TimePicker.this.mIsAm) {
                    if (TimePicker.this.mCurrentHour < 12) {
                        TimePicker.this.mCurrentHour += 12;
                    }
                } else if (TimePicker.this.mCurrentHour >= 12) {
                    TimePicker.this.mCurrentHour -= 12;
                }
                TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                TimePicker.this.mAmPmButton.setText(TimePicker.this.mIsAm ? TimePicker.this.mAmText : TimePicker.this.mPmText);
                TimePicker.this.onTimeChanged();
            }
        });
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mMinutePicker.setEnabled(enabled);
        this.mHourPicker.setEnabled(enabled);
        this.mAmPmButton.setEnabled(enabled);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mCurrentHour, this.mCurrentMinute);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    public Integer getCurrentHour() {
        return this.mCurrentHour;
    }

    public void setCurrentHour(Integer currentHour) {
        this.mCurrentHour = currentHour;
        this.updateHourDisplay();
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView != is24HourView) {
            this.mIs24HourView = is24HourView;
            this.configurePickerRanges();
            this.updateHourDisplay();
        }
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public Integer getCurrentMinute() {
        return this.mCurrentMinute;
    }

    public void setCurrentMinute(Integer currentMinute) {
        this.mCurrentMinute = currentMinute;
        this.updateMinuteDisplay();
    }

    public int getBaseline() {
        return this.mHourPicker.getBaseline();
    }

    private void updateHourDisplay() {
        int currentHour = this.mCurrentHour;
        if (!this.mIs24HourView.booleanValue()) {
            if (currentHour > 12) {
                currentHour -= 12;
            } else if (currentHour == 0) {
                currentHour = 12;
            }
        }
        this.mHourPicker.setCurrent(currentHour);
        this.mIsAm = this.mCurrentHour < 12;
        this.mAmPmButton.setText(this.mIsAm ? this.mAmText : this.mPmText);
        this.onTimeChanged();
    }

    private void configurePickerRanges() {
        if (this.mIs24HourView.booleanValue()) {
            this.mHourPicker.setRange(0, 23);
            this.mHourPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
            this.mAmPmButton.setVisibility(8);
        } else {
            this.mHourPicker.setRange(1, 12);
            this.mHourPicker.setFormatter(null);
            this.mAmPmButton.setVisibility(0);
        }
    }

    private void onTimeChanged() {
        this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
    }

    private void updateMinuteDisplay() {
        this.mMinutePicker.setCurrent(this.mCurrentMinute);
        this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }
}

