/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteTextView
extends EditText
implements Filter.FilterListener {
    static final boolean DEBUG = false;
    static final String TAG = "AutoCompleteTextView";
    private static final int HINT_VIEW_ID = 23;
    private static final int EXPAND_LIST_TIMEOUT = 250;
    private CharSequence mHintText;
    private int mHintResource;
    private ListAdapter mAdapter;
    private Filter mFilter;
    private int mThreshold;
    private PopupWindow mPopup;
    private DropDownListView mDropDownList;
    private int mDropDownVerticalOffset;
    private int mDropDownHorizontalOffset;
    private int mDropDownAnchorId;
    private View mDropDownAnchorView;
    private int mDropDownWidth;
    private int mDropDownHeight;
    private final Rect mTempRect = new Rect();
    private Drawable mDropDownListHighlight;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private final DropDownItemClickListener mDropDownItemClickListener = new DropDownItemClickListener();
    private boolean mDropDownAlwaysVisible = false;
    private boolean mDropDownDismissedOnCompletion = true;
    private boolean mForceIgnoreOutsideTouch = false;
    private int mLastKeyCode = 0;
    private boolean mOpenBefore;
    private Validator mValidator = null;
    private boolean mBlockCompletion;
    private ListSelectorHider mHideSelector;
    private Runnable mShowDropDownRunnable;
    private Runnable mResizePopupRunnable = new ResizePopupRunnable();
    private PassThroughClickListener mPassThroughClickListener;
    private PopupDataSetObserver mObserver;

    public AutoCompleteTextView(Context context) {
        this(context, null);
    }

    public AutoCompleteTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842859);
    }

    public AutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mPopup = new PopupWindow(context, attrs, 16842859);
        this.mPopup.setSoftInputMode(16);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoCompleteTextView, defStyle, 0);
        this.mThreshold = a.getInt(2, 2);
        this.mHintText = a.getText(0);
        this.mDropDownListHighlight = a.getDrawable(3);
        this.mDropDownVerticalOffset = (int)a.getDimension(9, 0.0f);
        this.mDropDownHorizontalOffset = (int)a.getDimension(8, 0.0f);
        this.mDropDownAnchorId = a.getResourceId(6, -1);
        this.mDropDownWidth = a.getLayoutDimension(5, -2);
        this.mDropDownHeight = a.getLayoutDimension(7, -2);
        this.mHintResource = a.getResourceId(1, 17367135);
        int inputType = this.getInputType();
        if ((inputType & 0xF) == 1) {
            this.setRawInputType(inputType |= 0x10000);
        }
        a.recycle();
        this.setFocusable(true);
        this.addTextChangedListener(new MyWatcher());
        this.mPassThroughClickListener = new PassThroughClickListener();
        super.setOnClickListener(this.mPassThroughClickListener);
    }

    @Override
    public void setOnClickListener(View.OnClickListener listener) {
        this.mPassThroughClickListener.mWrapped = listener;
    }

    private void onClickImpl() {
        if (this.mPopup.isShowing()) {
            this.ensureImeVisible(true);
        }
    }

    public void setCompletionHint(CharSequence hint) {
        this.mHintText = hint;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public void setDropDownWidth(int width) {
        this.mDropDownWidth = width;
    }

    public int getDropDownHeight() {
        return this.mDropDownHeight;
    }

    public void setDropDownHeight(int height) {
        this.mDropDownHeight = height;
    }

    public int getDropDownAnchor() {
        return this.mDropDownAnchorId;
    }

    public void setDropDownAnchor(int id2) {
        this.mDropDownAnchorId = id2;
        this.mDropDownAnchorView = null;
    }

    public Drawable getDropDownBackground() {
        return this.mPopup.getBackground();
    }

    public void setDropDownBackgroundDrawable(Drawable d) {
        this.mPopup.setBackgroundDrawable(d);
    }

    public void setDropDownBackgroundResource(int id2) {
        this.mPopup.setBackgroundDrawable(this.getResources().getDrawable(id2));
    }

    public void setDropDownVerticalOffset(int offset) {
        this.mDropDownVerticalOffset = offset;
    }

    public int getDropDownVerticalOffset() {
        return this.mDropDownVerticalOffset;
    }

    public void setDropDownHorizontalOffset(int offset) {
        this.mDropDownHorizontalOffset = offset;
    }

    public int getDropDownHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    public void setDropDownAnimationStyle(int animationStyle) {
        this.mPopup.setAnimationStyle(animationStyle);
    }

    public int getDropDownAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    public void setDropDownAlwaysVisible(boolean dropDownAlwaysVisible) {
        this.mDropDownAlwaysVisible = dropDownAlwaysVisible;
    }

    public boolean isDropDownDismissedOnCompletion() {
        return this.mDropDownDismissedOnCompletion;
    }

    public void setDropDownDismissedOnCompletion(boolean dropDownDismissedOnCompletion) {
        this.mDropDownDismissedOnCompletion = dropDownDismissedOnCompletion;
    }

    public int getThreshold() {
        return this.mThreshold;
    }

    public void setThreshold(int threshold) {
        if (threshold <= 0) {
            threshold = 1;
        }
        this.mThreshold = threshold;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener l) {
        this.mItemSelectedListener = l;
    }

    @Deprecated
    public AdapterView.OnItemClickListener getItemClickListener() {
        return this.mItemClickListener;
    }

    @Deprecated
    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.mItemClickListener;
    }

    public AdapterView.OnItemSelectedListener getOnItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T adapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver();
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.mFilter = ((Filterable)((Object)this.mAdapter)).getFilter();
            adapter.registerDataSetObserver(this.mObserver);
        } else {
            this.mFilter = null;
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    @Override
    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isPopupShowing() && !this.mDropDownAlwaysVisible) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                this.getKeyDispatcherState().startTracking(event, this);
                return true;
            }
            if (event.getAction() == 1) {
                this.getKeyDispatcherState().handleUpEvent(event);
                if (event.isTracking() && !event.isCanceled()) {
                    this.dismissDropDown();
                    return true;
                }
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean consumed;
        if (this.isPopupShowing() && this.mDropDownList.getSelectedItemPosition() >= 0 && (consumed = this.mDropDownList.onKeyUp(keyCode, event))) {
            switch (keyCode) {
                case 23: 
                case 66: {
                    this.performCompletion();
                    return true;
                }
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isPopupShowing()) {
            if (keyCode != 62 && (this.mDropDownList.getSelectedItemPosition() >= 0 || keyCode != 66 && keyCode != 23)) {
                int curIndex = this.mDropDownList.getSelectedItemPosition();
                boolean below = !this.mPopup.isAboveAnchor();
                ListAdapter adapter = this.mAdapter;
                int firstItem = Integer.MAX_VALUE;
                int lastItem = Integer.MIN_VALUE;
                if (adapter != null) {
                    boolean allEnabled = adapter.areAllItemsEnabled();
                    firstItem = allEnabled ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
                    int n = lastItem = allEnabled ? adapter.getCount() - 1 : this.mDropDownList.lookForSelectablePosition(adapter.getCount() - 1, false);
                }
                if (below && keyCode == 19 && curIndex <= firstItem || !below && keyCode == 20 && curIndex >= lastItem) {
                    this.clearListSelection();
                    this.mPopup.setInputMethodMode(1);
                    this.showDropDown();
                    return true;
                }
                this.mDropDownList.mListSelectionHidden = false;
                boolean consumed = this.mDropDownList.onKeyDown(keyCode, event);
                if (consumed) {
                    this.mPopup.setInputMethodMode(2);
                    this.mDropDownList.requestFocusFromTouch();
                    this.showDropDown();
                    switch (keyCode) {
                        case 19: 
                        case 20: 
                        case 23: 
                        case 66: {
                            return true;
                        }
                    }
                } else if (below && keyCode == 20 ? curIndex == lastItem : !below && keyCode == 19 && curIndex == firstItem) {
                    return true;
                }
            }
        } else {
            switch (keyCode) {
                case 20: {
                    this.performValidation();
                }
            }
        }
        this.mLastKeyCode = keyCode;
        boolean handled = super.onKeyDown(keyCode, event);
        this.mLastKeyCode = 0;
        if (handled && this.isPopupShowing() && this.mDropDownList != null) {
            this.clearListSelection();
        }
        return handled;
    }

    public boolean enoughToFilter() {
        return this.getText().length() >= this.mThreshold;
    }

    void doBeforeTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        this.mOpenBefore = this.isPopupShowing();
    }

    void doAfterTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        if (this.mOpenBefore && !this.isPopupShowing()) {
            return;
        }
        if (this.enoughToFilter()) {
            if (this.mFilter != null) {
                this.performFiltering(this.getText(), this.mLastKeyCode);
            }
        } else {
            if (!this.mDropDownAlwaysVisible) {
                this.dismissDropDown();
            }
            if (this.mFilter != null) {
                this.mFilter.filter(null);
            }
        }
    }

    public boolean isPopupShowing() {
        return this.mPopup.isShowing();
    }

    protected CharSequence convertSelectionToString(Object selectedItem) {
        return this.mFilter.convertResultToString(selectedItem);
    }

    public void clearListSelection() {
        DropDownListView list = this.mDropDownList;
        if (list != null) {
            list.mListSelectionHidden = true;
            list.hideSelector();
            list.requestLayout();
        }
    }

    public void setListSelection(int position) {
        if (this.mPopup.isShowing() && this.mDropDownList != null) {
            this.mDropDownList.mListSelectionHidden = false;
            this.mDropDownList.setSelection(position);
        }
    }

    public int getListSelection() {
        if (this.mPopup.isShowing() && this.mDropDownList != null) {
            return this.mDropDownList.getSelectedItemPosition();
        }
        return -1;
    }

    protected void performFiltering(CharSequence text, int keyCode) {
        this.mFilter.filter(text, this);
    }

    public void performCompletion() {
        this.performCompletion(null, -1, -1L);
    }

    @Override
    public void onCommitCompletion(CompletionInfo completion) {
        if (this.isPopupShowing()) {
            this.mBlockCompletion = true;
            this.replaceText(completion.getText());
            this.mBlockCompletion = false;
            if (this.mItemClickListener != null) {
                DropDownListView list = this.mDropDownList;
                this.mItemClickListener.onItemClick(list, null, completion.getPosition(), completion.getId());
            }
        }
    }

    private void performCompletion(View selectedView, int position, long id2) {
        if (this.isPopupShowing()) {
            Object selectedItem = position < 0 ? this.mDropDownList.getSelectedItem() : this.mAdapter.getItem(position);
            if (selectedItem == null) {
                Log.w(TAG, "performCompletion: no selected item");
                return;
            }
            this.mBlockCompletion = true;
            this.replaceText(this.convertSelectionToString(selectedItem));
            this.mBlockCompletion = false;
            if (this.mItemClickListener != null) {
                DropDownListView list = this.mDropDownList;
                if (selectedView == null || position < 0) {
                    selectedView = list.getSelectedView();
                    position = list.getSelectedItemPosition();
                    id2 = list.getSelectedItemId();
                }
                this.mItemClickListener.onItemClick(list, selectedView, position, id2);
            }
        }
        if (this.mDropDownDismissedOnCompletion && !this.mDropDownAlwaysVisible) {
            this.dismissDropDown();
        }
    }

    public boolean isPerformingCompletion() {
        return this.mBlockCompletion;
    }

    public void setText(CharSequence text, boolean filter) {
        if (filter) {
            this.setText(text);
        } else {
            this.mBlockCompletion = true;
            this.setText(text);
            this.mBlockCompletion = false;
        }
    }

    protected void replaceText(CharSequence text) {
        this.clearComposingText();
        this.setText(text);
        Editable spannable = this.getText();
        Selection.setSelection(spannable, spannable.length());
    }

    @Override
    public void onFilterComplete(int count) {
        this.updateDropDownForFilter(count);
    }

    private void updateDropDownForFilter(int count) {
        if (this.getWindowVisibility() == 8) {
            return;
        }
        if ((count > 0 || this.mDropDownAlwaysVisible) && this.enoughToFilter()) {
            if (this.hasFocus() && this.hasWindowFocus()) {
                this.showDropDown();
            }
        } else if (!this.mDropDownAlwaysVisible) {
            this.dismissDropDown();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!hasWindowFocus && !this.mDropDownAlwaysVisible) {
            this.dismissDropDown();
        }
    }

    @Override
    protected void onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                if (this.mDropDownAlwaysVisible) break;
                this.dismissDropDown();
            }
        }
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (!focused) {
            this.performValidation();
        }
        if (!focused && !this.mDropDownAlwaysVisible) {
            this.dismissDropDown();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.dismissDropDown();
        super.onDetachedFromWindow();
    }

    public void dismissDropDown() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null) {
            imm.displayCompletions(this, null);
        }
        this.mPopup.dismiss();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mPopup.isShowing()) {
            this.showDropDown();
        }
        return result;
    }

    private View getDropDownAnchorView() {
        if (this.mDropDownAnchorView == null && this.mDropDownAnchorId != -1) {
            this.mDropDownAnchorView = this.getRootView().findViewById(this.mDropDownAnchorId);
        }
        return this.mDropDownAnchorView == null ? this : this.mDropDownAnchorView;
    }

    public void showDropDownAfterLayout() {
        this.post(this.mShowDropDownRunnable);
    }

    public void ensureImeVisible(boolean visible) {
        this.mPopup.setInputMethodMode(visible ? 1 : 2);
        this.showDropDown();
    }

    public boolean isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    public void showDropDown() {
        int height = this.buildDropDown();
        int widthSpec = 0;
        int heightSpec = 0;
        boolean noInputMethod = this.isInputMethodNotNeeded();
        if (this.mPopup.isShowing()) {
            widthSpec = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -2 ? this.getDropDownAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == -1) {
                int n = heightSpec = noInputMethod ? height : -1;
                if (noInputMethod) {
                    this.mPopup.setWindowLayoutMode(this.mDropDownWidth == -1 ? -1 : 0, 0);
                } else {
                    this.mPopup.setWindowLayoutMode(this.mDropDownWidth == -1 ? -1 : 0, -1);
                }
            } else {
                heightSpec = this.mDropDownHeight == -2 ? height : this.mDropDownHeight;
            }
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.update(this.getDropDownAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, widthSpec, heightSpec);
        } else {
            if (this.mDropDownWidth == -1) {
                widthSpec = -1;
            } else if (this.mDropDownWidth == -2) {
                this.mPopup.setWidth(this.getDropDownAnchorView().getWidth());
            } else {
                this.mPopup.setWidth(this.mDropDownWidth);
            }
            if (this.mDropDownHeight == -1) {
                heightSpec = -1;
            } else if (this.mDropDownHeight == -2) {
                this.mPopup.setHeight(height);
            } else {
                this.mPopup.setHeight(this.mDropDownHeight);
            }
            this.mPopup.setWindowLayoutMode(widthSpec, heightSpec);
            this.mPopup.setInputMethodMode(1);
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.setTouchInterceptor(new PopupTouchInterceptor());
            this.mPopup.showAsDropDown(this.getDropDownAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset);
            this.mDropDownList.setSelection(-1);
            this.clearListSelection();
            this.post(this.mHideSelector);
        }
    }

    public void setForceIgnoreOutsideTouch(boolean forceIgnoreOutsideTouch) {
        this.mForceIgnoreOutsideTouch = forceIgnoreOutsideTouch;
    }

    private int buildDropDown() {
        InputMethodManager imm;
        int otherHeights = 0;
        ListAdapter adapter = this.mAdapter;
        if (adapter != null && (imm = InputMethodManager.peekInstance()) != null) {
            int count = Math.min(adapter.getCount(), 20);
            CompletionInfo[] completions = new CompletionInfo[count];
            int realCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!adapter.isEnabled(i)) continue;
                ++realCount;
                Object item = adapter.getItem(i);
                long id2 = adapter.getItemId(i);
                completions[i] = new CompletionInfo(id2, i, this.convertSelectionToString(item));
            }
            if (realCount != count) {
                CompletionInfo[] tmp = new CompletionInfo[realCount];
                System.arraycopy(completions, 0, tmp, 0, realCount);
                completions = tmp;
            }
            imm.displayCompletions(this, completions);
        }
        if (this.mDropDownList == null) {
            Context context = this.getContext();
            this.mHideSelector = new ListSelectorHider();
            this.mShowDropDownRunnable = new Runnable(){

                public void run() {
                    View view = AutoCompleteTextView.this.getDropDownAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        AutoCompleteTextView.this.showDropDown();
                    }
                }
            };
            this.mDropDownList = new DropDownListView(context);
            this.mDropDownList.setSelector(this.mDropDownListHighlight);
            this.mDropDownList.setAdapter(adapter);
            this.mDropDownList.setVerticalFadingEdgeEnabled(true);
            this.mDropDownList.setOnItemClickListener(this.mDropDownItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                @Override
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    DropDownListView dropDownList;
                    if (position != -1 && (dropDownList = AutoCompleteTextView.this.mDropDownList) != null) {
                        dropDownList.mListSelectionHidden = false;
                    }
                }

                @Override
                public void onNothingSelected(AdapterView<?> parent) {
                }
            });
            this.mDropDownList.setOnScrollListener(new PopupScrollListener());
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            ViewGroup dropDownView = this.mDropDownList;
            View hintView = this.getHintView(context);
            if (hintView != null) {
                LinearLayout hintContainer = new LinearLayout(context);
                hintContainer.setOrientation(1);
                LinearLayout.LayoutParams hintParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                hintContainer.addView((View)dropDownView, hintParams);
                hintContainer.addView(hintView);
                int widthSpec = View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE);
                int heightSpec = 0;
                hintView.measure(widthSpec, heightSpec);
                hintParams = (LinearLayout.LayoutParams)hintView.getLayoutParams();
                otherHeights = hintView.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
                dropDownView = hintContainer;
            }
            this.mPopup.setContentView(dropDownView);
        } else {
            ViewGroup dropDownView = (ViewGroup)this.mPopup.getContentView();
            View view = dropDownView.findViewById(23);
            if (view != null) {
                LinearLayout.LayoutParams hintParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                otherHeights = view.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
            }
        }
        boolean ignoreBottomDecorations = this.mPopup.getInputMethodMode() == 2;
        int maxHeight = this.mPopup.getMaxAvailableHeight(this.getDropDownAnchorView(), this.mDropDownVerticalOffset, ignoreBottomDecorations);
        int padding = 0;
        Drawable background = this.mPopup.getBackground();
        if (background != null) {
            background.getPadding(this.mTempRect);
            padding = this.mTempRect.top + this.mTempRect.bottom;
        }
        if (this.mDropDownAlwaysVisible || this.mDropDownHeight == -1) {
            return maxHeight + padding;
        }
        int listContent = this.mDropDownList.measureHeightOfChildren(0, 0, -1, maxHeight - otherHeights, 2);
        if (listContent > 0) {
            otherHeights += padding;
        }
        return listContent + otherHeights;
    }

    private View getHintView(Context context) {
        if (this.mHintText != null && this.mHintText.length() > 0) {
            TextView hintView = (TextView)LayoutInflater.from(context).inflate(this.mHintResource, null).findViewById(16908308);
            hintView.setText(this.mHintText);
            hintView.setId(23);
            return hintView;
        }
        return null;
    }

    public void setValidator(Validator validator) {
        this.mValidator = validator;
    }

    public Validator getValidator() {
        return this.mValidator;
    }

    public void performValidation() {
        if (this.mValidator == null) {
            return;
        }
        Editable text = this.getText();
        if (!TextUtils.isEmpty(text) && !this.mValidator.isValid(text)) {
            this.setText(this.mValidator.fixText(text));
        }
    }

    protected Filter getFilter() {
        return this.mFilter;
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        private PopupDataSetObserver() {
        }

        public void onChanged() {
            if (AutoCompleteTextView.this.isPopupShowing()) {
                AutoCompleteTextView.this.showDropDown();
            } else if (AutoCompleteTextView.this.mAdapter != null) {
                AutoCompleteTextView.this.post(new Runnable(){

                    public void run() {
                        ListAdapter adapter = AutoCompleteTextView.this.mAdapter;
                        if (adapter != null) {
                            AutoCompleteTextView.this.updateDropDownForFilter(adapter.getCount());
                        }
                    }
                });
            }
        }

        public void onInvalidated() {
            if (!AutoCompleteTextView.this.mDropDownAlwaysVisible) {
                AutoCompleteTextView.this.dismissDropDown();
            }
        }
    }

    private class PassThroughClickListener
    implements View.OnClickListener {
        private View.OnClickListener mWrapped;

        private PassThroughClickListener() {
        }

        public void onClick(View v) {
            AutoCompleteTextView.this.onClickImpl();
            if (this.mWrapped != null) {
                this.mWrapped.onClick(v);
            }
        }
    }

    public static interface Validator {
        public boolean isValid(CharSequence var1);

        public CharSequence fixText(CharSequence var1);
    }

    private static class DropDownListView
    extends ListView {
        private boolean mListSelectionHidden;

        public DropDownListView(Context context) {
            super(context, null, 16842861);
        }

        View obtainView(int position, boolean[] isScrap) {
            View view = super.obtainView(position, isScrap);
            if (view instanceof TextView) {
                ((TextView)view).setHorizontallyScrolling(true);
            }
            return view;
        }

        public boolean isInTouchMode() {
            return this.mListSelectionHidden || super.isInTouchMode();
        }

        public boolean hasWindowFocus() {
            return true;
        }

        public boolean isFocused() {
            return true;
        }

        public boolean hasFocus() {
            return true;
        }

        protected int[] onCreateDrawableState(int extraSpace) {
            int[] res = super.onCreateDrawableState(extraSpace);
            return res;
        }
    }

    private class DropDownItemClickListener
    implements AdapterView.OnItemClickListener {
        private DropDownItemClickListener() {
        }

        public void onItemClick(AdapterView parent, View v, int position, long id2) {
            AutoCompleteTextView.this.performCompletion(v, position, id2);
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        private PopupScrollListener() {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 1 && !AutoCompleteTextView.this.isInputMethodNotNeeded() && AutoCompleteTextView.this.mPopup.getContentView() != null) {
                AutoCompleteTextView.this.removeCallbacks(AutoCompleteTextView.this.mResizePopupRunnable);
                AutoCompleteTextView.this.mResizePopupRunnable.run();
            }
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        private PopupTouchInterceptor() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (action == 0 && AutoCompleteTextView.this.mPopup != null && AutoCompleteTextView.this.mPopup.isShowing()) {
                AutoCompleteTextView.this.postDelayed(AutoCompleteTextView.this.mResizePopupRunnable, 250L);
            } else if (action == 1) {
                AutoCompleteTextView.this.removeCallbacks(AutoCompleteTextView.this.mResizePopupRunnable);
            }
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        private ResizePopupRunnable() {
        }

        public void run() {
            AutoCompleteTextView.this.mPopup.setInputMethodMode(2);
            AutoCompleteTextView.this.showDropDown();
        }
    }

    private class ListSelectorHider
    implements Runnable {
        private ListSelectorHider() {
        }

        public void run() {
            AutoCompleteTextView.this.clearListSelection();
        }
    }

    private class MyWatcher
    implements TextWatcher {
        private MyWatcher() {
        }

        public void afterTextChanged(Editable s) {
            AutoCompleteTextView.this.doAfterTextChanged();
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            AutoCompleteTextView.this.doBeforeTextChanged();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }
}

