/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.ValueCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebStorage {
    private static final String TAG = "webstorage";
    private static WebStorage sWebStorage;
    static final int UPDATE = 0;
    static final int SET_QUOTA_ORIGIN = 1;
    static final int DELETE_ORIGIN = 2;
    static final int DELETE_ALL = 3;
    static final int GET_ORIGINS = 4;
    static final int GET_USAGE_ORIGIN = 5;
    static final int GET_QUOTA_ORIGIN = 6;
    static final int RETURN_ORIGINS = 0;
    static final int RETURN_USAGE_ORIGIN = 1;
    static final int RETURN_QUOTA_ORIGIN = 2;
    private static final String ORIGINS = "origins";
    private static final String ORIGIN = "origin";
    private static final String CALLBACK = "callback";
    private static final String USAGE = "usage";
    private static final String QUOTA = "quota";
    private Map<String, Origin> mOrigins;
    private Handler mHandler = null;
    private Handler mUIHandler = null;

    public void createUIHandler() {
        if (this.mUIHandler == null) {
            this.mUIHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Map values = (Map)msg.obj;
                            Map origins = (Map)values.get(WebStorage.ORIGINS);
                            ValueCallback callback = (ValueCallback)values.get(WebStorage.CALLBACK);
                            callback.onReceiveValue(origins);
                            break;
                        }
                        case 1: {
                            Map values = (Map)msg.obj;
                            ValueCallback callback = (ValueCallback)values.get(WebStorage.CALLBACK);
                            callback.onReceiveValue((Long)values.get(WebStorage.USAGE));
                            break;
                        }
                        case 2: {
                            Map values = (Map)msg.obj;
                            ValueCallback callback = (ValueCallback)values.get(WebStorage.CALLBACK);
                            callback.onReceiveValue((Long)values.get(WebStorage.QUOTA));
                        }
                    }
                }
            };
        }
    }

    public synchronized void createHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            Origin website = (Origin)msg.obj;
                            WebStorage.nativeSetQuotaForOrigin(website.getOrigin(), website.getQuota());
                            break;
                        }
                        case 2: {
                            Origin website = (Origin)msg.obj;
                            WebStorage.nativeDeleteOrigin(website.getOrigin());
                            break;
                        }
                        case 3: {
                            WebStorage.nativeDeleteAllData();
                            break;
                        }
                        case 4: {
                            WebStorage.this.syncValues();
                            ValueCallback callback = (ValueCallback)msg.obj;
                            HashMap origins = new HashMap(WebStorage.this.mOrigins);
                            HashMap<String, Object> values = new HashMap<String, Object>();
                            values.put(WebStorage.CALLBACK, callback);
                            values.put(WebStorage.ORIGINS, origins);
                            WebStorage.this.postUIMessage(Message.obtain(null, 0, values));
                            break;
                        }
                        case 5: {
                            WebStorage.this.syncValues();
                            Map values = (Map)msg.obj;
                            String origin = (String)values.get(WebStorage.ORIGIN);
                            ValueCallback callback = (ValueCallback)values.get(WebStorage.CALLBACK);
                            Origin website = (Origin)WebStorage.this.mOrigins.get(origin);
                            HashMap<String, Object> retValues = new HashMap<String, Object>();
                            retValues.put(WebStorage.CALLBACK, callback);
                            if (website != null) {
                                long usage = website.getUsage();
                                retValues.put(WebStorage.USAGE, new Long(usage));
                            }
                            WebStorage.this.postUIMessage(Message.obtain(null, 1, retValues));
                            break;
                        }
                        case 6: {
                            WebStorage.this.syncValues();
                            Map values = (Map)msg.obj;
                            String origin = (String)values.get(WebStorage.ORIGIN);
                            ValueCallback callback = (ValueCallback)values.get(WebStorage.CALLBACK);
                            Origin website = (Origin)WebStorage.this.mOrigins.get(origin);
                            HashMap<String, Object> retValues = new HashMap<String, Object>();
                            retValues.put(WebStorage.CALLBACK, callback);
                            if (website != null) {
                                long quota = website.getQuota();
                                retValues.put(WebStorage.QUOTA, new Long(quota));
                            }
                            WebStorage.this.postUIMessage(Message.obtain(null, 2, retValues));
                            break;
                        }
                        case 0: {
                            WebStorage.this.syncValues();
                        }
                    }
                }
            };
        }
    }

    public void getOrigins(ValueCallback<Map> callback) {
        if (callback != null) {
            if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
                this.syncValues();
                callback.onReceiveValue(this.mOrigins);
            } else {
                this.postMessage(Message.obtain(null, 4, callback));
            }
        }
    }

    Collection<Origin> getOriginsSync() {
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            this.update();
            return this.mOrigins.values();
        }
        return null;
    }

    public void getUsageForOrigin(String origin, ValueCallback<Long> callback) {
        if (callback == null) {
            return;
        }
        if (origin == null) {
            callback.onReceiveValue(null);
            return;
        }
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            this.syncValues();
            Origin website = this.mOrigins.get(origin);
            callback.onReceiveValue(new Long(website.getUsage()));
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(ORIGIN, origin);
            values.put(CALLBACK, callback);
            this.postMessage(Message.obtain(null, 5, values));
        }
    }

    public void getQuotaForOrigin(String origin, ValueCallback<Long> callback) {
        if (callback == null) {
            return;
        }
        if (origin == null) {
            callback.onReceiveValue(null);
            return;
        }
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            this.syncValues();
            Origin website = this.mOrigins.get(origin);
            callback.onReceiveValue(new Long(website.getUsage()));
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(ORIGIN, origin);
            values.put(CALLBACK, callback);
            this.postMessage(Message.obtain(null, 6, values));
        }
    }

    public void setQuotaForOrigin(String origin, long quota) {
        if (origin != null) {
            if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
                WebStorage.nativeSetQuotaForOrigin(origin, quota);
            } else {
                this.postMessage(Message.obtain(null, 1, new Origin(origin, quota)));
            }
        }
    }

    public void deleteOrigin(String origin) {
        if (origin != null) {
            if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
                WebStorage.nativeDeleteOrigin(origin);
            } else {
                this.postMessage(Message.obtain(null, 2, new Origin(origin)));
            }
        }
    }

    public void deleteAllData() {
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            WebStorage.nativeDeleteAllData();
        } else {
            this.postMessage(Message.obtain(null, 3));
        }
    }

    public void setAppCacheMaximumSize(long size) {
        WebStorage.nativeSetAppCacheMaximumSize(size);
    }

    private synchronized void postMessage(Message msg) {
        if (this.mHandler != null) {
            this.mHandler.sendMessage(msg);
        }
    }

    private void postUIMessage(Message msg) {
        if (this.mUIHandler != null) {
            this.mUIHandler.sendMessage(msg);
        }
    }

    public static WebStorage getInstance() {
        if (sWebStorage == null) {
            sWebStorage = new WebStorage();
        }
        return sWebStorage;
    }

    public void update() {
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            this.syncValues();
        } else {
            this.postMessage(Message.obtain(null, 0));
        }
    }

    private void syncValues() {
        Set tmp = WebStorage.nativeGetOrigins();
        this.mOrigins = new HashMap<String, Origin>();
        for (String origin : tmp) {
            Origin website = new Origin(origin, WebStorage.nativeGetQuotaForOrigin(origin), WebStorage.nativeGetUsageForOrigin(origin));
            this.mOrigins.put(origin, website);
        }
    }

    private static native Set nativeGetOrigins();

    private static native long nativeGetUsageForOrigin(String var0);

    private static native long nativeGetQuotaForOrigin(String var0);

    private static native void nativeSetQuotaForOrigin(String var0, long var1);

    private static native void nativeDeleteOrigin(String var0);

    private static native void nativeDeleteAllData();

    private static native void nativeSetAppCacheMaximumSize(long var0);

    static class Origin {
        String mOrigin = null;
        long mQuota = 0L;
        long mUsage = 0L;

        public Origin(String origin, long quota, long usage) {
            this.mOrigin = origin;
            this.mQuota = quota;
            this.mUsage = usage;
        }

        public Origin(String origin, long quota) {
            this.mOrigin = origin;
            this.mQuota = quota;
        }

        public Origin(String origin) {
            this.mOrigin = origin;
        }

        public String getOrigin() {
            return this.mOrigin;
        }

        public long getQuota() {
            return this.mQuota;
        }

        public long getUsage() {
            return this.mUsage;
        }
    }

    public static interface QuotaUpdater {
        public void updateQuota(long var1);
    }
}

