/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Dialog;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;

class PluginFullScreenHolder
extends Dialog {
    private final WebView mWebView;
    private final int mNpp;
    private View mContentView;

    PluginFullScreenHolder(WebView webView, int npp) {
        super(webView.getContext(), 16973831);
        this.mWebView = webView;
        this.mNpp = npp;
    }

    public void setContentView(View contentView) {
        SurfaceView sView;
        contentView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (contentView instanceof SurfaceView && (sView = (SurfaceView)contentView).isFixedSize()) {
            sView.getHolder().setSizeFromLayout();
        }
        super.setContentView(contentView);
        this.mContentView = contentView;
    }

    public void onBackPressed() {
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.isSystem()) {
            return super.onKeyDown(keyCode, event);
        }
        this.mWebView.onKeyDown(keyCode, event);
        return true;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isSystem()) {
            return super.onKeyUp(keyCode, event);
        }
        this.mWebView.onKeyUp(keyCode, event);
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        this.mWebView.onTrackballEvent(event);
        return true;
    }

    protected void onStop() {
        super.onStop();
        if (this.mContentView != null && this.mContentView.getParent() != null) {
            ViewGroup vg = (ViewGroup)this.mContentView.getParent();
            vg.removeView(this.mContentView);
        }
        this.mWebView.getWebViewCore().sendMessage(182, this.mNpp, 0);
    }
}

