/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslError;
import android.os.Bundle;
import android.webkit.HttpAuthHandler;
import android.webkit.LoadListener;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import java.io.ByteArrayInputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Network {
    private static final String LOGTAG = "network";
    private static Network sNetwork;
    private static boolean sPlatformNotifications;
    private static int sPlatformNotificationEnableRefCount;
    private String mProxyUsername;
    private String mProxyPassword;
    private RequestQueue mRequestQueue;
    private SslErrorHandler mSslErrorHandler = new SslErrorHandler();
    private HttpAuthHandler mHttpAuthHandler = new HttpAuthHandler(this);

    public static synchronized Network getInstance(Context context) {
        if (sNetwork == null) {
            sNetwork = new Network(context.getApplicationContext());
            if (sPlatformNotifications) {
                --sPlatformNotificationEnableRefCount;
                Network.enablePlatformNotifications();
            }
        }
        return sNetwork;
    }

    public static void enablePlatformNotifications() {
        if (++sPlatformNotificationEnableRefCount == 1) {
            if (sNetwork != null) {
                Network.sNetwork.mRequestQueue.enablePlatformNotifications();
            } else {
                sPlatformNotifications = true;
            }
        }
    }

    public static void disablePlatformNotifications() {
        if (--sPlatformNotificationEnableRefCount == 0) {
            if (sNetwork != null) {
                Network.sNetwork.mRequestQueue.disablePlatformNotifications();
            } else {
                sPlatformNotifications = false;
            }
        }
    }

    private Network(Context context) {
        this.mRequestQueue = new RequestQueue(context);
    }

    public boolean requestURL(String method, Map<String, String> headers, byte[] postData, LoadListener loader) {
        String url = loader.url();
        if (!URLUtil.isValidUrl(url)) {
            return false;
        }
        if (URLUtil.isAssetUrl(url) || URLUtil.isResourceUrl(url) || URLUtil.isFileUrl(url) || URLUtil.isDataUrl(url)) {
            return false;
        }
        ByteArrayInputStream bodyProvider = null;
        int bodyLength = 0;
        if (postData != null) {
            bodyLength = postData.length;
            bodyProvider = new ByteArrayInputStream(postData);
        }
        RequestQueue q = this.mRequestQueue;
        RequestHandle handle = null;
        if (loader.isSynchronous()) {
            handle = q.queueSynchronousRequest(url, loader.getWebAddress(), method, headers, loader, bodyProvider, bodyLength);
            loader.attachRequestHandle(handle);
            handle.processRequest();
            loader.loadSynchronousMessages();
        } else {
            handle = q.queueRequest(url, loader.getWebAddress(), method, headers, loader, bodyProvider, bodyLength);
            loader.attachRequestHandle(handle);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidProxySet() {
        RequestQueue requestQueue = this.mRequestQueue;
        synchronized (requestQueue) {
            return this.mRequestQueue.getProxyHost() != null;
        }
    }

    public String getProxyHostname() {
        return this.mRequestQueue.getProxyHost().getHostName();
    }

    public synchronized String getProxyUsername() {
        return this.mProxyUsername;
    }

    public synchronized void setProxyUsername(String proxyUsername) {
        this.mProxyUsername = proxyUsername;
    }

    public synchronized String getProxyPassword() {
        return this.mProxyPassword;
    }

    public synchronized void setProxyPassword(String proxyPassword) {
        this.mProxyPassword = proxyPassword;
    }

    public boolean saveState(Bundle outState) {
        return this.mSslErrorHandler.saveState(outState);
    }

    public boolean restoreState(Bundle inState) {
        return this.mSslErrorHandler.restoreState(inState);
    }

    public void clearUserSslPrefTable() {
        this.mSslErrorHandler.clear();
    }

    public void handleSslErrorRequest(LoadListener loader) {
        if (loader != null) {
            this.mSslErrorHandler.handleSslErrorRequest(loader);
        }
    }

    boolean checkSslPrefTable(LoadListener loader, SslError error) {
        if (loader != null && error != null) {
            return this.mSslErrorHandler.checkSslPrefTable(loader, error);
        }
        return false;
    }

    public void handleAuthRequest(LoadListener loader) {
        if (loader != null) {
            this.mHttpAuthHandler.handleAuthRequest(loader);
        }
    }

    public void startTiming() {
        this.mRequestQueue.startTiming();
    }

    public void stopTiming() {
        this.mRequestQueue.stopTiming();
    }
}

