/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.VideoView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class HTML5VideoViewProxy
extends Handler
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static final String LOGTAG = "HTML5VideoViewProxy";
    private static final int PLAY = 100;
    private static final int SEEK = 101;
    private static final int PAUSE = 102;
    private static final int ERROR = 103;
    private static final int LOAD_DEFAULT_POSTER = 104;
    private static final int PREPARED = 200;
    private static final int ENDED = 201;
    private static final int POSTER_FETCHED = 202;
    private static final int PAUSED = 203;
    private static final String COOKIE = "Cookie";
    private static final int TIMEUPDATE = 300;
    int mNativePointer;
    private Handler mWebCoreHandler;
    private WebView mWebView;
    private Bitmap mPoster;
    private PosterDownloader mPosterDownloader;
    private int mSeekPosition;

    public void onPrepared(MediaPlayer mp) {
        VideoPlayer.onPrepared();
        Message msg = Message.obtain(this.mWebCoreHandler, 200);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("dur", new Integer(mp.getDuration()));
        map.put("width", new Integer(mp.getVideoWidth()));
        map.put("height", new Integer(mp.getVideoHeight()));
        msg.obj = map;
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void onCompletion(MediaPlayer mp) {
        this.sendMessage(this.obtainMessage(201, 1, 0));
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.sendMessage(this.obtainMessage(103));
        return false;
    }

    public void dispatchOnEnded() {
        Message msg = Message.obtain(this.mWebCoreHandler, 201);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void dispatchOnPaused() {
        Message msg = Message.obtain(this.mWebCoreHandler, 203);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void onTimeupdate() {
        this.sendMessage(this.obtainMessage(300));
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                String url = (String)msg.obj;
                WebChromeClient client = this.mWebView.getWebChromeClient();
                if (client == null) break;
                VideoPlayer.play(url, this.mSeekPosition, this, client);
                break;
            }
            case 101: {
                Integer time = (Integer)msg.obj;
                this.mSeekPosition = time;
                VideoPlayer.seek(this.mSeekPosition, this);
                break;
            }
            case 102: {
                VideoPlayer.pause(this);
                break;
            }
            case 201: {
                if (msg.arg1 == 1) {
                    VideoPlayer.isVideoSelfEnded = true;
                }
            }
            case 103: {
                WebChromeClient client = this.mWebView.getWebChromeClient();
                if (client == null) break;
                client.onHideCustomView();
                break;
            }
            case 104: {
                WebChromeClient client = this.mWebView.getWebChromeClient();
                if (client == null) break;
                this.doSetPoster(client.getDefaultVideoPoster());
                break;
            }
            case 300: {
                if (!VideoPlayer.isPlaying(this)) break;
                this.sendTimeupdate();
            }
        }
    }

    private HTML5VideoViewProxy(WebView webView, int nativePtr) {
        super(Looper.getMainLooper());
        this.mWebView = webView;
        this.mNativePointer = nativePtr;
        this.createWebCoreHandler();
    }

    private void createWebCoreHandler() {
        this.mWebCoreHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 200: {
                        Map map = (Map)msg.obj;
                        Integer duration = (Integer)map.get("dur");
                        Integer width = (Integer)map.get("width");
                        Integer height = (Integer)map.get("height");
                        HTML5VideoViewProxy.this.nativeOnPrepared(duration, width, height, HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 201: {
                        HTML5VideoViewProxy.this.nativeOnEnded(HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 203: {
                        HTML5VideoViewProxy.this.nativeOnPaused(HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 202: {
                        Bitmap poster = (Bitmap)msg.obj;
                        HTML5VideoViewProxy.this.nativeOnPosterFetched(poster, HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 300: {
                        HTML5VideoViewProxy.this.nativeOnTimeupdate(msg.arg1, HTML5VideoViewProxy.this.mNativePointer);
                    }
                }
            }
        };
    }

    private void doSetPoster(Bitmap poster) {
        if (poster == null) {
            return;
        }
        this.mPoster = poster;
        Message msg = Message.obtain(this.mWebCoreHandler, 202);
        msg.obj = poster;
        this.mWebCoreHandler.sendMessage(msg);
    }

    private void sendTimeupdate() {
        Message msg = Message.obtain(this.mWebCoreHandler, 300);
        msg.arg1 = VideoPlayer.getCurrentPosition();
        this.mWebCoreHandler.sendMessage(msg);
    }

    public Context getContext() {
        return this.mWebView.getContext();
    }

    public void play(String url) {
        if (url == null) {
            return;
        }
        Message message = this.obtainMessage(100);
        message.obj = url;
        this.sendMessage(message);
    }

    public void seek(int time) {
        Message message = this.obtainMessage(101);
        message.obj = new Integer(time);
        this.sendMessage(message);
    }

    public void pause() {
        Message message = this.obtainMessage(102);
        this.sendMessage(message);
    }

    public void teardown() {
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mNativePointer = 0;
    }

    public void loadPoster(String url) {
        if (url == null) {
            Message message = this.obtainMessage(104);
            this.sendMessage(message);
            return;
        }
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mPosterDownloader = new PosterDownloader(url, this);
        this.mPosterDownloader.start();
    }

    public static HTML5VideoViewProxy getInstance(WebViewCore webViewCore, int nativePtr) {
        return new HTML5VideoViewProxy(webViewCore.getWebView(), nativePtr);
    }

    WebView getWebView() {
        return this.mWebView;
    }

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnEnded(int var1);

    private native void nativeOnPaused(int var1);

    private native void nativeOnPosterFetched(Bitmap var1, int var2);

    private native void nativeOnTimeupdate(int var1, int var2);

    private static final class PosterDownloader
    implements EventHandler {
        private static RequestQueue mRequestQueue;
        private static int mQueueRefCount;
        private String mUrl;
        private final HTML5VideoViewProxy mProxy;
        private ByteArrayOutputStream mPosterBytes;
        private RequestHandle mRequestHandle;
        private int mStatusCode;
        private Headers mHeaders;
        private Handler mHandler;

        public PosterDownloader(String url, HTML5VideoViewProxy proxy) {
            this.mUrl = url;
            this.mProxy = proxy;
            this.mHandler = new Handler();
        }

        public void start() {
            this.retainQueue();
            this.mRequestHandle = mRequestQueue.queueRequest(this.mUrl, "GET", null, this, null, 0);
        }

        public void cancelAndReleaseQueue() {
            if (this.mRequestHandle != null) {
                this.mRequestHandle.cancel();
                this.mRequestHandle = null;
            }
            this.releaseQueue();
        }

        public void status(int major_version, int minor_version, int code, String reason_phrase) {
            this.mStatusCode = code;
        }

        public void headers(Headers headers) {
            this.mHeaders = headers;
        }

        public void data(byte[] data, int len) {
            if (this.mPosterBytes == null) {
                this.mPosterBytes = new ByteArrayOutputStream();
            }
            this.mPosterBytes.write(data, 0, len);
        }

        public void endData() {
            if (this.mStatusCode == 200) {
                if (this.mPosterBytes.size() > 0) {
                    Bitmap poster = BitmapFactory.decodeByteArray(this.mPosterBytes.toByteArray(), 0, this.mPosterBytes.size());
                    this.mProxy.doSetPoster(poster);
                }
                this.cleanup();
            } else if (this.mStatusCode >= 300 && this.mStatusCode < 400) {
                this.mUrl = this.mHeaders.getLocation();
                if (this.mUrl != null) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            if (PosterDownloader.this.mRequestHandle != null) {
                                PosterDownloader.this.mRequestHandle.setupRedirect(PosterDownloader.this.mUrl, PosterDownloader.this.mStatusCode, new HashMap<String, String>());
                            }
                        }
                    });
                }
            }
        }

        public void certificate(SslCertificate certificate) {
        }

        public void error(int id2, String description) {
            this.cleanup();
        }

        public boolean handleSslErrorRequest(SslError error) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            if (this.mPosterBytes != null) {
                try {
                    try {
                        this.mPosterBytes.close();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        this.mPosterBytes = null;
                    }
                    Object var3_1 = null;
                    this.mPosterBytes = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.mPosterBytes = null;
                    throw throwable;
                }
            }
        }

        private void retainQueue() {
            if (mRequestQueue == null) {
                mRequestQueue = new RequestQueue(this.mProxy.getContext());
            }
            ++mQueueRefCount;
        }

        private void releaseQueue() {
            if (mQueueRefCount == 0) {
                return;
            }
            if (--mQueueRefCount == 0) {
                mRequestQueue.shutdown();
                mRequestQueue = null;
            }
        }

        static {
            mQueueRefCount = 0;
        }
    }

    private static final class VideoPlayer {
        private static HTML5VideoViewProxy mCurrentProxy;
        private static VideoView mVideoView;
        private static View mProgressView;
        private static FrameLayout mLayout;
        private static Timer mTimer;
        private static final int TIMEUPDATE_PERIOD = 250;
        static boolean isVideoSelfEnded;
        private static final WebChromeClient.CustomViewCallback mCallback;

        private VideoPlayer() {
        }

        public static void play(String url, int time, HTML5VideoViewProxy proxy, WebChromeClient client) {
            if (mCurrentProxy == proxy) {
                if (!mVideoView.isPlaying()) {
                    mVideoView.start();
                }
                return;
            }
            if (mCurrentProxy != null) {
                proxy.dispatchOnEnded();
                return;
            }
            mCurrentProxy = proxy;
            mLayout = new FrameLayout(proxy.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            mVideoView = new VideoView(proxy.getContext());
            mVideoView.setWillNotDraw(false);
            mVideoView.setMediaController(new MediaController(proxy.getContext()));
            String cookieValue = CookieManager.getInstance().getCookie(url);
            HashMap<String, String> headers = null;
            if (cookieValue != null) {
                headers = new HashMap<String, String>();
                headers.put(HTML5VideoViewProxy.COOKIE, cookieValue);
            }
            mVideoView.setVideoURI(Uri.parse(url), headers);
            mVideoView.setOnCompletionListener(proxy);
            mVideoView.setOnPreparedListener(proxy);
            mVideoView.setOnErrorListener(proxy);
            mVideoView.seekTo(time);
            mLayout.addView((View)mVideoView, layoutParams);
            mProgressView = client.getVideoLoadingProgressView();
            if (mProgressView != null) {
                mLayout.addView(mProgressView, layoutParams);
                mProgressView.setVisibility(0);
            }
            mLayout.setVisibility(0);
            mTimer = new Timer();
            mVideoView.start();
            client.onShowCustomView(mLayout, mCallback);
            mCurrentProxy.getWebView().getViewManager().hideAll();
        }

        public static boolean isPlaying(HTML5VideoViewProxy proxy) {
            return mCurrentProxy == proxy && mVideoView != null && mVideoView.isPlaying();
        }

        public static int getCurrentPosition() {
            int currentPosMs = 0;
            if (mVideoView != null) {
                currentPosMs = mVideoView.getCurrentPosition();
            }
            return currentPosMs;
        }

        public static void seek(int time, HTML5VideoViewProxy proxy) {
            if (mCurrentProxy == proxy && time >= 0 && mVideoView != null) {
                mVideoView.seekTo(time);
            }
        }

        public static void pause(HTML5VideoViewProxy proxy) {
            if (mCurrentProxy == proxy && mVideoView != null) {
                mVideoView.pause();
                mTimer.purge();
            }
        }

        public static void onPrepared() {
            if (mProgressView == null || mLayout == null) {
                return;
            }
            mTimer.schedule((TimerTask)new TimeupdateTask(mCurrentProxy), 250L, 250L);
            mProgressView.setVisibility(8);
            mLayout.removeView(mProgressView);
            mProgressView = null;
        }

        static {
            isVideoSelfEnded = false;
            mCallback = new WebChromeClient.CustomViewCallback(){

                public void onCustomViewHidden() {
                    mTimer.cancel();
                    mTimer = null;
                    if (mVideoView.isPlaying()) {
                        mVideoView.stopPlayback();
                    }
                    if (isVideoSelfEnded) {
                        mCurrentProxy.dispatchOnEnded();
                    } else {
                        mCurrentProxy.dispatchOnPaused();
                    }
                    mCurrentProxy.getWebView().getViewManager().showAll();
                    isVideoSelfEnded = false;
                    mCurrentProxy = null;
                    mLayout.removeView(mVideoView);
                    mVideoView = null;
                    if (mProgressView != null) {
                        mLayout.removeView(mProgressView);
                        mProgressView = null;
                    }
                    mLayout = null;
                }
            };
        }

        private static final class TimeupdateTask
        extends TimerTask {
            private HTML5VideoViewProxy mProxy;

            public TimeupdateTask(HTML5VideoViewProxy proxy) {
                this.mProxy = proxy;
            }

            public void run() {
                this.mProxy.onTimeupdate();
            }
        }
    }
}

