/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public final class InputChannel
implements Parcelable {
    private static final String TAG = "InputChannel";
    private static final boolean DEBUG = false;
    public static final Parcelable.Creator<InputChannel> CREATOR = new Parcelable.Creator<InputChannel>(){

        @Override
        public InputChannel createFromParcel(Parcel source) {
            InputChannel result = new InputChannel();
            result.readFromParcel(source);
            return result;
        }

        public InputChannel[] newArray(int size) {
            return new InputChannel[size];
        }
    };
    private int mPtr;
    private boolean mDisposeAfterWriteToParcel;

    private static native InputChannel[] nativeOpenInputChannelPair(String var0);

    private native void nativeDispose(boolean var1);

    private native void nativeTransferTo(InputChannel var1);

    private native void nativeReadFromParcel(Parcel var1);

    private native void nativeWriteToParcel(Parcel var1);

    private native String nativeGetName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.nativeDispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public static InputChannel[] openInputChannelPair(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return InputChannel.nativeOpenInputChannelPair(name);
    }

    public String getName() {
        String name = this.nativeGetName();
        return name != null ? name : "uninitialized";
    }

    public void dispose() {
        this.nativeDispose(false);
    }

    public void transferToBinderOutParameter(InputChannel outParameter) {
        if (outParameter == null) {
            throw new IllegalArgumentException("outParameter must not be null");
        }
        this.nativeTransferTo(outParameter);
        outParameter.mDisposeAfterWriteToParcel = true;
    }

    public int describeContents() {
        return 1;
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        this.nativeReadFromParcel(in);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        this.nativeWriteToParcel(out);
        if (this.mDisposeAfterWriteToParcel) {
            this.dispose();
        }
    }

    public String toString() {
        return this.getName();
    }
}

