/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.DisplayMetrics;

public class Display {
    public static final int DEFAULT_DISPLAY = 0;
    private int mDisplay;
    private int mPixelFormat;
    private float mRefreshRate;
    private float mDensity;
    private float mDpiX;
    private float mDpiY;
    private static final Object mStaticInit = new Object();
    private static boolean mInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Display(int display) {
        Object object = mStaticInit;
        synchronized (object) {
            if (!mInitialized) {
                Display.nativeClassInit();
                mInitialized = true;
            }
        }
        this.mDisplay = display;
        this.init(display);
    }

    public int getDisplayId() {
        return this.mDisplay;
    }

    static native int getDisplayCount();

    public native int getWidth();

    public native int getHeight();

    public int getRotation() {
        return this.getOrientation();
    }

    @Deprecated
    public native int getOrientation();

    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public float getRefreshRate() {
        return this.mRefreshRate;
    }

    public void getMetrics(DisplayMetrics outMetrics) {
        outMetrics.widthPixels = this.getWidth();
        outMetrics.heightPixels = this.getHeight();
        outMetrics.density = this.mDensity;
        outMetrics.densityDpi = (int)(this.mDensity * 160.0f + 0.5f);
        outMetrics.scaledDensity = outMetrics.density;
        outMetrics.xdpi = this.mDpiX;
        outMetrics.ydpi = this.mDpiY;
    }

    private static native void nativeClassInit();

    private native void init(int var1);

    public static Display createMetricsBasedDisplay(int displayId, DisplayMetrics metrics) {
        return new CompatibleDisplay(displayId, metrics);
    }

    private static class CompatibleDisplay
    extends Display {
        private final DisplayMetrics mMetrics;

        private CompatibleDisplay(int displayId, DisplayMetrics metrics) {
            super(displayId);
            this.mMetrics = metrics;
        }

        public int getWidth() {
            return this.mMetrics.widthPixels;
        }

        public int getHeight() {
            return this.mMetrics.heightPixels;
        }
    }
}

