/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.CompatibilityInfo;
import android.os.SystemProperties;

public class DisplayMetrics {
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_DEFAULT = 160;
    public static final int DENSITY_DEVICE = DisplayMetrics.getDeviceDensity();
    public int widthPixels;
    public int heightPixels;
    public float density;
    public int densityDpi;
    public float scaledDensity;
    public float xdpi;
    public float ydpi;

    public void setTo(DisplayMetrics o) {
        this.widthPixels = o.widthPixels;
        this.heightPixels = o.heightPixels;
        this.density = o.density;
        this.densityDpi = o.densityDpi;
        this.scaledDensity = o.scaledDensity;
        this.xdpi = o.xdpi;
        this.ydpi = o.ydpi;
    }

    public void setToDefaults() {
        this.widthPixels = 0;
        this.heightPixels = 0;
        this.density = (float)DENSITY_DEVICE / 160.0f;
        this.densityDpi = DENSITY_DEVICE;
        this.scaledDensity = this.density;
        this.xdpi = DENSITY_DEVICE;
        this.ydpi = DENSITY_DEVICE;
    }

    public void updateMetrics(CompatibilityInfo compatibilityInfo, int orientation, int screenLayout) {
        boolean expandable = compatibilityInfo.isConfiguredExpandable();
        boolean largeScreens = compatibilityInfo.isConfiguredLargeScreens();
        boolean xlargeScreens = compatibilityInfo.isConfiguredXLargeScreens();
        if (!expandable) {
            if ((screenLayout & 0x10000000) == 0) {
                expandable = true;
                compatibilityInfo.setExpandable(true);
            } else {
                compatibilityInfo.setExpandable(false);
            }
        }
        if (!largeScreens) {
            if ((screenLayout & 0xF) != 3) {
                largeScreens = true;
                compatibilityInfo.setLargeScreens(true);
            } else {
                compatibilityInfo.setLargeScreens(false);
            }
        }
        if (!xlargeScreens) {
            if ((screenLayout & 0xF) != 4) {
                xlargeScreens = true;
                compatibilityInfo.setXLargeScreens(true);
            } else {
                compatibilityInfo.setXLargeScreens(false);
            }
        }
        if (!expandable || !largeScreens && !xlargeScreens) {
            int defaultHeight;
            int defaultWidth;
            switch (orientation) {
                case 2: {
                    defaultWidth = (int)(480.0f * this.density + 0.5f);
                    defaultHeight = (int)(320.0f * this.density + 0.5f);
                    break;
                }
                default: {
                    defaultWidth = (int)(320.0f * this.density + 0.5f);
                    defaultHeight = (int)(480.0f * this.density + 0.5f);
                    break;
                }
                case 0: {
                    return;
                }
            }
            if (defaultWidth < this.widthPixels) {
                this.widthPixels = defaultWidth;
            }
            if (defaultHeight < this.heightPixels) {
                this.heightPixels = defaultHeight;
            }
        }
        if (compatibilityInfo.isScalingRequired()) {
            float invertedRatio = compatibilityInfo.applicationInvertedScale;
            this.density *= invertedRatio;
            this.densityDpi = (int)(this.density * 160.0f + 0.5f);
            this.scaledDensity *= invertedRatio;
            this.xdpi *= invertedRatio;
            this.ydpi *= invertedRatio;
            this.widthPixels = (int)((float)this.widthPixels * invertedRatio + 0.5f);
            this.heightPixels = (int)((float)this.heightPixels * invertedRatio + 0.5f);
        }
    }

    public String toString() {
        return "DisplayMetrics{density=" + this.density + ", width=" + this.widthPixels + ", height=" + this.heightPixels + ", scaledDensity=" + this.scaledDensity + ", xdpi=" + this.xdpi + ", ydpi=" + this.ydpi + "}";
    }

    private static int getDeviceDensity() {
        return SystemProperties.getInt("qemu.sf.lcd_density", SystemProperties.getInt("ro.sf.lcd_density", 160));
    }
}

