/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;

public class DrawableMarginSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private Drawable mDrawable;
    private int mPad;

    public DrawableMarginSpan(Drawable b) {
        this.mDrawable = b;
    }

    public DrawableMarginSpan(Drawable b, int pad) {
        this.mDrawable = b;
        this.mPad = pad;
    }

    public int getLeadingMargin(boolean first) {
        return this.mDrawable.getIntrinsicWidth() + this.mPad;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
        int st = ((Spanned)text).getSpanStart(this);
        int ix = x;
        int itop = layout2.getLineTop(layout2.getLineForOffset(st));
        int dw = this.mDrawable.getIntrinsicWidth();
        int dh = this.mDrawable.getIntrinsicHeight();
        if (dir < 0) {
            x -= dw;
        }
        this.mDrawable.setBounds(ix, itop, ix + dw, itop + dh);
        this.mDrawable.draw(c);
    }

    public void chooseHeight(CharSequence text, int start, int end, int istartv, int v, Paint.FontMetricsInt fm) {
        if (end == ((Spanned)text).getSpanEnd(this)) {
            int ht = this.mDrawable.getIntrinsicHeight();
            int need = ht - (v + fm.descent - fm.ascent - istartv);
            if (need > 0) {
                fm.descent += need;
            }
            if ((need = ht - (v + fm.bottom - fm.top - istartv)) > 0) {
                fm.bottom += need;
            }
        }
    }
}

