/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.emoji.EmojiFactory;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.GetChars;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.Styled;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.text.style.AlignmentSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.ParagraphStyle;
import android.text.style.ReplacementSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;

public abstract class Layout {
    private static final boolean DEBUG = false;
    private static final ParagraphStyle[] NO_PARA_SPANS = ArrayUtils.emptyArray(ParagraphStyle.class);
    static final EmojiFactory EMOJI_FACTORY = EmojiFactory.newAvailableInstance();
    static final int MIN_EMOJI;
    static final int MAX_EMOJI;
    private RectF mEmojiRect;
    private CharSequence mText;
    private TextPaint mPaint;
    TextPaint mWorkPaint;
    private int mWidth;
    private Alignment mAlignment = Alignment.ALIGN_NORMAL;
    private float mSpacingMult;
    private float mSpacingAdd;
    private static Rect sTempRect;
    private boolean mSpannedText;
    public static final int DIR_LEFT_TO_RIGHT = 1;
    public static final int DIR_RIGHT_TO_LEFT = -1;
    static final int DIR_REQUEST_LTR = 1;
    static final int DIR_REQUEST_RTL = -1;
    static final int DIR_REQUEST_DEFAULT_LTR = 2;
    static final int DIR_REQUEST_DEFAULT_RTL = -2;
    private static final int TAB_INCREMENT = 20;
    static final Directions DIRS_ALL_LEFT_TO_RIGHT;
    static final Directions DIRS_ALL_RIGHT_TO_LEFT;

    public static float getDesiredWidth(CharSequence source, TextPaint paint) {
        return Layout.getDesiredWidth(source, 0, source.length(), paint);
    }

    public static float getDesiredWidth(CharSequence source, int start, int end, TextPaint paint) {
        float need = 0.0f;
        TextPaint workPaint = new TextPaint();
        int i = start;
        while (i <= end) {
            float w;
            int next = TextUtils.indexOf(source, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if ((w = Layout.measureText(paint, workPaint, source, i, next, null, true, null)) > need) {
                need = w;
            }
            i = ++next;
        }
        return need;
    }

    protected Layout(CharSequence text, TextPaint paint, int width, Alignment align, float spacingMult, float spacingAdd) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWorkPaint = new TextPaint();
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingMult;
        this.mSpacingAdd = spacingAdd;
        this.mSpannedText = text instanceof Spanned;
    }

    void replaceWith(CharSequence text, TextPaint paint, int width, Alignment align, float spacingmult, float spacingadd) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingmult;
        this.mSpacingAdd = spacingadd;
        this.mSpannedText = text instanceof Spanned;
    }

    public void draw(Canvas c) {
        this.draw(c, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas c, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        int dbottom;
        int dtop;
        Rect rect = sTempRect;
        synchronized (rect) {
            if (!c.getClipBounds(sTempRect)) {
                return;
            }
            dtop = Layout.sTempRect.top;
            dbottom = Layout.sTempRect.bottom;
        }
        int top = 0;
        int bottom = this.getLineTop(this.getLineCount());
        if (dtop > top) {
            top = dtop;
        }
        if (dbottom < bottom) {
            bottom = dbottom;
        }
        int first = this.getLineForVertical(top);
        int last = this.getLineForVertical(bottom);
        int previousLineBottom = this.getLineTop(first);
        int previousLineEnd = this.getLineStart(first);
        TextPaint paint = this.mPaint;
        CharSequence buf = this.mText;
        int width = this.mWidth;
        boolean spannedText = this.mSpannedText;
        Object[] spans = NO_PARA_SPANS;
        int spanend = 0;
        int textLength = 0;
        if (spannedText) {
            textLength = buf.length();
            for (int i = first; i <= last; ++i) {
                int lbottom;
                int end;
                int start = previousLineEnd;
                previousLineEnd = end = this.getLineStart(i + 1);
                int ltop = previousLineBottom;
                previousLineBottom = lbottom = this.getLineTop(i + 1);
                int lbaseline = lbottom - this.getLineDescent(i);
                if (start >= spanend) {
                    Spanned sp = (Spanned)buf;
                    spanend = sp.nextSpanTransition(start, textLength, LineBackgroundSpan.class);
                    spans = sp.getSpans(start, spanend, LineBackgroundSpan.class);
                }
                for (int n = 0; n < spans.length; ++n) {
                    LineBackgroundSpan back = (LineBackgroundSpan)spans[n];
                    back.drawBackground(c, paint, 0, width, ltop, lbaseline, lbottom, buf, start, end, i);
                }
            }
            spanend = 0;
            previousLineBottom = this.getLineTop(first);
            previousLineEnd = this.getLineStart(first);
            spans = NO_PARA_SPANS;
        }
        if (highlight != null) {
            if (cursorOffsetVertical != 0) {
                c.translate(0.0f, cursorOffsetVertical);
            }
            c.drawPath(highlight, highlightPaint);
            if (cursorOffsetVertical != 0) {
                c.translate(0.0f, -cursorOffsetVertical);
            }
        }
        Alignment align = this.mAlignment;
        for (int i = first; i <= last; ++i) {
            int x;
            int lbottom;
            int start = previousLineEnd;
            previousLineEnd = this.getLineStart(i + 1);
            int end = this.getLineVisibleEnd(i, start, previousLineEnd);
            int ltop = previousLineBottom;
            previousLineBottom = lbottom = this.getLineTop(i + 1);
            int lbaseline = lbottom - this.getLineDescent(i);
            boolean isFirstParaLine = false;
            if (spannedText) {
                if (start == 0 || buf.charAt(start - 1) == '\n') {
                    isFirstParaLine = true;
                }
                if (start >= spanend) {
                    Spanned sp = (Spanned)buf;
                    spanend = sp.nextSpanTransition(start, textLength, ParagraphStyle.class);
                    spans = sp.getSpans(start, spanend, ParagraphStyle.class);
                    align = this.mAlignment;
                    for (int n = spans.length - 1; n >= 0; --n) {
                        if (!(spans[n] instanceof AlignmentSpan)) continue;
                        align = ((AlignmentSpan)spans[n]).getAlignment();
                        break;
                    }
                }
            }
            int dir = this.getParagraphDirection(i);
            int left = 0;
            int right = this.mWidth;
            if (spannedText) {
                int length = spans.length;
                for (int n = 0; n < length; ++n) {
                    if (!(spans[n] instanceof LeadingMarginSpan)) continue;
                    LeadingMarginSpan margin = (LeadingMarginSpan)spans[n];
                    if (dir == -1) {
                        margin.drawLeadingMargin(c, paint, right, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                        right -= margin.getLeadingMargin(isFirstParaLine);
                        continue;
                    }
                    margin.drawLeadingMargin(c, paint, left, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                    boolean useMargin = isFirstParaLine;
                    if (margin instanceof LeadingMarginSpan.LeadingMarginSpan2) {
                        int count = ((LeadingMarginSpan.LeadingMarginSpan2)margin).getLeadingMarginLineCount();
                        useMargin = count > i;
                    }
                    left += margin.getLeadingMargin(useMargin);
                }
            }
            if (align == Alignment.ALIGN_NORMAL) {
                x = dir == 1 ? left : right;
            } else {
                int max = (int)this.getLineMax(i, spans, false);
                if (align == Alignment.ALIGN_OPPOSITE) {
                    x = dir == -1 ? left + max : right - max;
                } else {
                    int half = right - left - (max &= 0xFFFFFFFE) >> 1;
                    x = dir == -1 ? right - half : left + half;
                }
            }
            Directions directions = this.getLineDirections(i);
            boolean hasTab = this.getLineContainsTab(i);
            if (directions == DIRS_ALL_LEFT_TO_RIGHT && !spannedText && !hasTab) {
                c.drawText(buf, start, end, (float)x, (float)lbaseline, (Paint)paint);
                continue;
            }
            this.drawText(c, buf, start, end, dir, directions, x, ltop, lbaseline, lbottom, paint, this.mWorkPaint, hasTab, spans);
        }
    }

    public final CharSequence getText() {
        return this.mText;
    }

    public final TextPaint getPaint() {
        return this.mPaint;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public int getEllipsizedWidth() {
        return this.mWidth;
    }

    public final void increaseWidthTo(int wid) {
        if (wid < this.mWidth) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = wid;
    }

    public int getHeight() {
        return this.getLineTop(this.getLineCount());
    }

    public final Alignment getAlignment() {
        return this.mAlignment;
    }

    public final float getSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public final float getSpacingAdd() {
        return this.mSpacingAdd;
    }

    public abstract int getLineCount();

    public int getLineBounds(int line, Rect bounds) {
        if (bounds != null) {
            bounds.left = 0;
            bounds.top = this.getLineTop(line);
            bounds.right = this.mWidth;
            bounds.bottom = this.getLineTop(line + 1);
        }
        return this.getLineBaseline(line);
    }

    public abstract int getLineTop(int var1);

    public abstract int getLineDescent(int var1);

    public abstract int getLineStart(int var1);

    public abstract int getParagraphDirection(int var1);

    public abstract boolean getLineContainsTab(int var1);

    public abstract Directions getLineDirections(int var1);

    public abstract int getTopPadding();

    public abstract int getBottomPadding();

    public float getPrimaryHorizontal(int offset) {
        return this.getHorizontal(offset, false, true);
    }

    public float getSecondaryHorizontal(int offset) {
        return this.getHorizontal(offset, true, true);
    }

    private float getHorizontal(int offset, boolean trailing, boolean alt) {
        int line = this.getLineForOffset(offset);
        return this.getHorizontal(offset, trailing, alt, line);
    }

    private float getHorizontal(int offset, boolean trailing, boolean alt, int line) {
        int start = this.getLineStart(line);
        int end = this.getLineVisibleEnd(line);
        int dir = this.getParagraphDirection(line);
        boolean tab = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        Object[] tabs = null;
        if (tab && this.mText instanceof Spanned) {
            tabs = ((Spanned)this.mText).getSpans(start, end, TabStopSpan.class);
        }
        float wid = Layout.measureText(this.mPaint, this.mWorkPaint, this.mText, start, offset, end, dir, directions, trailing, alt, tab, tabs);
        if (offset > end) {
            wid = dir == -1 ? (wid -= Layout.measureText(this.mPaint, this.mWorkPaint, this.mText, end, offset, null, tab, tabs)) : (wid += Layout.measureText(this.mPaint, this.mWorkPaint, this.mText, end, offset, null, tab, tabs));
        }
        Alignment align = this.getParagraphAlignment(line);
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return (float)right + wid;
            }
            return (float)left + wid;
        }
        float max = this.getLineMax(line);
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return (float)left + max + wid;
            }
            return (float)right - max + wid;
        }
        int imax = (int)max & 0xFFFFFFFE;
        if (dir == -1) {
            return (float)(right - (right - left - imax) / 2) + wid;
        }
        return (float)(left + (right - left - imax) / 2) + wid;
    }

    public float getLineLeft(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return (float)this.getParagraphRight(line) - this.getLineMax(line);
            }
            return 0.0f;
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return 0.0f;
            }
            return (float)this.mWidth - this.getLineMax(line);
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return left + (right - left - max) / 2;
    }

    public float getLineRight(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return this.mWidth;
            }
            return (float)this.getParagraphLeft(line) + this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return this.getLineMax(line);
            }
            return this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return right - (right - left - max) / 2;
    }

    public float getLineMax(int line) {
        return this.getLineMax(line, null, false);
    }

    public float getLineWidth(int line) {
        return this.getLineMax(line, null, true);
    }

    private float getLineMax(int line, Object[] tabs, boolean full) {
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean tab = this.getLineContainsTab(line);
        if (tabs == null && tab && this.mText instanceof Spanned) {
            tabs = ((Spanned)this.mText).getSpans(start, end, TabStopSpan.class);
        }
        return Layout.measureText(this.mPaint, this.mWorkPaint, this.mText, start, end, null, tab, tabs);
    }

    public int getLineForVertical(int vertical) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineTop(guess) > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getLineForOffset(int offset) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineStart(guess) > offset) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getOffsetForHorizontal(int line, float horiz) {
        int max = this.getLineEnd(line) - 1;
        int min = this.getLineStart(line);
        Directions dirs = this.getLineDirections(line);
        if (line == this.getLineCount() - 1) {
            ++max;
        }
        int best = min;
        float bestdist = Math.abs(this.getPrimaryHorizontal(best) - horiz);
        int here = min;
        for (int i = 0; i < dirs.mDirections.length; ++i) {
            float dist;
            int swap;
            int there = here + dirs.mDirections[i];
            int n = swap = (i & 1) == 0 ? 1 : -1;
            if (there > max) {
                there = max;
            }
            int high = there - 1 + 1;
            int low = here + 1 - 1;
            while (high - low > 1) {
                int guess = (high + low) / 2;
                int adguess = this.getOffsetAtStartOf(guess);
                if (this.getPrimaryHorizontal(adguess) * (float)swap >= horiz * (float)swap) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            if (low < here + 1) {
                low = here + 1;
            }
            if (low < there) {
                float other;
                low = this.getOffsetAtStartOf(low);
                float dist2 = Math.abs(this.getPrimaryHorizontal(low) - horiz);
                int aft = TextUtils.getOffsetAfter(this.mText, low);
                if (aft < there && (other = Math.abs(this.getPrimaryHorizontal(aft) - horiz)) < dist2) {
                    dist2 = other;
                    low = aft;
                }
                if (dist2 < bestdist) {
                    bestdist = dist2;
                    best = low;
                }
            }
            if ((dist = Math.abs(this.getPrimaryHorizontal(here) - horiz)) < bestdist) {
                bestdist = dist;
                best = here;
            }
            here = there;
        }
        float dist = Math.abs(this.getPrimaryHorizontal(max) - horiz);
        if (dist < bestdist) {
            bestdist = dist;
            best = max;
        }
        return best;
    }

    public final int getLineEnd(int line) {
        return this.getLineStart(line + 1);
    }

    public int getLineVisibleEnd(int line) {
        return this.getLineVisibleEnd(line, this.getLineStart(line), this.getLineStart(line + 1));
    }

    private int getLineVisibleEnd(int line, int start, int end) {
        CharSequence text = this.mText;
        if (line == this.getLineCount() - 1) {
            return end;
        }
        while (end > start) {
            char ch = text.charAt(end - 1);
            if (ch == '\n') {
                return end - 1;
            }
            if (ch != ' ' && ch != '\t') break;
            --end;
        }
        return end;
    }

    public final int getLineBottom(int line) {
        return this.getLineTop(line + 1);
    }

    public final int getLineBaseline(int line) {
        return this.getLineTop(line + 1) - this.getLineDescent(line);
    }

    public final int getLineAscent(int line) {
        return this.getLineTop(line) - (this.getLineTop(line + 1) - this.getLineDescent(line));
    }

    public int getOffsetToLeftOf(int offset) {
        float h;
        int line = this.getLineForOffset(offset);
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (line != this.getLineCount() - 1) {
            --end;
        }
        float horiz = this.getPrimaryHorizontal(offset);
        int best = offset;
        float besth = -2.1474836E9f;
        int candidate = TextUtils.getOffsetBefore(this.mText, offset);
        if (candidate >= start && candidate <= end && (h = this.getPrimaryHorizontal(candidate)) < horiz && h > besth) {
            best = candidate;
            besth = h;
        }
        if ((candidate = TextUtils.getOffsetAfter(this.mText, offset)) >= start && candidate <= end && (h = this.getPrimaryHorizontal(candidate)) < horiz && h > besth) {
            best = candidate;
            besth = h;
        }
        int here = start;
        for (int i = 0; i < dirs.mDirections.length; ++i) {
            float h2;
            int there = here + dirs.mDirections[i];
            if (there > end) {
                there = end;
            }
            if ((h2 = this.getPrimaryHorizontal(here)) < horiz && h2 > besth) {
                best = here;
                besth = h2;
            }
            if ((candidate = TextUtils.getOffsetAfter(this.mText, here)) >= start && candidate <= end && (h2 = this.getPrimaryHorizontal(candidate)) < horiz && h2 > besth) {
                best = candidate;
                besth = h2;
            }
            if ((candidate = TextUtils.getOffsetBefore(this.mText, there)) >= start && candidate <= end && (h2 = this.getPrimaryHorizontal(candidate)) < horiz && h2 > besth) {
                best = candidate;
                besth = h2;
            }
            here = there;
        }
        float h3 = this.getPrimaryHorizontal(end);
        if (h3 < horiz && h3 > besth) {
            best = end;
            besth = h3;
        }
        if (best != offset) {
            return best;
        }
        int dir = this.getParagraphDirection(line);
        if (dir > 0) {
            if (line == 0) {
                return best;
            }
            return this.getOffsetForHorizontal(line - 1, 10000.0f);
        }
        if (line == this.getLineCount() - 1) {
            return best;
        }
        return this.getOffsetForHorizontal(line + 1, 10000.0f);
    }

    public int getOffsetToRightOf(int offset) {
        float h;
        int line = this.getLineForOffset(offset);
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (line != this.getLineCount() - 1) {
            --end;
        }
        float horiz = this.getPrimaryHorizontal(offset);
        int best = offset;
        float besth = 2.1474836E9f;
        int candidate = TextUtils.getOffsetBefore(this.mText, offset);
        if (candidate >= start && candidate <= end && (h = this.getPrimaryHorizontal(candidate)) > horiz && h < besth) {
            best = candidate;
            besth = h;
        }
        if ((candidate = TextUtils.getOffsetAfter(this.mText, offset)) >= start && candidate <= end && (h = this.getPrimaryHorizontal(candidate)) > horiz && h < besth) {
            best = candidate;
            besth = h;
        }
        int here = start;
        for (int i = 0; i < dirs.mDirections.length; ++i) {
            float h2;
            int there = here + dirs.mDirections[i];
            if (there > end) {
                there = end;
            }
            if ((h2 = this.getPrimaryHorizontal(here)) > horiz && h2 < besth) {
                best = here;
                besth = h2;
            }
            if ((candidate = TextUtils.getOffsetAfter(this.mText, here)) >= start && candidate <= end && (h2 = this.getPrimaryHorizontal(candidate)) > horiz && h2 < besth) {
                best = candidate;
                besth = h2;
            }
            if ((candidate = TextUtils.getOffsetBefore(this.mText, there)) >= start && candidate <= end && (h2 = this.getPrimaryHorizontal(candidate)) > horiz && h2 < besth) {
                best = candidate;
                besth = h2;
            }
            here = there;
        }
        float h3 = this.getPrimaryHorizontal(end);
        if (h3 > horiz && h3 < besth) {
            best = end;
            besth = h3;
        }
        if (best != offset) {
            return best;
        }
        int dir = this.getParagraphDirection(line);
        if (dir > 0) {
            if (line == this.getLineCount() - 1) {
                return best;
            }
            return this.getOffsetForHorizontal(line + 1, -10000.0f);
        }
        if (line == 0) {
            return best;
        }
        return this.getOffsetForHorizontal(line - 1, -10000.0f);
    }

    private int getOffsetAtStartOf(int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        CharSequence text = this.mText;
        char c = text.charAt(offset);
        if (c >= '\udc00' && c <= '\udfff' && (c1 = text.charAt(offset - 1)) >= '\ud800' && c1 <= '\udbff') {
            --offset;
        }
        if (this.mSpannedText) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    public void getCursorPath(int point, Path dest, CharSequence editingBuffer) {
        dest.reset();
        int line = this.getLineForOffset(point);
        int top = this.getLineTop(line);
        int bottom = this.getLineTop(line + 1);
        float h1 = this.getPrimaryHorizontal(point) - 0.5f;
        float h2 = this.getSecondaryHorizontal(point) - 0.5f;
        int caps = TextKeyListener.getMetaState(editingBuffer, 1) | TextKeyListener.getMetaState(editingBuffer, 65536);
        int fn = TextKeyListener.getMetaState(editingBuffer, 2);
        int dist = 0;
        if (caps != 0 || fn != 0) {
            dist = bottom - top >> 2;
            if (fn != 0) {
                top += dist;
            }
            if (caps != 0) {
                bottom -= dist;
            }
        }
        if (h1 < 0.5f) {
            h1 = 0.5f;
        }
        if (h2 < 0.5f) {
            h2 = 0.5f;
        }
        if (h1 == h2) {
            dest.moveTo(h1, top);
            dest.lineTo(h1, bottom);
        } else {
            dest.moveTo(h1, top);
            dest.lineTo(h1, top + bottom >> 1);
            dest.moveTo(h2, top + bottom >> 1);
            dest.lineTo(h2, bottom);
        }
        if (caps == 2) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
            dest.lineTo(h2 + (float)dist, bottom + dist);
        } else if (caps == 1) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.moveTo(h2 - (float)dist, (float)(bottom + dist) - 0.5f);
            dest.lineTo(h2 + (float)dist, (float)(bottom + dist) - 0.5f);
            dest.moveTo(h2 + (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
        }
        if (fn == 2) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.lineTo(h1, top);
            dest.lineTo(h1 + (float)dist, top - dist);
        } else if (fn == 1) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.moveTo(h1 - (float)dist, (float)(top - dist) + 0.5f);
            dest.lineTo(h1 + (float)dist, (float)(top - dist) + 0.5f);
            dest.moveTo(h1 + (float)dist, top - dist);
            dest.lineTo(h1, top);
        }
    }

    private void addSelection(int line, int start, int end, int top, int bottom, Path dest) {
        int linestart = this.getLineStart(line);
        int lineend = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (lineend > linestart && this.mText.charAt(lineend - 1) == '\n') {
            --lineend;
        }
        int here = linestart;
        for (int i = 0; i < dirs.mDirections.length; ++i) {
            int en2;
            int st;
            int there = here + dirs.mDirections[i];
            if (there > lineend) {
                there = lineend;
            }
            if (start <= there && end >= here && (st = Math.max(start, here)) != (en2 = Math.min(end, there))) {
                float h1 = this.getHorizontal(st, false, false, line);
                float h2 = this.getHorizontal(en2, true, false, line);
                dest.addRect(h1, top, h2, bottom, Path.Direction.CW);
            }
            here = there;
        }
    }

    public void getSelectionPath(int start, int end, Path dest) {
        dest.reset();
        if (start == end) {
            return;
        }
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        int startline = this.getLineForOffset(start);
        int endline = this.getLineForOffset(end);
        int top = this.getLineTop(startline);
        int bottom = this.getLineBottom(endline);
        if (startline == endline) {
            this.addSelection(startline, start, end, top, bottom, dest);
        } else {
            float width = this.mWidth;
            this.addSelection(startline, start, this.getLineEnd(startline), top, this.getLineBottom(startline), dest);
            if (this.getParagraphDirection(startline) == -1) {
                dest.addRect(this.getLineLeft(startline), top, 0.0f, this.getLineBottom(startline), Path.Direction.CW);
            } else {
                dest.addRect(this.getLineRight(startline), top, width, this.getLineBottom(startline), Path.Direction.CW);
            }
            for (int i = startline + 1; i < endline; ++i) {
                top = this.getLineTop(i);
                bottom = this.getLineBottom(i);
                dest.addRect(0.0f, top, width, bottom, Path.Direction.CW);
            }
            top = this.getLineTop(endline);
            bottom = this.getLineBottom(endline);
            this.addSelection(endline, this.getLineStart(endline), end, top, bottom, dest);
            if (this.getParagraphDirection(endline) == -1) {
                dest.addRect(width, top, this.getLineRight(endline), bottom, Path.Direction.CW);
            } else {
                dest.addRect(0.0f, top, this.getLineLeft(endline), bottom, Path.Direction.CW);
            }
        }
    }

    public final Alignment getParagraphAlignment(int line) {
        Spanned sp;
        AlignmentSpan[] spans;
        int spanLength;
        Alignment align = this.mAlignment;
        if (this.mSpannedText && (spanLength = (spans = (sp = (Spanned)this.mText).getSpans(this.getLineStart(line), this.getLineEnd(line), AlignmentSpan.class)).length) > 0) {
            align = spans[spanLength - 1].getAlignment();
        }
        return align;
    }

    public final int getParagraphLeft(int line) {
        int dir = this.getParagraphDirection(line);
        int left = 0;
        boolean par = false;
        int off = this.getLineStart(line);
        if (off == 0 || this.mText.charAt(off - 1) == '\n') {
            par = true;
        }
        if (dir == 1 && this.mSpannedText) {
            Spanned sp = (Spanned)this.mText;
            LeadingMarginSpan[] spans = sp.getSpans(this.getLineStart(line), this.getLineEnd(line), LeadingMarginSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                boolean margin = par;
                LeadingMarginSpan span = spans[i];
                if (span instanceof LeadingMarginSpan.LeadingMarginSpan2) {
                    int count = ((LeadingMarginSpan.LeadingMarginSpan2)span).getLeadingMarginLineCount();
                    margin = count >= line;
                }
                left += span.getLeadingMargin(margin);
            }
        }
        return left;
    }

    public final int getParagraphRight(int line) {
        int dir = this.getParagraphDirection(line);
        int right = this.mWidth;
        boolean par = false;
        int off = this.getLineStart(line);
        if (off == 0 || this.mText.charAt(off - 1) == '\n') {
            par = true;
        }
        if (dir == -1 && this.mSpannedText) {
            Spanned sp = (Spanned)this.mText;
            LeadingMarginSpan[] spans = sp.getSpans(this.getLineStart(line), this.getLineEnd(line), LeadingMarginSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                right -= spans[i].getLeadingMargin(par);
            }
        }
        return right;
    }

    private void drawText(Canvas canvas, CharSequence text, int start, int end, int dir, Directions directions, float x, int top, int y, int bottom, TextPaint paint, TextPaint workPaint, boolean hasTabs, Object[] parspans) {
        char[] buf;
        if (!hasTabs) {
            if (directions == DIRS_ALL_LEFT_TO_RIGHT) {
                Styled.drawText(canvas, text, start, end, dir, false, x, top, y, bottom, paint, workPaint, false);
                return;
            }
            buf = null;
        } else {
            buf = TextUtils.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
        }
        float h = 0.0f;
        int here = 0;
        for (int i = 0; i < directions.mDirections.length; ++i) {
            int j;
            int there = here + directions.mDirections[i];
            if (there > end - start) {
                there = end - start;
            }
            int segstart = here;
            int n = j = hasTabs ? here : there;
            while (j <= there) {
                Bitmap bm;
                int emoji;
                if (j == there || buf[j] == '\t') {
                    h += Styled.drawText(canvas, text, start + segstart, start + j, dir, (i & 1) != 0, x + h, top, y, bottom, paint, workPaint, start + j != end);
                    if (j != there && buf[j] == '\t') {
                        h = (float)dir * Layout.nextTab(text, start, end, h * (float)dir, parspans);
                    }
                    segstart = j + 1;
                } else if (hasTabs && buf[j] >= '\ud800' && buf[j] <= '\udfff' && j + 1 < there && (emoji = Character.codePointAt(buf, j)) >= MIN_EMOJI && emoji <= MAX_EMOJI && (bm = EMOJI_FACTORY.getBitmapFromAndroidPua(emoji)) != null) {
                    h += Styled.drawText(canvas, text, start + segstart, start + j, dir, (i & 1) != 0, x + h, top, y, bottom, paint, workPaint, start + j != end);
                    if (this.mEmojiRect == null) {
                        this.mEmojiRect = new RectF();
                    }
                    workPaint.set(paint);
                    Styled.measureText(paint, workPaint, text, start + j, start + j + 1, null);
                    float bitmapHeight = bm.getHeight();
                    float textHeight = -workPaint.ascent();
                    float scale = textHeight / bitmapHeight;
                    float width = (float)bm.getWidth() * scale;
                    this.mEmojiRect.set(x + h, (float)y - textHeight, x + h + width, y);
                    canvas.drawBitmap(bm, null, this.mEmojiRect, (Paint)paint);
                    h += width;
                    segstart = ++j + 1;
                }
                ++j;
            }
            here = there;
        }
        if (hasTabs) {
            TextUtils.recycle(buf);
        }
    }

    private static float measureText(TextPaint paint, TextPaint workPaint, CharSequence text, int start, int offset, int end, int dir, Directions directions, boolean trailing, boolean alt, boolean hasTabs, Object[] tabs) {
        char[] buf = null;
        if (hasTabs) {
            buf = TextUtils.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
        }
        float h = 0.0f;
        if (alt && dir == -1) {
            trailing = !trailing;
        }
        int here = 0;
        for (int i = 0; i < directions.mDirections.length; ++i) {
            int j;
            int there;
            if (alt) {
                boolean bl = trailing = !trailing;
            }
            if ((there = here + directions.mDirections[i]) > end - start) {
                there = end - start;
            }
            int segstart = here;
            int n = j = hasTabs ? here : there;
            while (j <= there) {
                int codept = 0;
                Bitmap bm = null;
                if (hasTabs && j < there) {
                    codept = buf[j];
                }
                if (codept >= 55296 && codept <= 57343 && j + 1 < there && (codept = Character.codePointAt(buf, j)) >= MIN_EMOJI && codept <= MAX_EMOJI) {
                    bm = EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
                }
                if (j == there || codept == 9 || bm != null) {
                    if (offset < start + j || trailing && offset <= start + j) {
                        if (dir == 1 && (i & 1) == 0) {
                            return h += Styled.measureText(paint, workPaint, text, start + segstart, offset, null);
                        }
                        if (dir == -1 && (i & 1) != 0) {
                            return h -= Styled.measureText(paint, workPaint, text, start + segstart, offset, null);
                        }
                    }
                    float segw = Styled.measureText(paint, workPaint, text, start + segstart, start + j, null);
                    if (offset < start + j || trailing && offset <= start + j) {
                        if (dir == 1) {
                            return h += segw - Styled.measureText(paint, workPaint, text, start + segstart, offset, null);
                        }
                        if (dir == -1) {
                            return h -= segw - Styled.measureText(paint, workPaint, text, start + segstart, offset, null);
                        }
                    }
                    h = dir == -1 ? (h -= segw) : (h += segw);
                    if (j != there && buf[j] == '\t') {
                        if (offset == start + j) {
                            return h;
                        }
                        h = (float)dir * Layout.nextTab(text, start, end, h * (float)dir, tabs);
                    }
                    if (bm != null) {
                        workPaint.set(paint);
                        Styled.measureText(paint, workPaint, text, j, j + 2, null);
                        float wid = (float)bm.getWidth() * -workPaint.ascent() / (float)bm.getHeight();
                        h = dir == -1 ? (h -= wid) : (h += wid);
                        ++j;
                    }
                    segstart = j + 1;
                }
                ++j;
            }
            here = there;
        }
        if (hasTabs) {
            TextUtils.recycle(buf);
        }
        return h;
    }

    static float measureText(TextPaint paint, TextPaint workPaint, CharSequence text, int start, int end, Paint.FontMetricsInt fm, boolean hasTabs, Object[] tabs) {
        int pos;
        char[] buf = null;
        if (hasTabs) {
            buf = TextUtils.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
        }
        int len = end - start;
        int lastPos = 0;
        float width = 0.0f;
        int ascent = 0;
        int descent = 0;
        int top = 0;
        int bottom = 0;
        if (fm != null) {
            fm.ascent = 0;
            fm.descent = 0;
        }
        int n = pos = hasTabs ? 0 : len;
        while (pos <= len) {
            int codept = 0;
            Bitmap bm = null;
            if (hasTabs && pos < len) {
                codept = buf[pos];
            }
            if (codept >= 55296 && codept <= 57343 && pos < len && (codept = Character.codePointAt(buf, pos)) >= MIN_EMOJI && codept <= MAX_EMOJI) {
                bm = EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
            }
            if (pos == len || codept == 9 || bm != null) {
                workPaint.baselineShift = 0;
                width += Styled.measureText(paint, workPaint, text, start + lastPos, start + pos, fm);
                if (fm != null) {
                    if (workPaint.baselineShift < 0) {
                        fm.ascent += workPaint.baselineShift;
                        fm.top += workPaint.baselineShift;
                    } else {
                        fm.descent += workPaint.baselineShift;
                        fm.bottom += workPaint.baselineShift;
                    }
                }
                if (pos != len) {
                    if (bm == null) {
                        width = Layout.nextTab(text, start, end, width, tabs);
                    } else {
                        workPaint.set(paint);
                        Styled.measureText(paint, workPaint, text, start + pos, start + pos + 1, null);
                        width += (float)bm.getWidth() * -workPaint.ascent() / (float)bm.getHeight();
                        ++pos;
                    }
                }
                if (fm != null) {
                    if (fm.ascent < ascent) {
                        ascent = fm.ascent;
                    }
                    if (fm.descent > descent) {
                        descent = fm.descent;
                    }
                    if (fm.top < top) {
                        top = fm.top;
                    }
                    if (fm.bottom > bottom) {
                        bottom = fm.bottom;
                    }
                }
                lastPos = pos + 1;
            }
            ++pos;
        }
        if (fm != null) {
            fm.ascent = ascent;
            fm.descent = descent;
            fm.top = top;
            fm.bottom = bottom;
        }
        if (hasTabs) {
            TextUtils.recycle(buf);
        }
        return width;
    }

    static float nextTab(CharSequence text, int start, int end, float h, Object[] tabs) {
        float nh = Float.MAX_VALUE;
        boolean alltabs = false;
        if (text instanceof Spanned) {
            if (tabs == null) {
                tabs = ((Spanned)text).getSpans(start, end, TabStopSpan.class);
                alltabs = true;
            }
            for (int i = 0; i < tabs.length; ++i) {
                int where;
                if (!alltabs && !(tabs[i] instanceof TabStopSpan) || !((float)(where = ((TabStopSpan)tabs[i]).getTabStop()) < nh) || !((float)where > h)) continue;
                nh = where;
            }
            if (nh != Float.MAX_VALUE) {
                return nh;
            }
        }
        return (int)((h + 20.0f) / 20.0f) * 20;
    }

    protected final boolean isSpanned() {
        return this.mSpannedText;
    }

    private void ellipsize(int start, int end, int line, char[] dest, int destoff) {
        int ellipsisCount = this.getEllipsisCount(line);
        if (ellipsisCount == 0) {
            return;
        }
        int ellipsisStart = this.getEllipsisStart(line);
        int linestart = this.getLineStart(line);
        for (int i = ellipsisStart; i < ellipsisStart + ellipsisCount; ++i) {
            int c = i == ellipsisStart ? 8230 : 65279;
            int a = i + linestart;
            if (a < start || a >= end) continue;
            dest[destoff + a - start] = c;
        }
    }

    public abstract int getEllipsisStart(int var1);

    public abstract int getEllipsisCount(int var1);

    static {
        if (EMOJI_FACTORY != null) {
            MIN_EMOJI = EMOJI_FACTORY.getMinimumAndroidPua();
            MAX_EMOJI = EMOJI_FACTORY.getMaximumAndroidPua();
        } else {
            MIN_EMOJI = -1;
            MAX_EMOJI = -1;
        }
        sTempRect = new Rect();
        DIRS_ALL_LEFT_TO_RIGHT = new Directions(new short[]{Short.MAX_VALUE});
        DIRS_ALL_RIGHT_TO_LEFT = new Directions(new short[]{0, Short.MAX_VALUE});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        ALIGN_NORMAL,
        ALIGN_OPPOSITE,
        ALIGN_CENTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned {
        private Spanned mSpanned;

        public SpannedEllipsizer(CharSequence display) {
            super(display);
            this.mSpanned = (Spanned)display;
        }

        @Override
        public <T> T[] getSpans(int start, int end, Class<T> type) {
            return this.mSpanned.getSpans(start, end, type);
        }

        @Override
        public int getSpanStart(Object tag) {
            return this.mSpanned.getSpanStart(tag);
        }

        @Override
        public int getSpanEnd(Object tag) {
            return this.mSpanned.getSpanEnd(tag);
        }

        @Override
        public int getSpanFlags(Object tag) {
            return this.mSpanned.getSpanFlags(tag);
        }

        @Override
        public int nextSpanTransition(int start, int limit, Class type) {
            return this.mSpanned.nextSpanTransition(start, limit, type);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            SpannableString ss = new SpannableString(new String(s));
            TextUtils.copySpansFrom(this.mSpanned, start, end, Object.class, ss, 0);
            return ss;
        }
    }

    static class Ellipsizer
    implements CharSequence,
    GetChars {
        CharSequence mText;
        Layout mLayout;
        int mWidth;
        TextUtils.TruncateAt mMethod;

        public Ellipsizer(CharSequence s) {
            this.mText = s;
        }

        public char charAt(int off) {
            char[] buf = TextUtils.obtain(1);
            this.getChars(off, off + 1, buf, 0);
            char ret = buf[0];
            TextUtils.recycle(buf);
            return ret;
        }

        public void getChars(int start, int end, char[] dest, int destoff) {
            int line1 = this.mLayout.getLineForOffset(start);
            int line2 = this.mLayout.getLineForOffset(end);
            TextUtils.getChars(this.mText, start, end, dest, destoff);
            for (int i = line1; i <= line2; ++i) {
                this.mLayout.ellipsize(start, end, i, dest, destoff);
            }
        }

        public int length() {
            return this.mText.length();
        }

        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            return new String(s);
        }

        public String toString() {
            char[] s = new char[this.length()];
            this.getChars(0, this.length(), s, 0);
            return new String(s);
        }
    }

    public static class Directions {
        private short[] mDirections;

        Directions(short[] dirs) {
            this.mDirections = dirs;
        }
    }
}

