/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.IClipboard;

public class ClipboardManager {
    private static IClipboard sService;
    private Context mContext;

    private static IClipboard getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("clipboard");
        sService = IClipboard.Stub.asInterface(b);
        return sService;
    }

    public ClipboardManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public CharSequence getText() {
        try {
            return ClipboardManager.getService().getClipboardText();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setText(CharSequence text) {
        try {
            ClipboardManager.getService().setClipboardText(text);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean hasText() {
        try {
            return ClipboardManager.getService().hasClipboardText();
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

