/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.SmsCbHeader;
import java.io.UnsupportedEncodingException;

public class SmsCbMessage {
    public static final int GEOGRAPHICAL_SCOPE_CELL_WIDE_IMMEDIATE = 0;
    public static final int GEOGRAPHICAL_SCOPE_PLMN_WIDE = 1;
    public static final int GEOGRAPHICAL_SCOPE_LA_WIDE = 2;
    public static final int GEOGRAPHICAL_SCOPE_CELL_WIDE = 3;
    private static final String LOG_TAG = "SMSCB";
    private static final String[] LANGUAGE_CODES_GROUP_0 = new String[]{"de", "en", "it", "fr", "es", "nl", "sv", "da", "pt", "fi", "no", "el", "tr", "hu", "pl", null};
    private static final String[] LANGUAGE_CODES_GROUP_2 = new String[]{"cs", "he", "ar", "ru", "is", null, null, null, null, null, null, null, null, null, null, null};
    private static final char CARRIAGE_RETURN = '\r';
    private static final int PDU_BODY_PAGE_LENGTH = 82;
    private SmsCbHeader mHeader;
    private String mLanguage;
    private String mBody;
    private long mPrimaryNotificationTimestamp;
    private byte[] mPrimaryNotificationDigitalSignature;

    public static SmsCbMessage createFromPdu(byte[] pdu) {
        try {
            return new SmsCbMessage(pdu);
        }
        catch (IllegalArgumentException e) {
            Log.w(LOG_TAG, "Failed parsing SMS-CB pdu", e);
            return null;
        }
    }

    private SmsCbMessage(byte[] pdu) throws IllegalArgumentException {
        this.mHeader = new SmsCbHeader(pdu);
        if (this.mHeader.format == 3) {
            this.mBody = "ETWS";
            if (pdu.length >= 56) {
                this.mPrimaryNotificationTimestamp = this.getTimestampMillis(pdu);
                this.mPrimaryNotificationDigitalSignature = new byte[43];
                System.arraycopy(pdu, 13, this.mPrimaryNotificationDigitalSignature, 0, 43);
            }
        } else {
            this.parseBody(pdu);
        }
    }

    public int getGeographicalScope() {
        return this.mHeader.geographicalScope;
    }

    public String getLanguageCode() {
        return this.mLanguage;
    }

    public String getMessageBody() {
        return this.mBody;
    }

    public int getMessageIdentifier() {
        return this.mHeader.messageIdentifier;
    }

    public int getMessageCode() {
        return this.mHeader.messageCode;
    }

    public int getUpdateNumber() {
        return this.mHeader.updateNumber;
    }

    public int getMessageFormat() {
        return this.mHeader.format;
    }

    public boolean getEtwsEmergencyUserAlert() {
        return this.mHeader.etwsEmergencyUserAlert;
    }

    public boolean getEtwsPopup() {
        return this.mHeader.etwsPopup;
    }

    public int getEtwsWarningType() {
        return this.mHeader.etwsWarningType;
    }

    public long getEtwsSecurityTimestamp() {
        return this.mPrimaryNotificationTimestamp;
    }

    public byte[] getEtwsSecuritySignature() {
        return (byte[])this.mPrimaryNotificationDigitalSignature.clone();
    }

    private void parseBody(byte[] pdu) {
        int encoding;
        boolean hasLanguageIndicator = false;
        block0 : switch ((this.mHeader.dataCodingScheme & 0xF0) >> 4) {
            case 0: {
                encoding = 1;
                this.mLanguage = LANGUAGE_CODES_GROUP_0[this.mHeader.dataCodingScheme & 0xF];
                break;
            }
            case 1: {
                hasLanguageIndicator = true;
                if ((this.mHeader.dataCodingScheme & 0xF) == 1) {
                    encoding = 3;
                    break;
                }
                encoding = 1;
                break;
            }
            case 2: {
                encoding = 1;
                this.mLanguage = LANGUAGE_CODES_GROUP_2[this.mHeader.dataCodingScheme & 0xF];
                break;
            }
            case 3: {
                encoding = 1;
                break;
            }
            case 4: 
            case 5: {
                switch ((this.mHeader.dataCodingScheme & 0xC) >> 2) {
                    case 1: {
                        encoding = 2;
                        break block0;
                    }
                    case 2: {
                        encoding = 3;
                        break block0;
                    }
                }
                encoding = 1;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                encoding = 0;
                break;
            }
            case 15: {
                if ((this.mHeader.dataCodingScheme & 4) >> 2 == 1) {
                    encoding = 2;
                    break;
                }
                encoding = 1;
                break;
            }
            default: {
                encoding = 1;
            }
        }
        if (this.mHeader.format == 2) {
            int nrPages = pdu[6];
            if (pdu.length < 7 + 83 * nrPages) {
                throw new IllegalArgumentException("Pdu length " + pdu.length + " does not match " + nrPages + " pages");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nrPages; ++i) {
                int offset = 7 + 83 * i;
                byte length = pdu[offset + 82];
                if (length > 82) {
                    throw new IllegalArgumentException("Page length " + length + " exceeds maximum value " + 82);
                }
                sb.append(this.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator));
            }
            this.mBody = sb.toString();
        } else {
            int offset = 6;
            int length = pdu.length - offset;
            this.mBody = this.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator);
        }
    }

    private String unpackBody(byte[] pdu, int encoding, int offset, int length, boolean hasLanguageIndicator) {
        String body = null;
        switch (encoding) {
            case 1: {
                body = GsmAlphabet.gsm7BitPackedToString(pdu, offset, length * 8 / 7);
                if (!hasLanguageIndicator || body == null || body.length() <= 2) break;
                this.mLanguage = body.substring(0, 2);
                body = body.substring(3);
                break;
            }
            case 3: {
                if (hasLanguageIndicator && pdu.length >= offset + 2) {
                    this.mLanguage = GsmAlphabet.gsm7BitPackedToString(pdu, offset, 2);
                    offset += 2;
                    length -= 2;
                }
                try {
                    body = new String(pdu, offset, length & 0xFFFE, "utf-16");
                }
                catch (UnsupportedEncodingException e) {}
                break;
            }
        }
        if (body != null) {
            for (int i = body.length() - 1; i >= 0; --i) {
                if (body.charAt(i) == '\r') continue;
                body = body.substring(0, i + 1);
                break;
            }
        } else {
            body = "";
        }
        return body;
    }

    private long getTimestampMillis(byte[] pdu) {
        int year = IccUtils.gsmBcdByteToInt(pdu[6]);
        int month = IccUtils.gsmBcdByteToInt(pdu[7]);
        int day = IccUtils.gsmBcdByteToInt(pdu[8]);
        int hour = IccUtils.gsmBcdByteToInt(pdu[9]);
        int minute = IccUtils.gsmBcdByteToInt(pdu[10]);
        int second = IccUtils.gsmBcdByteToInt(pdu[11]);
        byte tzByte = pdu[12];
        int timezoneOffset = IccUtils.gsmBcdByteToInt((byte)(tzByte & 0xFFFFFFF7));
        timezoneOffset = (tzByte & 8) == 0 ? timezoneOffset : -timezoneOffset;
        Time time = new Time("UTC");
        time.year = year >= 90 ? year + 1900 : year + 2000;
        time.month = month - 1;
        time.monthDay = day;
        time.hour = hour;
        time.minute = minute;
        time.second = second;
        return time.toMillis(true) - (long)(timezoneOffset * 15 * 60 * 1000);
    }

    public void appendToBody(String body) {
        this.mBody = this.mBody + body;
    }

    public String toString() {
        return "SmsCbMessage{" + this.mHeader.toString() + ", language=" + this.mLanguage + ", body=\"" + this.mBody + "\"}";
    }
}

