/*
 * Decompiled with CFR 0.152.
 */
package android.service.urlrenderer;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.service.urlrenderer.IUrlRendererCallback;
import android.service.urlrenderer.IUrlRendererService;
import android.service.urlrenderer.UrlRenderer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlRendererService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.urlrenderer.UrlRendererService";
    static final String TAG = "UrlRendererService";
    private final IUrlRendererService.Stub mBinderInterface = new IUrlRendererService.Stub(){

        @Override
        public void render(List<String> urls, int width, int height, IUrlRendererCallback cb) {
            UrlRendererService.this.processRequest(urls, width, height, new InternalCallback(cb));
        }
    };

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinderInterface;
    }

    @Override
    public final boolean onUnbind(Intent intent) {
        this.stopSelf();
        return false;
    }

    public abstract void processRequest(List<String> var1, int var2, int var3, UrlRenderer.Callback var4);

    private static class InternalCallback
    implements UrlRenderer.Callback {
        private final IUrlRendererCallback mCallback;

        InternalCallback(IUrlRendererCallback cb) {
            this.mCallback = cb;
        }

        public void complete(String url, ParcelFileDescriptor result) {
            try {
                this.mCallback.complete(url, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

