/*
 * Decompiled with CFR 0.152.
 */
package android.service.urlrenderer;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.urlrenderer.IUrlRendererCallback;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IUrlRendererService
extends IInterface {
    public void render(List<String> var1, int var2, int var3, IUrlRendererCallback var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUrlRendererService {
        private static final String DESCRIPTOR = "android.service.urlrenderer.IUrlRendererService";
        static final int TRANSACTION_render = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IUrlRendererService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IUrlRendererService) {
                return (IUrlRendererService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IUrlRendererCallback _arg3 = IUrlRendererCallback.Stub.asInterface(data.readStrongBinder());
                    this.render(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Proxy
        implements IUrlRendererService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void render(List<String> urls, int width, int height, IUrlRendererCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(urls);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

