/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Searchables {
    private static final String LOG_TAG = "Searchables";
    private static final String MD_LABEL_DEFAULT_SEARCHABLE = "android.app.default_searchable";
    private static final String MD_SEARCHABLE_SYSTEM_SEARCH = "*";
    private Context mContext;
    private HashMap<ComponentName, SearchableInfo> mSearchablesMap = null;
    private ArrayList<SearchableInfo> mSearchablesList = null;
    private ArrayList<SearchableInfo> mSearchablesInGlobalSearchList = null;
    private ComponentName mGlobalSearchActivity = null;
    private ComponentName mWebSearchActivity = null;
    public static String GOOGLE_SEARCH_COMPONENT_NAME = "com.android.googlesearch/.GoogleSearch";
    public static String ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME = "com.google.android.providers.enhancedgooglesearch/.Launcher";

    public Searchables(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchableInfo getSearchableInfo(ComponentName activity) {
        block13: {
            SearchableInfo result;
            Searchables searchables = this;
            synchronized (searchables) {
                result = this.mSearchablesMap.get(activity);
                if (result != null) {
                    return result;
                }
            }
            ActivityInfo ai = null;
            try {
                ai = this.mContext.getPackageManager().getActivityInfo(activity, 128);
                String refActivityName = null;
                Bundle md = ai.metaData;
                if (md != null) {
                    refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (refActivityName == null && (md = ai.applicationInfo.metaData) != null) {
                    refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (refActivityName == null) break block13;
                if (refActivityName.equals(MD_SEARCHABLE_SYSTEM_SEARCH)) {
                    return null;
                }
                String pkg = activity.getPackageName();
                ComponentName referredActivity = refActivityName.charAt(0) == '.' ? new ComponentName(pkg, pkg + refActivityName) : new ComponentName(pkg, refActivityName);
                Searchables searchables2 = this;
                synchronized (searchables2) {
                    result = this.mSearchablesMap.get(referredActivity);
                    if (result != null) {
                        this.mSearchablesMap.put(activity, result);
                        return result;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSearchableList() {
        HashMap<ComponentName, SearchableInfo> newSearchablesMap = new HashMap<ComponentName, SearchableInfo>();
        ArrayList<SearchableInfo> newSearchablesList = new ArrayList<SearchableInfo>();
        ArrayList<SearchableInfo> newSearchablesInGlobalSearchList = new ArrayList<SearchableInfo>();
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.SEARCH");
        List<ResolveInfo> searchList = pm.queryIntentActivities(intent, 128);
        Intent webSearchIntent = new Intent("android.intent.action.WEB_SEARCH");
        List<ResolveInfo> webSearchInfoList = pm.queryIntentActivities(webSearchIntent, 128);
        if (searchList != null || webSearchInfoList != null) {
            int search_count = searchList == null ? 0 : searchList.size();
            int web_search_count = webSearchInfoList == null ? 0 : webSearchInfoList.size();
            int count = search_count + web_search_count;
            for (int ii = 0; ii < count; ++ii) {
                SearchableInfo searchable;
                ResolveInfo info = ii < search_count ? searchList.get(ii) : webSearchInfoList.get(ii - search_count);
                ActivityInfo ai = info.activityInfo;
                if (newSearchablesMap.get(new ComponentName(ai.packageName, ai.name)) != null || (searchable = SearchableInfo.getActivityMetaData(this.mContext, ai)) == null) continue;
                newSearchablesList.add(searchable);
                newSearchablesMap.put(searchable.getSearchActivity(), searchable);
                if (!searchable.shouldIncludeInGlobalSearch()) continue;
                newSearchablesInGlobalSearchList.add(searchable);
            }
        }
        ComponentName newGlobalSearchActivity = this.findGlobalSearchActivity();
        ComponentName newWebSearchActivity = this.findWebSearchActivity(newGlobalSearchActivity);
        Searchables searchables = this;
        synchronized (searchables) {
            this.mSearchablesMap = newSearchablesMap;
            this.mSearchablesList = newSearchablesList;
            this.mSearchablesInGlobalSearchList = newSearchablesInGlobalSearchList;
            this.mGlobalSearchActivity = newGlobalSearchActivity;
            this.mWebSearchActivity = newWebSearchActivity;
        }
    }

    private ComponentName findGlobalSearchActivity() {
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> activities = pm.queryIntentActivities(intent, 65536);
        int count = activities == null ? 0 : activities.size();
        for (int i = 0; i < count; ++i) {
            ActivityInfo ai = activities.get((int)i).activityInfo;
            if (pm.checkPermission("android.permission.GLOBAL_SEARCH", ai.packageName) == 0) {
                return new ComponentName(ai.packageName, ai.name);
            }
            Log.w(LOG_TAG, "Package " + ai.packageName + " wants to handle GLOBAL_SEARCH, " + "but does not have the GLOBAL_SEARCH permission.");
        }
        Log.w(LOG_TAG, "No global search activity found");
        return null;
    }

    private ComponentName findWebSearchActivity(ComponentName globalSearchActivity) {
        if (globalSearchActivity == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.setPackage(globalSearchActivity.getPackageName());
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> activities = pm.queryIntentActivities(intent, 65536);
        int count = activities == null ? 0 : activities.size();
        int i = 0;
        if (i < count) {
            ActivityInfo ai = activities.get((int)i).activityInfo;
            return new ComponentName(ai.packageName, ai.name);
        }
        Log.w(LOG_TAG, "No web search activity found");
        return null;
    }

    public synchronized ArrayList<SearchableInfo> getSearchablesList() {
        ArrayList<SearchableInfo> result = new ArrayList<SearchableInfo>(this.mSearchablesList);
        return result;
    }

    public synchronized ArrayList<SearchableInfo> getSearchablesInGlobalSearchList() {
        return new ArrayList<SearchableInfo>(this.mSearchablesInGlobalSearchList);
    }

    public synchronized ComponentName getGlobalSearchActivity() {
        return this.mGlobalSearchActivity;
    }

    public synchronized ComponentName getWebSearchActivity() {
        return this.mWebSearchActivity;
    }
}

