/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.ParcelUuid;
import android.provider.Settings;
import android.server.BluetoothService;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothA2dpService
extends IBluetoothA2dp.Stub {
    private static final String TAG = "BluetoothA2dpService";
    private static final boolean DBG = true;
    public static final String BLUETOOTH_A2DP_SERVICE = "bluetooth_a2dp";
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String BLUETOOTH_ENABLED = "bluetooth_enabled";
    private static final String PROPERTY_STATE = "State";
    private static final String SINK_STATE_DISCONNECTED = "disconnected";
    private static final String SINK_STATE_CONNECTING = "connecting";
    private static final String SINK_STATE_CONNECTED = "connected";
    private static final String SINK_STATE_PLAYING = "playing";
    private static int mSinkCount;
    private final Context mContext;
    private final IntentFilter mIntentFilter;
    private HashMap<BluetoothDevice, Integer> mAudioDevices;
    private final AudioManager mAudioManager;
    private final BluetoothService mBluetoothService;
    private final BluetoothAdapter mAdapter;
    private int mTargetA2dpState;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            BluetoothDevice[] sinks;
            int streamType;
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                switch (state) {
                    case 12: {
                        BluetoothA2dpService.this.onBluetoothEnable();
                        break;
                    }
                    case 13: {
                        BluetoothA2dpService.this.onBluetoothDisable();
                    }
                }
            } else if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                switch (bondState) {
                    case 12: {
                        if (BluetoothA2dpService.this.getSinkPriority(device) != -1) break;
                        BluetoothA2dpService.this.setSinkPriority(device, 100);
                        break;
                    }
                    case 10: {
                        BluetoothA2dpService.this.setSinkPriority(device, -1);
                    }
                }
            } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                1 bondState = this;
                synchronized (bondState) {
                    if (BluetoothA2dpService.this.mAudioDevices.containsKey(device)) {
                        int state = (Integer)BluetoothA2dpService.this.mAudioDevices.get(device);
                        BluetoothA2dpService.this.handleSinkStateChange(device, state, 0);
                    }
                }
            } else if (action.equals("android.media.VOLUME_CHANGED_ACTION") && (streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1)) == 3 && (sinks = BluetoothA2dpService.this.getConnectedSinks()).length != 0 && BluetoothA2dpService.this.isPhoneDocked(sinks[0])) {
                String address = sinks[0].getAddress();
                int newVolLevel = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                int oldVolLevel = intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0);
                String path = BluetoothA2dpService.this.mBluetoothService.getObjectPathFromAddress(address);
                if (newVolLevel > oldVolLevel) {
                    BluetoothA2dpService.this.avrcpVolumeUpNative(path);
                } else if (newVolLevel < oldVolLevel) {
                    BluetoothA2dpService.this.avrcpVolumeDownNative(path);
                }
            }
        }
    };

    private boolean isPhoneDocked(BluetoothDevice device) {
        BluetoothDevice dockDevice;
        int state;
        Intent i = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
        return i != null && (state = i.getIntExtra("android.intent.extra.DOCK_STATE", 0)) != 0 && (dockDevice = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null && device.equals(dockDevice);
    }

    public BluetoothA2dpService(Context context, BluetoothService bluetoothService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mBluetoothService = bluetoothService;
        if (this.mBluetoothService == null) {
            throw new RuntimeException("Platform does not support Bluetooth");
        }
        if (!this.initNative()) {
            throw new RuntimeException("Could not init BluetoothA2dpService");
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mIntentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.mIntentFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.mAudioDevices = new HashMap();
        if (this.mBluetoothService.isEnabled()) {
            this.onBluetoothEnable();
        }
        this.mTargetA2dpState = -1;
        this.mBluetoothService.setA2dpService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        try {
            this.cleanupNative();
        }
        finally {
            super.finalize();
        }
    }

    private int convertBluezSinkStringtoState(String value) {
        if (value.equalsIgnoreCase(SINK_STATE_DISCONNECTED)) {
            return 0;
        }
        if (value.equalsIgnoreCase(SINK_STATE_CONNECTING)) {
            return 1;
        }
        if (value.equalsIgnoreCase(SINK_STATE_CONNECTED)) {
            return 2;
        }
        if (value.equalsIgnoreCase(SINK_STATE_PLAYING)) {
            return 4;
        }
        return -1;
    }

    private boolean isSinkDevice(BluetoothDevice device) {
        ParcelUuid[] uuids = this.mBluetoothService.getRemoteUuids(device.getAddress());
        return uuids != null && BluetoothUuid.isUuidPresent(uuids, BluetoothUuid.AudioSink);
    }

    private synchronized boolean addAudioSink(BluetoothDevice device) {
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        String[] propValues = (String[])this.getSinkPropertiesNative(path);
        if (propValues == null) {
            Log.e(TAG, "Error while getting AudioSink properties for device: " + device);
            return false;
        }
        Integer state = null;
        for (int i = 0; i < propValues.length; i += 2) {
            if (!propValues[i].equals(PROPERTY_STATE)) continue;
            state = new Integer(this.convertBluezSinkStringtoState(propValues[i + 1]));
            break;
        }
        this.mAudioDevices.put(device, state);
        this.handleSinkStateChange(device, 0, state);
        return true;
    }

    private synchronized void onBluetoothEnable() {
        String devices = this.mBluetoothService.getProperty("Devices");
        mSinkCount = 0;
        if (devices != null) {
            String[] paths;
            for (String path : paths = devices.split(",")) {
                String address = this.mBluetoothService.getAddressFromObjectPath(path);
                BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
                ParcelUuid[] remoteUuids = this.mBluetoothService.getRemoteUuids(address);
                if (remoteUuids == null || !BluetoothUuid.containsAnyUuid(remoteUuids, new ParcelUuid[]{BluetoothUuid.AudioSink, BluetoothUuid.AdvAudioDist})) continue;
                this.addAudioSink(device);
            }
        }
        this.mAudioManager.setParameters("bluetooth_enabled=true");
        this.mAudioManager.setParameters("A2dpSuspended=false");
    }

    private synchronized void onBluetoothDisable() {
        if (!this.mAudioDevices.isEmpty()) {
            BluetoothDevice[] devices = new BluetoothDevice[this.mAudioDevices.size()];
            block4: for (BluetoothDevice device : devices = this.mAudioDevices.keySet().toArray(devices)) {
                int state = this.getSinkState(device);
                switch (state) {
                    case 1: 
                    case 2: 
                    case 4: {
                        this.disconnectSinkNative(this.mBluetoothService.getObjectPathFromAddress(device.getAddress()));
                        this.handleSinkStateChange(device, state, 0);
                        continue block4;
                    }
                    case 3: {
                        this.handleSinkStateChange(device, 3, 0);
                    }
                }
            }
            this.mAudioDevices.clear();
        }
        this.mAudioManager.setParameters("bluetooth_enabled=false");
    }

    private synchronized boolean isConnectSinkFeasible(BluetoothDevice device) {
        if (!this.mBluetoothService.isEnabled() || !this.isSinkDevice(device) || this.getSinkPriority(device) == 0) {
            return false;
        }
        if (this.mAudioDevices.get(device) == null && !this.addAudioSink(device)) {
            return false;
        }
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        return path != null;
    }

    @Override
    public synchronized boolean connectSink(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothA2dpService.log("connectSink(" + device + ")");
        if (!this.isConnectSinkFeasible(device)) {
            return false;
        }
        return this.mBluetoothService.connectSink(device.getAddress());
    }

    @Override
    public synchronized boolean connectSinkInternal(BluetoothDevice device) {
        if (!this.mBluetoothService.isEnabled()) {
            return false;
        }
        int state = this.mAudioDevices.get(device);
        if (this.lookupSinksMatchingStates(new int[]{1, 2, 4, 3}).size() != 0) {
            return false;
        }
        switch (state) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (this.getSinkPriority(device) < 1000) {
            this.setSinkPriority(device, 1000);
        }
        this.handleSinkStateChange(device, state, 1);
        if (!this.connectSinkNative(path)) {
            this.handleSinkStateChange(device, this.mAudioDevices.get(device), state);
            return false;
        }
        return true;
    }

    private synchronized boolean isDisconnectSinkFeasible(BluetoothDevice device) {
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (path == null) {
            return false;
        }
        int state = this.getSinkState(device);
        switch (state) {
            case 0: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean disconnectSink(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothA2dpService.log("disconnectSink(" + device + ")");
        if (!this.isDisconnectSinkFeasible(device)) {
            return false;
        }
        return this.mBluetoothService.disconnectSink(device.getAddress());
    }

    @Override
    public synchronized boolean disconnectSinkInternal(BluetoothDevice device) {
        int state = this.getSinkState(device);
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        switch (state) {
            case 0: 
            case 3: {
                return false;
            }
        }
        this.handleSinkStateChange(device, state, 3);
        if (!this.disconnectSinkNative(path)) {
            this.handleSinkStateChange(device, this.mAudioDevices.get(device), state);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean suspendSink(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothA2dpService.log("suspendSink(" + device + "), mTargetA2dpState: " + this.mTargetA2dpState);
        if (device == null || this.mAudioDevices == null) {
            return false;
        }
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        Integer state = this.mAudioDevices.get(device);
        if (path == null || state == null) {
            return false;
        }
        this.mTargetA2dpState = 2;
        return this.checkSinkSuspendState(state);
    }

    @Override
    public synchronized boolean resumeSink(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothA2dpService.log("resumeSink(" + device + "), mTargetA2dpState: " + this.mTargetA2dpState);
        if (device == null || this.mAudioDevices == null) {
            return false;
        }
        String path = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        Integer state = this.mAudioDevices.get(device);
        if (path == null || state == null) {
            return false;
        }
        this.mTargetA2dpState = 4;
        return this.checkSinkSuspendState(state);
    }

    @Override
    public synchronized BluetoothDevice[] getConnectedSinks() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Set<BluetoothDevice> sinks = this.lookupSinksMatchingStates(new int[]{2, 4});
        return sinks.toArray(new BluetoothDevice[sinks.size()]);
    }

    @Override
    public synchronized BluetoothDevice[] getNonDisconnectedSinks() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Set<BluetoothDevice> sinks = this.lookupSinksMatchingStates(new int[]{2, 4, 1, 3});
        return sinks.toArray(new BluetoothDevice[sinks.size()]);
    }

    @Override
    public synchronized int getSinkState(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Integer state = this.mAudioDevices.get(device);
        if (state == null) {
            return 0;
        }
        return state;
    }

    @Override
    public synchronized int getSinkPriority(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return Settings.Secure.getInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothA2dpSinkPriorityKey(device.getAddress()), -1);
    }

    @Override
    public synchronized boolean setSinkPriority(BluetoothDevice device, int priority) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            return false;
        }
        return Settings.Secure.putInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothA2dpSinkPriorityKey(device.getAddress()), priority);
    }

    @Override
    public synchronized boolean allowIncomingConnect(BluetoothDevice device, boolean value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        String address = device.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        Integer data = this.mBluetoothService.getAuthorizationAgentRequestData(address);
        if (data == null) {
            Log.w(TAG, "allowIncomingConnect(" + device + ") called but no native data available");
            return false;
        }
        BluetoothA2dpService.log("allowIncomingConnect: A2DP: " + device + ":" + value);
        return this.mBluetoothService.setAuthorizationNative(address, value, data);
    }

    private synchronized void onSinkPropertyChanged(String path, String[] propValues) {
        if (!this.mBluetoothService.isEnabled()) {
            return;
        }
        String name = propValues[0];
        String address = this.mBluetoothService.getAddressFromObjectPath(path);
        if (address == null) {
            Log.e(TAG, "onSinkPropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        if (name.equals(PROPERTY_STATE)) {
            int state = this.convertBluezSinkStringtoState(propValues[1]);
            if (this.mAudioDevices.get(device) == null) {
                this.addAudioSink(device);
            } else {
                int prevState = this.mAudioDevices.get(device);
                this.handleSinkStateChange(device, prevState, state);
            }
        }
    }

    private void handleSinkStateChange(BluetoothDevice device, int prevState, int state) {
        if (state != prevState) {
            if (state == 0 || state == 3) {
                --mSinkCount;
            } else if (state == 2) {
                ++mSinkCount;
            }
            this.mAudioDevices.put(device, state);
            this.checkSinkSuspendState(state);
            this.mTargetA2dpState = -1;
            if (this.getSinkPriority(device) > 0 && state == 2) {
                this.setSinkPriority(device, 1000);
                this.adjustOtherSinkPriorities(device);
            }
            Intent intent = new Intent("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", prevState);
            intent.putExtra("android.bluetooth.a2dp.extra.SINK_STATE", state);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            BluetoothA2dpService.log("A2DP state : device: " + device + " State:" + prevState + "->" + state);
        }
    }

    private void adjustOtherSinkPriorities(BluetoothDevice connectedDevice) {
        for (BluetoothDevice device : this.mAdapter.getBondedDevices()) {
            if (this.getSinkPriority(device) < 1000 || device.equals(connectedDevice)) continue;
            this.setSinkPriority(device, 100);
        }
    }

    private synchronized Set<BluetoothDevice> lookupSinksMatchingStates(int[] states) {
        HashSet<BluetoothDevice> sinks = new HashSet<BluetoothDevice>();
        if (this.mAudioDevices.isEmpty()) {
            return sinks;
        }
        block0: for (BluetoothDevice device : this.mAudioDevices.keySet()) {
            int sinkState = this.getSinkState(device);
            for (int state : states) {
                if (state != sinkState) continue;
                sinks.add(device);
                continue block0;
            }
        }
        return sinks;
    }

    private boolean checkSinkSuspendState(int state) {
        boolean result = true;
        if (state != this.mTargetA2dpState) {
            if (state == 4 && this.mTargetA2dpState == 2) {
                this.mAudioManager.setParameters("A2dpSuspended=true");
            } else if (state == 2 && this.mTargetA2dpState == 4) {
                this.mAudioManager.setParameters("A2dpSuspended=false");
            } else {
                result = false;
            }
        }
        return result;
    }

    private void onConnectSinkResult(String deviceObjectPath, boolean result) {
        if (!result && deviceObjectPath != null) {
            String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
            if (address == null) {
                return;
            }
            BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
            int state = this.getSinkState(device);
            this.handleSinkStateChange(device, state, 0);
        }
    }

    @Override
    protected synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mAudioDevices.isEmpty()) {
            return;
        }
        pw.println("Cached audio devices:");
        for (BluetoothDevice device : this.mAudioDevices.keySet()) {
            int state = this.mAudioDevices.get(device);
            pw.println(device + " " + BluetoothA2dp.stateToString(state));
        }
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private native boolean initNative();

    private native void cleanupNative();

    private synchronized native boolean connectSinkNative(String var1);

    private synchronized native boolean disconnectSinkNative(String var1);

    private synchronized native boolean suspendSinkNative(String var1);

    private synchronized native boolean resumeSinkNative(String var1);

    private synchronized native Object[] getSinkPropertiesNative(String var1);

    private synchronized native boolean avrcpVolumeUpNative(String var1);

    private synchronized native boolean avrcpVolumeDownNative(String var1);
}

