/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.view.Surface;
import java.io.UnsupportedEncodingException;

public class RenderScriptGL
extends RenderScript {
    private Surface mSurface = null;
    int mWidth = 0;
    int mHeight = 0;

    public RenderScriptGL(boolean useDepth, boolean forceSW) {
        this.mDev = this.nDeviceCreate();
        if (forceSW) {
            this.nDeviceSetConfig(this.mDev, 0, 1);
        }
        this.mContext = this.nContextCreateGL(this.mDev, 0, useDepth);
        this.mMessageThread = new RenderScript.MessageThread(this);
        this.mMessageThread.start();
        Element.initPredefined(this);
    }

    public void contextSetSurface(int w, int h, Surface sur) {
        this.mSurface = sur;
        this.mWidth = w;
        this.mHeight = h;
        this.validate();
        this.nContextSetSurface(w, h, this.mSurface);
    }

    void pause() {
        this.validate();
        this.nContextPause();
    }

    void resume() {
        this.validate();
        this.nContextResume();
    }

    public void contextBindRootScript(Script s) {
        this.validate();
        this.nContextBindRootScript(this.safeID(s));
    }

    public void contextBindProgramFragmentStore(ProgramStore p) {
        this.validate();
        this.nContextBindProgramFragmentStore(this.safeID(p));
    }

    public void contextBindProgramFragment(ProgramFragment p) {
        this.validate();
        this.nContextBindProgramFragment(this.safeID(p));
    }

    public void contextBindProgramRaster(ProgramRaster p) {
        this.validate();
        this.nContextBindProgramRaster(this.safeID(p));
    }

    public void contextBindProgramVertex(ProgramVertex p) {
        this.validate();
        this.nContextBindProgramVertex(this.safeID(p));
    }

    public File fileOpen(String s) throws IllegalStateException, IllegalArgumentException {
        if (s.length() < 1) {
            throw new IllegalArgumentException("fileOpen does not accept a zero length string.");
        }
        try {
            byte[] bytes = s.getBytes("UTF-8");
            int id2 = this.nFileOpen(bytes);
            return new File(id2);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public class File
    extends BaseObj {
        File(int id2) {
            super(RenderScriptGL.this);
            this.mID = id2;
        }
    }
}

