/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Matrix4f;
import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    public static final int MAX_LIGHT = 8;

    ProgramVertex(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void bindAllocation(MatrixAllocation va) {
        this.mRS.validate();
        this.bindConstants(va.mAlloc, 0);
    }

    public static class MatrixAllocation {
        static final int MODELVIEW_OFFSET = 0;
        static final int PROJECTION_OFFSET = 16;
        static final int TEXTURE_OFFSET = 32;
        Matrix4f mModel = new Matrix4f();
        Matrix4f mProjection = new Matrix4f();
        Matrix4f mTexture = new Matrix4f();
        public Allocation mAlloc;

        public MatrixAllocation(RenderScript rs) {
            this.mAlloc = Allocation.createSized(rs, Element.createUser(rs, Element.DataType.FLOAT_32), 48);
            this.mAlloc.subData1D(0, 16, this.mModel.mMat);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
            this.mAlloc.subData1D(32, 16, this.mTexture.mMat);
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        public void loadModelview(Matrix4f m) {
            this.mModel = m;
            this.mAlloc.subData1D(0, 16, m.mMat);
        }

        public void loadProjection(Matrix4f m) {
            this.mProjection = m;
            this.mAlloc.subData1D(16, 16, m.mMat);
        }

        public void loadTexture(Matrix4f m) {
            this.mTexture = m;
            this.mAlloc.subData1D(32, 16, m.mMat);
        }

        public void setupOrthoWindow(int w, int h) {
            this.mProjection.loadOrtho(0.0f, w, h, 0.0f, -1.0f, 1.0f);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        public void setupOrthoNormalized(int w, int h) {
            if (w > h) {
                float aspect = (float)w / (float)h;
                this.mProjection.loadOrtho(-aspect, aspect, -1.0f, 1.0f, -1.0f, 1.0f);
            } else {
                float aspect = (float)h / (float)w;
                this.mProjection.loadOrtho(-1.0f, 1.0f, -aspect, aspect, -1.0f, 1.0f);
            }
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        public void setupProjectionNormalized(int w, int h) {
            Matrix4f m1 = new Matrix4f();
            Matrix4f m2 = new Matrix4f();
            if (w > h) {
                float aspect = (float)w / (float)h;
                m1.loadFrustum(-aspect, aspect, -1.0f, 1.0f, 1.0f, 100.0f);
            } else {
                float aspect = (float)h / (float)w;
                m1.loadFrustum(-1.0f, 1.0f, -aspect, aspect, 1.0f, 100.0f);
            }
            m2.loadRotate(180.0f, 0.0f, 1.0f, 0.0f);
            m1.loadMultiply(m1, m2);
            m2.loadScale(-2.0f, 2.0f, 1.0f);
            m1.loadMultiply(m1, m2);
            m2.loadTranslate(0.0f, 0.0f, 2.0f);
            m1.loadMultiply(m1, m2);
            this.mProjection = m1;
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript rs) {
            super(rs);
        }

        public ProgramVertex create() {
            int i;
            this.mRS.validate();
            int[] tmp = new int[(this.mInputCount + this.mOutputCount + this.mConstantCount + 1) * 2];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = 0;
                tmp[idx++] = this.mInputs[i].mID;
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = 1;
                tmp[idx++] = this.mOutputs[i].mID;
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = 2;
                tmp[idx++] = this.mConstants[i].mID;
            }
            tmp[idx++] = 3;
            tmp[idx++] = this.mTextureCount;
            int id2 = this.mRS.nProgramVertexCreate2(this.mShader, tmp);
            ProgramVertex pv = new ProgramVertex(id2, this.mRS);
            this.initProgram(pv);
            return pv;
        }
    }

    public static class Builder {
        RenderScript mRS;
        boolean mTextureMatrixEnable;

        public Builder(RenderScript rs, Element in, Element out) {
            this.mRS = rs;
        }

        public void setTextureMatrixEnable(boolean enable) {
            this.mTextureMatrixEnable = enable;
        }

        public ProgramVertex create() {
            int id2 = this.mRS.nProgramVertexCreate(this.mTextureMatrixEnable);
            return new ProgramVertex(id2, this.mRS);
        }
    }
}

