/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;

public class Program
extends BaseObj {
    public static final int MAX_INPUT = 8;
    public static final int MAX_OUTPUT = 8;
    public static final int MAX_CONSTANT = 8;
    public static final int MAX_TEXTURE = 8;
    Element[] mInputs;
    Element[] mOutputs;
    Type[] mConstants;
    int mTextureCount;
    String mShader;

    Program(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void bindConstants(Allocation a, int slot) {
        this.mRS.nProgramBindConstants(this.mID, slot, a.mID);
    }

    public void bindTexture(Allocation va, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramBindTexture(this.mID, slot, va.mID);
    }

    public void bindSampler(Sampler vs, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramBindSampler(this.mID, slot, vs.mID);
    }

    public static class BaseProgramBuilder {
        RenderScript mRS;
        Element[] mInputs;
        Element[] mOutputs;
        Type[] mConstants;
        Type[] mTextures;
        int mInputCount;
        int mOutputCount;
        int mConstantCount;
        int mTextureCount;
        String mShader;

        protected BaseProgramBuilder(RenderScript rs) {
            this.mRS = rs;
            this.mInputs = new Element[8];
            this.mOutputs = new Element[8];
            this.mConstants = new Type[8];
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
        }

        public void setShader(String s) {
            this.mShader = s;
        }

        public void addInput(Element e) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            this.mInputs[this.mInputCount++] = e;
        }

        public void addOutput(Element e) throws IllegalStateException {
            if (this.mOutputCount >= 8) {
                throw new IllegalArgumentException("Max output count exceeded.");
            }
            this.mOutputs[this.mOutputCount++] = e;
        }

        public int addConstant(Type t) throws IllegalStateException {
            if (this.mConstantCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            this.mConstants[this.mConstantCount] = t;
            return this.mConstantCount++;
        }

        public void setTextureCount(int count) throws IllegalArgumentException {
            if (count >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureCount = count;
        }

        protected void initProgram(Program p) {
            p.mInputs = new Element[this.mInputCount];
            System.arraycopy(this.mInputs, 0, p.mInputs, 0, this.mInputCount);
            p.mOutputs = new Element[this.mOutputCount];
            System.arraycopy(this.mOutputs, 0, p.mOutputs, 0, this.mOutputCount);
            p.mConstants = new Type[this.mConstantCount];
            System.arraycopy(this.mConstants, 0, p.mConstants, 0, this.mConstantCount);
            p.mTextureCount = this.mTextureCount;
        }
    }
}

