/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class FieldPacker {
    private final byte[] mData;
    private int mPos = 0;

    public FieldPacker(int len) {
        this.mData = new byte[len];
    }

    public void align(int v) {
        while ((this.mPos & v - 1) != 0) {
            this.mData[this.mPos++] = 0;
        }
    }

    void reset() {
        this.mPos = 0;
    }

    void addI8(byte v) {
        this.mData[this.mPos++] = v;
    }

    void addI16(short v) {
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    void addI32(int v) {
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFF);
    }

    void addI64(long v) {
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    void addU8(short v) {
        if (v < 0 || v > 255) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.mData[this.mPos++] = (byte)v;
    }

    void addU16(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    void addU32(long v) {
        if (v < 0L || v > -1L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
    }

    void addU64(long v) {
        if (v < 0L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    void addF32(float v) {
        this.addI32(Float.floatToRawIntBits(v));
    }

    void addF64(float v) {
        this.addI64(Double.doubleToRawLongBits(v));
    }

    final byte[] getData() {
        return this.mData;
    }
}

