/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.util.Log;
import android.util.SparseArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageManager {
    private static final String TAG = "StorageManager";
    private IMountService mMountService;
    Looper mTgtLooper;
    private MountServiceBinderListener mBinderListener;
    private List<ListenerDelegate> mListeners = new ArrayList<ListenerDelegate>();
    private final AtomicInteger mNextNonce = new AtomicInteger(0);
    private final ObbActionListener mObbActionListener = new ObbActionListener();

    private int getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    public StorageManager(Looper tgtLooper) throws RemoteException {
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            Log.e(TAG, "Unable to connect to mount service! - is it running yet?");
            return;
        }
        this.mTgtLooper = tgtLooper;
        this.mBinderListener = new MountServiceBinderListener();
        this.mMountService.registerListener(this.mBinderListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(StorageEventListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(new ListenerDelegate(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(StorageEventListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = this.mListeners.get(i);
                if (l.getListener() != listener) continue;
                this.mListeners.remove(i);
                break;
            }
        }
    }

    public void enableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(true);
        }
        catch (Exception ex) {
            Log.e(TAG, "Failed to enable UMS", ex);
        }
    }

    public void disableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(false);
        }
        catch (Exception ex) {
            Log.e(TAG, "Failed to disable UMS", ex);
        }
    }

    public boolean isUsbMassStorageConnected() {
        try {
            return this.mMountService.isUsbMassStorageConnected();
        }
        catch (Exception ex) {
            Log.e(TAG, "Failed to get UMS connection state", ex);
            return false;
        }
    }

    public boolean isUsbMassStorageEnabled() {
        try {
            return this.mMountService.isUsbMassStorageEnabled();
        }
        catch (RemoteException rex) {
            Log.e(TAG, "Failed to get UMS enable state", rex);
            return false;
        }
    }

    public boolean mountObb(String filename, String key, OnObbStateChangeListener listener) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.mountObb(filename, key, this.mObbActionListener, nonce);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to mount OBB", e);
            return false;
        }
    }

    public boolean unmountObb(String filename, boolean force, OnObbStateChangeListener listener) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.unmountObb(filename, force, this.mObbActionListener, nonce);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to mount OBB", e);
            return false;
        }
    }

    public boolean isObbMounted(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            return this.mMountService.isObbMounted(filename);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if OBB is mounted", e);
            return false;
        }
    }

    public String getMountedObbPath(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            return this.mMountService.getMountedObbPath(filename);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to find mounted path for OBB", e);
            return null;
        }
    }

    private class ListenerDelegate {
        final StorageEventListener mStorageEventListener;
        private final Handler mHandler;

        ListenerDelegate(StorageEventListener listener) {
            this.mStorageEventListener = listener;
            this.mHandler = new Handler(StorageManager.this.mTgtLooper){

                public void handleMessage(Message msg) {
                    StorageEvent e = (StorageEvent)msg.obj;
                    if (msg.what == 1) {
                        UmsConnectionChangedStorageEvent ev = (UmsConnectionChangedStorageEvent)e;
                        ListenerDelegate.this.mStorageEventListener.onUsbMassStorageConnectionChanged(ev.available);
                    } else if (msg.what == 2) {
                        StorageStateChangedStorageEvent ev = (StorageStateChangedStorageEvent)e;
                        ListenerDelegate.this.mStorageEventListener.onStorageStateChanged(ev.path, ev.oldState, ev.newState);
                    } else {
                        Log.e(StorageManager.TAG, "Unsupported event " + msg.what);
                    }
                }
            };
        }

        StorageEventListener getListener() {
            return this.mStorageEventListener;
        }

        void sendShareAvailabilityChanged(boolean available) {
            UmsConnectionChangedStorageEvent e = new UmsConnectionChangedStorageEvent(available);
            this.mHandler.sendMessage(e.getMessage());
        }

        void sendStorageStateChanged(String path, String oldState, String newState) {
            StorageStateChangedStorageEvent e = new StorageStateChangedStorageEvent(path, oldState, newState);
            this.mHandler.sendMessage(e.getMessage());
        }
    }

    private class StorageStateChangedStorageEvent
    extends StorageEvent {
        public String path;
        public String oldState;
        public String newState;

        public StorageStateChangedStorageEvent(String p, String oldS, String newS) {
            super(2);
            this.path = p;
            this.oldState = oldS;
            this.newState = newS;
        }
    }

    private class UmsConnectionChangedStorageEvent
    extends StorageEvent {
        public boolean available;

        public UmsConnectionChangedStorageEvent(boolean a) {
            super(1);
            this.available = a;
        }
    }

    private class StorageEvent {
        static final int EVENT_UMS_CONNECTION_CHANGED = 1;
        static final int EVENT_STORAGE_STATE_CHANGED = 2;
        static final int EVENT_OBB_STATE_CHANGED = 3;
        private Message mMessage = Message.obtain();

        public StorageEvent(int what) {
            this.mMessage.what = what;
            this.mMessage.obj = this;
        }

        public Message getMessage() {
            return this.mMessage;
        }
    }

    private class ObbStateChangedStorageEvent
    extends StorageEvent {
        public final String path;
        public final int state;

        public ObbStateChangedStorageEvent(String path, int state) {
            super(3);
            this.path = path;
            this.state = state;
        }
    }

    private class ObbListenerDelegate {
        private final WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private final Handler mHandler;
        private final int nonce;

        ObbListenerDelegate(OnObbStateChangeListener listener) {
            this.nonce = StorageManager.this.getNextNonce();
            this.mObbEventListenerRef = new WeakReference<OnObbStateChangeListener>(listener);
            this.mHandler = new Handler(StorageManager.this.mTgtLooper){

                public void handleMessage(Message msg) {
                    OnObbStateChangeListener listener = ObbListenerDelegate.this.getListener();
                    if (listener == null) {
                        return;
                    }
                    StorageEvent e = (StorageEvent)msg.obj;
                    if (msg.what == 3) {
                        ObbStateChangedStorageEvent ev = (ObbStateChangedStorageEvent)e;
                        listener.onObbStateChange(ev.path, ev.state);
                    } else {
                        Log.e(StorageManager.TAG, "Unsupported event " + msg.what);
                    }
                }
            };
        }

        OnObbStateChangeListener getListener() {
            if (this.mObbEventListenerRef == null) {
                return null;
            }
            return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
        }

        void sendObbStateChanged(String path, int state) {
            ObbStateChangedStorageEvent e = new ObbStateChangedStorageEvent(path, state);
            this.mHandler.sendMessage(e.getMessage());
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub {
        private SparseArray<ObbListenerDelegate> mListeners = new SparseArray();

        private ObbActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onObbResult(String filename, int nonce, int status) throws RemoteException {
            ObbListenerDelegate delegate;
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                delegate = this.mListeners.get(nonce);
                if (delegate != null) {
                    this.mListeners.remove(nonce);
                }
            }
            if (delegate != null) {
                delegate.sendObbStateChanged(filename, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addListener(OnObbStateChangeListener listener) {
            ObbListenerDelegate delegate = new ObbListenerDelegate(listener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                this.mListeners.put(delegate.nonce, delegate);
            }
            return delegate.nonce;
        }
    }

    private class MountServiceBinderListener
    extends IMountServiceListener.Stub {
        private MountServiceBinderListener() {
        }

        public void onUsbMassStorageConnectionChanged(boolean available) {
            int size = StorageManager.this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(i)).sendShareAvailabilityChanged(available);
            }
        }

        public void onStorageStateChanged(String path, String oldState, String newState) {
            int size = StorageManager.this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(i)).sendStorageStateChanged(path, oldState, newState);
            }
        }
    }
}

