/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public final class SystemClock {
    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static native boolean setCurrentTimeMillis(long var0);

    public static native long uptimeMillis();

    public static native long elapsedRealtime();

    public static native long currentThreadTimeMillis();
}

