/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.res.Resources;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.IMountService;
import java.io.File;

public class Environment {
    private static final File ROOT_DIRECTORY = Environment.getDirectory("ANDROID_ROOT", "/system");
    private static final String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static IMountService mMntSvc = null;
    private static final File DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
    private static final File SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
    private static final File EXTERNAL_STORAGE_DIRECTORY = Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard");
    private static final File EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY = new File(new File(Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard"), "Android"), "data");
    private static final File EXTERNAL_STORAGE_ANDROID_MEDIA_DIRECTORY = new File(new File(Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard"), "Android"), "media");
    private static final File DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
    public static String DIRECTORY_MUSIC = "Music";
    public static String DIRECTORY_PODCASTS = "Podcasts";
    public static String DIRECTORY_RINGTONES = "Ringtones";
    public static String DIRECTORY_ALARMS = "Alarms";
    public static String DIRECTORY_NOTIFICATIONS = "Notifications";
    public static String DIRECTORY_PICTURES = "Pictures";
    public static String DIRECTORY_MOVIES = "Movies";
    public static String DIRECTORY_DOWNLOADS = "Download";
    public static String DIRECTORY_DCIM = "DCIM";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";

    public static File getRootDirectory() {
        return ROOT_DIRECTORY;
    }

    public static File getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return new File(SECURE_DATA_DIRECTORY, "system");
        }
        return new File(DATA_DIRECTORY, "system");
    }

    public static File getSecureDataDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return SECURE_DATA_DIRECTORY;
        }
        return DATA_DIRECTORY;
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_EFS_ENABLED, false);
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    public static File getExternalStorageDirectory() {
        return EXTERNAL_STORAGE_DIRECTORY;
    }

    public static File getExternalStoragePublicDirectory(String type) {
        return new File(Environment.getExternalStorageDirectory(), type);
    }

    public static File getExternalStorageAndroidDataDir() {
        return EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY;
    }

    public static File getExternalStorageAppDataDirectory(String packageName) {
        return new File(EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY, packageName);
    }

    public static File getExternalStorageAppMediaDirectory(String packageName) {
        return new File(EXTERNAL_STORAGE_ANDROID_MEDIA_DIRECTORY, packageName);
    }

    public static File getExternalStorageAppFilesDirectory(String packageName) {
        return new File(new File(EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY, packageName), "files");
    }

    public static File getExternalStorageAppCacheDirectory(String packageName) {
        return new File(new File(EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY, packageName), "cache");
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static String getExternalStorageState() {
        try {
            if (mMntSvc == null) {
                mMntSvc = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            }
            return mMntSvc.getVolumeState(Environment.getExternalStorageDirectory().toString());
        }
        catch (Exception rex) {
            return MEDIA_REMOVED;
        }
    }

    public static boolean isExternalStorageRemovable() {
        return Resources.getSystem().getBoolean(17629186);
    }

    static File getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }
}

