/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.TypedProperties;
import dalvik.system.VMDebug;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Debug {
    private static final String TAG = "Debug";
    public static final int TRACE_COUNT_ALLOCS = 1;
    public static final int SHOW_FULL_DETAIL = 1;
    public static final int SHOW_CLASSLOADER = 2;
    public static final int SHOW_INITIALIZED = 4;
    private static volatile boolean mWaiting = false;
    private static final int MIN_DEBUGGER_IDLE = 1300;
    private static final int SPIN_DELAY = 200;
    private static final String DEFAULT_TRACE_PATH_PREFIX = "/sdcard/";
    private static final String DEFAULT_TRACE_BODY = "dmtrace";
    private static final String DEFAULT_TRACE_EXTENSION = ".trace";
    private static final String DEFAULT_TRACE_FILE_PATH = "/sdcard/dmtrace.trace";
    private static final String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    private static final TypedProperties debugProperties = null;

    private Debug() {
    }

    public static void waitForDebugger() {
        block9: {
            long delta;
            if (!VMDebug.isDebuggingEnabled()) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            System.out.println("Sending WAIT chunk");
            byte[] data = new byte[]{0};
            Chunk waitChunk = new Chunk(ChunkHandler.type((String)"WAIT"), data, 0, 1);
            DdmServer.sendChunk((Chunk)waitChunk);
            mWaiting = true;
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {}
            }
            mWaiting = false;
            System.out.println("Debugger has connected");
            while (true) {
                if ((delta = VMDebug.lastDebuggerActivity()) < 0L) {
                    System.out.println("debugger detached?");
                    break block9;
                }
                if (delta >= 1300L) break;
                System.out.println("waiting for debugger to settle...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {}
            }
            System.out.println("debugger has settled (" + delta + ")");
        }
    }

    public static boolean waitingForDebugger() {
        return mWaiting;
    }

    public static boolean isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    public static String[] getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    @Deprecated
    public static void changeDebugPort(int port) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startNativeTracing() {
        PrintWriter outStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new PrintWriter(new OutputStreamWriter(fos));
            outStream.println("1");
        }
        catch (Exception exception) {
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        VMDebug.startEmulatorTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        PrintWriter outStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new PrintWriter(new OutputStreamWriter(fos));
            outStream.println("0");
        }
        catch (Exception exception) {
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static void enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    public static void startMethodTracing() {
        VMDebug.startMethodTracing((String)DEFAULT_TRACE_FILE_PATH, (int)0, (int)0);
    }

    public static void startMethodTracing(String traceName) {
        Debug.startMethodTracing(traceName, 0, 0);
    }

    public static void startMethodTracing(String traceName, int bufferSize) {
        Debug.startMethodTracing(traceName, bufferSize, 0);
    }

    public static void startMethodTracing(String traceName, int bufferSize, int flags) {
        String pathName = traceName;
        if (pathName.charAt(0) != '/') {
            pathName = DEFAULT_TRACE_PATH_PREFIX + pathName;
        }
        if (!pathName.endsWith(DEFAULT_TRACE_EXTENSION)) {
            pathName = pathName + DEFAULT_TRACE_EXTENSION;
        }
        VMDebug.startMethodTracing((String)pathName, (int)bufferSize, (int)flags);
    }

    public static void startMethodTracing(String traceName, FileDescriptor fd, int bufferSize, int flags) {
        VMDebug.startMethodTracing((String)traceName, (FileDescriptor)fd, (int)bufferSize, (int)flags);
    }

    public static void startMethodTracingDdms(int bufferSize, int flags) {
        VMDebug.startMethodTracingDdms((int)bufferSize, (int)flags);
    }

    public static boolean isMethodTracingActive() {
        return VMDebug.isMethodTracingActive();
    }

    public static void stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    public static long threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    public static void startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    public static void stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    public static int getGlobalAllocCount() {
        return VMDebug.getAllocCount((int)1);
    }

    public static int getGlobalAllocSize() {
        return VMDebug.getAllocCount((int)2);
    }

    public static int getGlobalFreedCount() {
        return VMDebug.getAllocCount((int)4);
    }

    public static int getGlobalFreedSize() {
        return VMDebug.getAllocCount((int)8);
    }

    public static int getGlobalClassInitCount() {
        return VMDebug.getAllocCount((int)32);
    }

    public static int getGlobalClassInitTime() {
        return VMDebug.getAllocCount((int)64);
    }

    public static int getGlobalExternalAllocCount() {
        return VMDebug.getAllocCount((int)4096);
    }

    public static int getGlobalExternalAllocSize() {
        return VMDebug.getAllocCount((int)8192);
    }

    public static int getGlobalExternalFreedCount() {
        return VMDebug.getAllocCount((int)16384);
    }

    public static int getGlobalExternalFreedSize() {
        return VMDebug.getAllocCount((int)32768);
    }

    public static int getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount((int)16);
    }

    public static int getThreadAllocCount() {
        return VMDebug.getAllocCount((int)65536);
    }

    public static int getThreadAllocSize() {
        return VMDebug.getAllocCount((int)131072);
    }

    public static int getThreadExternalAllocCount() {
        return VMDebug.getAllocCount((int)0x10000000);
    }

    public static int getThreadExternalAllocSize() {
        return VMDebug.getAllocCount((int)0x20000000);
    }

    public static int getThreadGcInvocationCount() {
        return VMDebug.getAllocCount((int)0x100000);
    }

    public static void resetGlobalAllocCount() {
        VMDebug.resetAllocCount((int)1);
    }

    public static void resetGlobalAllocSize() {
        VMDebug.resetAllocCount((int)2);
    }

    public static void resetGlobalFreedCount() {
        VMDebug.resetAllocCount((int)4);
    }

    public static void resetGlobalFreedSize() {
        VMDebug.resetAllocCount((int)8);
    }

    public static void resetGlobalClassInitCount() {
        VMDebug.resetAllocCount((int)32);
    }

    public static void resetGlobalClassInitTime() {
        VMDebug.resetAllocCount((int)64);
    }

    public static void resetGlobalExternalAllocCount() {
        VMDebug.resetAllocCount((int)4096);
    }

    public static void resetGlobalExternalAllocSize() {
        VMDebug.resetAllocCount((int)8192);
    }

    public static void resetGlobalExternalFreedCount() {
        VMDebug.resetAllocCount((int)16384);
    }

    public static void resetGlobalExternalFreedSize() {
        VMDebug.resetAllocCount((int)32768);
    }

    public static void resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount((int)16);
    }

    public static void resetThreadAllocCount() {
        VMDebug.resetAllocCount((int)65536);
    }

    public static void resetThreadAllocSize() {
        VMDebug.resetAllocCount((int)131072);
    }

    public static void resetThreadExternalAllocCount() {
        VMDebug.resetAllocCount((int)0x10000000);
    }

    public static void resetThreadExternalAllocSize() {
        VMDebug.resetAllocCount((int)0x20000000);
    }

    public static void resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount((int)0x100000);
    }

    public static void resetAllCounts() {
        VMDebug.resetAllocCount((int)-1);
    }

    public static native long getNativeHeapSize();

    public static native long getNativeHeapAllocatedSize();

    public static native long getNativeHeapFreeSize();

    public static native void getMemoryInfo(MemoryInfo var0);

    public static native void getMemoryInfo(int var0, MemoryInfo var1);

    public static int setAllocationLimit(int limit) {
        return VMDebug.setAllocationLimit((int)limit);
    }

    public static int setGlobalAllocationLimit(int limit) {
        if (limit != 0 && limit != -1) {
            throw new IllegalArgumentException("limit must be 0 or -1");
        }
        return VMDebug.setGlobalAllocationLimit((int)limit);
    }

    public static void printLoadedClasses(int flags) {
        VMDebug.printLoadedClasses((int)flags);
    }

    public static int getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    public static void dumpHprofData(String fileName) throws IOException {
        VMDebug.dumpHprofData((String)fileName);
    }

    public static void dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    public static native int getBinderSentTransactions();

    public static native int getBinderReceivedTransactions();

    public static final native int getBinderLocalObjectCount();

    public static final native int getBinderProxyObjectCount();

    public static final native int getBinderDeathObjectCount();

    public static final boolean cacheRegisterMap(String classAndMethodDesc) {
        return VMDebug.cacheRegisterMap((String)classAndMethodDesc);
    }

    public static final void dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    private static boolean fieldTypeMatches(Field field, Class<?> cl) {
        Field primitiveTypeField;
        Class<?> fieldClass = field.getType();
        if (fieldClass == cl) {
            return true;
        }
        try {
            primitiveTypeField = cl.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
        try {
            return fieldClass == (Class)primitiveTypeField.get(null);
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }

    private static void modifyFieldIfSet(Field field, TypedProperties properties, String propertyName) {
        Object value;
        if (field.getType() == String.class) {
            int stringInfo = properties.getStringInfo(propertyName);
            switch (stringInfo) {
                case 1: {
                    break;
                }
                case 0: {
                    try {
                        field.set(null, null);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
                    }
                    return;
                }
                case -1: {
                    return;
                }
                case -2: {
                    throw new IllegalArgumentException("Type of " + propertyName + " " + " does not match field type (" + field.getType() + ")");
                }
                default: {
                    throw new IllegalStateException("Unexpected getStringInfo(" + propertyName + ") return value " + stringInfo);
                }
            }
        }
        if ((value = properties.get(propertyName)) != null) {
            if (!Debug.fieldTypeMatches(field, value.getClass())) {
                throw new IllegalArgumentException("Type of " + propertyName + " (" + value.getClass() + ") " + " does not match field type (" + field.getType() + ")");
            }
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
            }
        }
    }

    public static void setFieldsOn(Class<?> cl) {
        Debug.setFieldsOn(cl, false);
    }

    public static void setFieldsOn(Class<?> cl, boolean partial) {
        Log.wtf(TAG, "setFieldsOn(" + (cl == null ? "null" : cl.getName()) + ") called in non-DEBUG build");
    }

    public static boolean dumpService(String name, FileDescriptor fd, String[] args) {
        IBinder service = ServiceManager.getService(name);
        if (service == null) {
            Log.e(TAG, "Can't find service to dump: " + name);
            return false;
        }
        try {
            service.dump(fd, args);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't dump service: " + name, e);
            return false;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DebugProperty {
    }

    public static class InstructionCount {
        private static final int NUM_INSTR = 256;
        private int[] mCounts = new int[256];

        public boolean resetAndStart() {
            try {
                VMDebug.startInstructionCounting();
                VMDebug.resetInstructionCount();
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        public boolean collect() {
            try {
                VMDebug.stopInstructionCounting();
                VMDebug.getInstructionCount((int[])this.mCounts);
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        public int globalTotal() {
            int count = 0;
            for (int i = 0; i < 256; ++i) {
                count += this.mCounts[i];
            }
            return count;
        }

        public int globalMethodInvocations() {
            int count = 0;
            count += this.mCounts[110];
            count += this.mCounts[111];
            count += this.mCounts[112];
            count += this.mCounts[113];
            count += this.mCounts[114];
            count += this.mCounts[116];
            count += this.mCounts[117];
            count += this.mCounts[118];
            count += this.mCounts[119];
            count += this.mCounts[120];
            count += this.mCounts[248];
            count += this.mCounts[249];
            count += this.mCounts[250];
            return count += this.mCounts[251];
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public int dalvikPss;
        public int dalvikPrivateDirty;
        public int dalvikSharedDirty;
        public int nativePss;
        public int nativePrivateDirty;
        public int nativeSharedDirty;
        public int otherPss;
        public int otherPrivateDirty;
        public int otherSharedDirty;
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel source) {
                return new MemoryInfo(source);
            }

            public MemoryInfo[] newArray(int size) {
                return new MemoryInfo[size];
            }
        };

        public MemoryInfo() {
        }

        public int getTotalPss() {
            return this.dalvikPss + this.nativePss + this.otherPss;
        }

        public int getTotalPrivateDirty() {
            return this.dalvikPrivateDirty + this.nativePrivateDirty + this.otherPrivateDirty;
        }

        public int getTotalSharedDirty() {
            return this.dalvikSharedDirty + this.nativeSharedDirty + this.otherSharedDirty;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.dalvikPss);
            dest.writeInt(this.dalvikPrivateDirty);
            dest.writeInt(this.dalvikSharedDirty);
            dest.writeInt(this.nativePss);
            dest.writeInt(this.nativePrivateDirty);
            dest.writeInt(this.nativeSharedDirty);
            dest.writeInt(this.otherPss);
            dest.writeInt(this.otherPrivateDirty);
            dest.writeInt(this.otherSharedDirty);
        }

        public void readFromParcel(Parcel source) {
            this.dalvikPss = source.readInt();
            this.dalvikPrivateDirty = source.readInt();
            this.dalvikSharedDirty = source.readInt();
            this.nativePss = source.readInt();
            this.nativePrivateDirty = source.readInt();
            this.nativeSharedDirty = source.readInt();
            this.otherPss = source.readInt();
            this.otherPrivateDirty = source.readInt();
            this.otherSharedDirty = source.readInt();
        }

        private MemoryInfo(Parcel source) {
            this.readFromParcel(source);
        }
    }
}

