/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.opengles.GL10;

public class Texture {
    private int width;
    private int height;
    private int bpp;
    private ByteBuffer data;
    private int name = -1;

    private int readInt16(InputStream is) throws IOException {
        return is.read() | is.read() << 8;
    }

    public Texture(InputStream is) throws IOException {
        int nread;
        this.width = this.readInt16(is);
        this.height = this.readInt16(is);
        this.bpp = 2;
        int npixels = this.width * this.height;
        int nbytes = npixels * this.bpp;
        byte[] arr = new byte[nbytes];
        for (int idx = 0; idx < nbytes; idx += nread) {
            nread = is.read(arr, idx, nbytes - idx);
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < npixels; ++i) {
                int j = i * 2;
                int k = j + 1;
                byte tmp = arr[j];
                arr[j] = arr[k];
                arr[k] = tmp;
            }
        }
        this.data = ByteBuffer.allocateDirect(arr.length);
        this.data.order(ByteOrder.nativeOrder());
        this.data.put(arr);
        this.data.position(0);
    }

    private int loadTexture(GL10 gl, int textureUnit, int minFilter, int magFilter, int wrapS, int wrapT, int mode, int width, int height, int dataType, Buffer data) {
        int[] texture = new int[1];
        gl.glGenTextures(1, texture, 0);
        gl.glEnable(3553);
        gl.glClientActiveTexture(textureUnit);
        gl.glBindTexture(3553, texture[0]);
        gl.glTexParameterf(3553, 10241, minFilter);
        gl.glTexParameterf(3553, 10240, magFilter);
        gl.glTexParameterf(3553, 10242, wrapS);
        gl.glTexParameterf(3553, 10243, wrapT);
        gl.glTexEnvf(8960, 8704, mode);
        gl.glTexImage2D(3553, 0, 6407, width, height, 0, 6407, dataType, data);
        return texture[0];
    }

    public void setTextureParameters(GL10 gl) {
        if (this.name < 0) {
            this.name = this.loadTexture(gl, 33984, 9728, 9728, 10497, 10497, 8448, this.width, this.height, 33635, this.data);
        }
        gl.glBindTexture(3553, this.name);
    }
}

