/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Material;
import android.opengl.MaterialIndices;
import android.opengl.Object3D;
import android.opengl.Texture;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class Group {
    private Object3D parent;
    private String name;
    private List<MaterialIndices> materialIndices = new ArrayList<MaterialIndices>();

    public Group(Object3D parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void load(DataInputStream dis) throws IOException {
        dis.readInt();
        this.name = dis.readUTF();
        int numMaterials = dis.readInt();
        for (int i = 0; i < numMaterials; ++i) {
            dis.readInt();
            String matName = dis.readUTF();
            Material material = this.parent.getMaterial(matName);
            int numIndices = dis.readInt();
            byte[] indicesBytes = new byte[numIndices * 2];
            dis.readFully(indicesBytes);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                int idx = 0;
                for (int j = 0; j < numIndices; ++j) {
                    byte b1;
                    byte b0 = indicesBytes[idx];
                    indicesBytes[idx] = b1 = indicesBytes[idx + 1];
                    indicesBytes[idx + 1] = b0;
                    idx += 2;
                }
            }
            ByteBuffer ibb = ByteBuffer.allocateDirect(2 * numIndices);
            ibb.order(ByteOrder.nativeOrder());
            ibb.put(indicesBytes);
            ibb.position(0);
            ShortBuffer sb = ibb.asShortBuffer();
            this.materialIndices.add(new MaterialIndices(material, sb));
        }
    }

    public int getNumTriangles() {
        int numTriangles = 0;
        for (MaterialIndices matIdx : this.materialIndices) {
            ShortBuffer indexBuffer = matIdx.getIndexBuffer();
            numTriangles += indexBuffer.capacity() / 3;
        }
        return numTriangles;
    }

    public void draw(GL10 gl) {
        gl.glDisableClientState(32886);
        gl.glVertexPointer(3, 5132, 0, this.parent.getVertexBuffer());
        gl.glEnableClientState(32884);
        gl.glNormalPointer(5132, 0, this.parent.getNormalBuffer());
        gl.glEnableClientState(32885);
        if (this.parent.hasTexcoords()) {
            gl.glTexCoordPointer(2, 5132, 0, this.parent.getTexcoordBuffer());
            gl.glEnableClientState(32888);
            gl.glEnable(3553);
        } else {
            gl.glDisable(3553);
        }
        for (MaterialIndices matIdx : this.materialIndices) {
            ShortBuffer indexBuffer = matIdx.getIndexBuffer();
            Material mat = matIdx.getMaterial();
            mat.setMaterialParameters(gl);
            if (this.parent.hasTexcoords() && mat.getMap_Kd().length() > 0) {
                Texture texture = this.parent.getTexture(mat.getMap_Kd());
                texture.setTextureParameters(gl);
            }
            gl.glDrawElements(4, indexBuffer.capacity(), 5123, indexBuffer);
        }
    }

    public String toString() {
        return "Group[name=" + this.name + "]";
    }
}

