/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.GLException;
import java.io.IOException;
import java.io.Writer;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGL11;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGLLogWrapper
implements EGL11 {
    private EGL10 mEgl10;
    Writer mLog;
    boolean mLogArgumentNames;
    boolean mCheckError;
    private int mArgCount;

    public EGLLogWrapper(EGL egl, int configFlags, Writer log) {
        this.mEgl10 = (EGL10)egl;
        this.mLog = log;
        this.mLogArgumentNames = (4 & configFlags) != 0;
        this.mCheckError = (1 & configFlags) != 0;
    }

    public boolean eglChooseConfig(EGLDisplay display, int[] attrib_list, EGLConfig[] configs, int config_size, int[] num_config) {
        this.begin("eglChooseConfig");
        this.arg("display", display);
        this.arg("attrib_list", attrib_list);
        this.arg("config_size", config_size);
        this.end();
        boolean result = this.mEgl10.eglChooseConfig(display, attrib_list, configs, config_size, num_config);
        this.arg("configs", configs);
        this.arg("num_config", num_config);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglCopyBuffers(EGLDisplay display, EGLSurface surface, Object native_pixmap) {
        this.begin("eglCopyBuffers");
        this.arg("display", display);
        this.arg("surface", surface);
        this.arg("native_pixmap", native_pixmap);
        this.end();
        boolean result = this.mEgl10.eglCopyBuffers(display, surface, native_pixmap);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        this.begin("eglCreateContext");
        this.arg("display", display);
        this.arg("config", config);
        this.arg("share_context", share_context);
        this.arg("attrib_list", attrib_list);
        this.end();
        EGLContext result = this.mEgl10.eglCreateContext(display, config, share_context, attrib_list);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        this.begin("eglCreatePbufferSurface");
        this.arg("display", display);
        this.arg("config", config);
        this.arg("attrib_list", attrib_list);
        this.end();
        EGLSurface result = this.mEgl10.eglCreatePbufferSurface(display, config, attrib_list);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        this.begin("eglCreatePixmapSurface");
        this.arg("display", display);
        this.arg("config", config);
        this.arg("native_pixmap", native_pixmap);
        this.arg("attrib_list", attrib_list);
        this.end();
        EGLSurface result = this.mEgl10.eglCreatePixmapSurface(display, config, native_pixmap, attrib_list);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        this.begin("eglCreateWindowSurface");
        this.arg("display", display);
        this.arg("config", config);
        this.arg("native_window", native_window);
        this.arg("attrib_list", attrib_list);
        this.end();
        EGLSurface result = this.mEgl10.eglCreateWindowSurface(display, config, native_window, attrib_list);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglDestroyContext(EGLDisplay display, EGLContext context) {
        this.begin("eglDestroyContext");
        this.arg("display", display);
        this.arg("context", context);
        this.end();
        boolean result = this.mEgl10.eglDestroyContext(display, context);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglDestroySurface(EGLDisplay display, EGLSurface surface) {
        this.begin("eglDestroySurface");
        this.arg("display", display);
        this.arg("surface", surface);
        this.end();
        boolean result = this.mEgl10.eglDestroySurface(display, surface);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglGetConfigAttrib(EGLDisplay display, EGLConfig config, int attribute, int[] value) {
        this.begin("eglGetConfigAttrib");
        this.arg("display", display);
        this.arg("config", config);
        this.arg("attribute", attribute);
        this.end();
        boolean result = this.mEgl10.eglGetConfigAttrib(display, config, attribute, value);
        this.arg("value", value);
        this.returns(result);
        this.checkError();
        return false;
    }

    public boolean eglGetConfigs(EGLDisplay display, EGLConfig[] configs, int config_size, int[] num_config) {
        this.begin("eglGetConfigs");
        this.arg("display", display);
        this.arg("config_size", config_size);
        this.end();
        boolean result = this.mEgl10.eglGetConfigs(display, configs, config_size, num_config);
        this.arg("configs", configs);
        this.arg("num_config", num_config);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLContext eglGetCurrentContext() {
        this.begin("eglGetCurrentContext");
        this.end();
        EGLContext result = this.mEgl10.eglGetCurrentContext();
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLDisplay eglGetCurrentDisplay() {
        this.begin("eglGetCurrentDisplay");
        this.end();
        EGLDisplay result = this.mEgl10.eglGetCurrentDisplay();
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLSurface eglGetCurrentSurface(int readdraw) {
        this.begin("eglGetCurrentSurface");
        this.arg("readdraw", readdraw);
        this.end();
        EGLSurface result = this.mEgl10.eglGetCurrentSurface(readdraw);
        this.returns(result);
        this.checkError();
        return result;
    }

    public EGLDisplay eglGetDisplay(Object native_display) {
        this.begin("eglGetDisplay");
        this.arg("native_display", native_display);
        this.end();
        EGLDisplay result = this.mEgl10.eglGetDisplay(native_display);
        this.returns(result);
        this.checkError();
        return result;
    }

    public int eglGetError() {
        this.begin("eglGetError");
        this.end();
        int result = this.mEgl10.eglGetError();
        this.returns(EGLLogWrapper.getErrorString(result));
        return result;
    }

    public boolean eglInitialize(EGLDisplay display, int[] major_minor) {
        this.begin("eglInitialize");
        this.arg("display", display);
        this.end();
        boolean result = this.mEgl10.eglInitialize(display, major_minor);
        this.returns(result);
        this.arg("major_minor", major_minor);
        this.checkError();
        return result;
    }

    public boolean eglMakeCurrent(EGLDisplay display, EGLSurface draw, EGLSurface read, EGLContext context) {
        this.begin("eglMakeCurrent");
        this.arg("display", display);
        this.arg("draw", draw);
        this.arg("read", read);
        this.arg("context", context);
        this.end();
        boolean result = this.mEgl10.eglMakeCurrent(display, draw, read, context);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglQueryContext(EGLDisplay display, EGLContext context, int attribute, int[] value) {
        this.begin("eglQueryContext");
        this.arg("display", display);
        this.arg("context", context);
        this.arg("attribute", attribute);
        this.end();
        boolean result = this.mEgl10.eglQueryContext(display, context, attribute, value);
        this.returns(value[0]);
        this.returns(result);
        this.checkError();
        return result;
    }

    public String eglQueryString(EGLDisplay display, int name) {
        this.begin("eglQueryString");
        this.arg("display", display);
        this.arg("name", name);
        this.end();
        String result = this.mEgl10.eglQueryString(display, name);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglQuerySurface(EGLDisplay display, EGLSurface surface, int attribute, int[] value) {
        this.begin("eglQuerySurface");
        this.arg("display", display);
        this.arg("surface", surface);
        this.arg("attribute", attribute);
        this.end();
        boolean result = this.mEgl10.eglQuerySurface(display, surface, attribute, value);
        this.returns(value[0]);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglSwapBuffers(EGLDisplay display, EGLSurface surface) {
        this.begin("eglInitialize");
        this.arg("display", display);
        this.arg("surface", surface);
        this.end();
        boolean result = this.mEgl10.eglSwapBuffers(display, surface);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglTerminate(EGLDisplay display) {
        this.begin("eglTerminate");
        this.arg("display", display);
        this.end();
        boolean result = this.mEgl10.eglTerminate(display);
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglWaitGL() {
        this.begin("eglWaitGL");
        this.end();
        boolean result = this.mEgl10.eglWaitGL();
        this.returns(result);
        this.checkError();
        return result;
    }

    public boolean eglWaitNative(int engine, Object bindTarget) {
        this.begin("eglWaitNative");
        this.arg("engine", engine);
        this.arg("bindTarget", bindTarget);
        this.end();
        boolean result = this.mEgl10.eglWaitNative(engine, bindTarget);
        this.returns(result);
        this.checkError();
        return result;
    }

    private void checkError() {
        int eglError = this.mEgl10.eglGetError();
        if (eglError != 12288) {
            String errorMessage = "eglError: " + EGLLogWrapper.getErrorString(eglError);
            this.logLine(errorMessage);
            if (this.mCheckError) {
                throw new GLException(eglError, errorMessage);
            }
        }
    }

    private void logLine(String message) {
        this.log(message + '\n');
    }

    private void log(String message) {
        try {
            this.mLog.write(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void begin(String name) {
        this.log(name + '(');
        this.mArgCount = 0;
    }

    private void arg(String name, String value) {
        if (this.mArgCount++ > 0) {
            this.log(", ");
        }
        if (this.mLogArgumentNames) {
            this.log(name + "=");
        }
        this.log(value);
    }

    private void end() {
        this.log(");\n");
        this.flush();
    }

    private void flush() {
        try {
            this.mLog.flush();
        }
        catch (IOException e) {
            this.mLog = null;
        }
    }

    private void arg(String name, int value) {
        this.arg(name, Integer.toString(value));
    }

    private void arg(String name, Object object) {
        this.arg(name, this.toString(object));
    }

    private void arg(String name, EGLDisplay object) {
        if (object == EGL10.EGL_DEFAULT_DISPLAY) {
            this.arg(name, "EGL10.EGL_DEFAULT_DISPLAY");
        } else if (object == EGL_NO_DISPLAY) {
            this.arg(name, "EGL10.EGL_NO_DISPLAY");
        } else {
            this.arg(name, this.toString(object));
        }
    }

    private void arg(String name, EGLContext object) {
        if (object == EGL10.EGL_NO_CONTEXT) {
            this.arg(name, "EGL10.EGL_NO_CONTEXT");
        } else {
            this.arg(name, this.toString(object));
        }
    }

    private void arg(String name, EGLSurface object) {
        if (object == EGL10.EGL_NO_SURFACE) {
            this.arg(name, "EGL10.EGL_NO_SURFACE");
        } else {
            this.arg(name, this.toString(object));
        }
    }

    private void returns(String result) {
        this.log(" returns " + result + ";\n");
        this.flush();
    }

    private void returns(int result) {
        this.returns(Integer.toString(result));
    }

    private void returns(boolean result) {
        this.returns(Boolean.toString(result));
    }

    private void returns(Object result) {
        this.returns(this.toString(result));
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    private void arg(String name, int[] arr) {
        if (arr == null) {
            this.arg(name, "null");
        } else {
            this.arg(name, this.toString(arr.length, arr, 0));
        }
    }

    private void arg(String name, Object[] arr) {
        if (arr == null) {
            this.arg(name, "null");
        } else {
            this.arg(name, this.toString(arr.length, arr, 0));
        }
    }

    private String toString(int n, int[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private String toString(int n, Object[] arr, int offset) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        int arrLen = arr.length;
        for (int i = 0; i < n; ++i) {
            int index = offset + i;
            buf.append(" [" + index + "] = ");
            if (index < 0 || index >= arrLen) {
                buf.append("out of bounds");
            } else {
                buf.append(arr[index]);
            }
            buf.append('\n');
        }
        buf.append("}");
        return buf.toString();
    }

    private static String getHex(int value) {
        return "0x" + Integer.toHexString(value);
    }

    public static String getErrorString(int error) {
        switch (error) {
            case 12288: {
                return "EGL_SUCCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12302: {
                return "EGL_CONTEXT_LOST";
            }
        }
        return EGLLogWrapper.getHex(error);
    }
}

