/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class WifiInfo
implements Parcelable {
    private static final EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap = new EnumMap(SupplicantState.class);
    private SupplicantState mSupplicantState = SupplicantState.UNINITIALIZED;
    private String mBSSID = null;
    private String mSSID = null;
    private int mNetworkId = -1;
    private boolean mHiddenSSID = false;
    private int mRssi = -9999;
    public static final String LINK_SPEED_UNITS = "Mbps";
    private int mLinkSpeed = -1;
    private int mIpAddress = 0;
    private String mMacAddress;
    public static final Parcelable.Creator<WifiInfo> CREATOR;

    WifiInfo() {
    }

    void setSSID(String SSID) {
        this.mSSID = SSID;
        this.mHiddenSSID = false;
    }

    public String getSSID() {
        return this.mSSID;
    }

    void setBSSID(String BSSID) {
        this.mBSSID = BSSID;
    }

    public String getBSSID() {
        return this.mBSSID;
    }

    public int getRssi() {
        return this.mRssi;
    }

    void setRssi(int rssi) {
        this.mRssi = rssi;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    void setLinkSpeed(int linkSpeed) {
        this.mLinkSpeed = linkSpeed;
    }

    void setMacAddress(String macAddress) {
        this.mMacAddress = macAddress;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    void setNetworkId(int id2) {
        this.mNetworkId = id2;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public SupplicantState getSupplicantState() {
        return this.mSupplicantState;
    }

    void setSupplicantState(SupplicantState state) {
        this.mSupplicantState = state;
    }

    void setIpAddress(int address) {
        this.mIpAddress = address;
    }

    public int getIpAddress() {
        return this.mIpAddress;
    }

    public boolean getHiddenSSID() {
        return this.mHiddenSSID;
    }

    public void setHiddenSSID(boolean hiddenSSID) {
        this.mHiddenSSID = hiddenSSID;
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState suppState) {
        return stateMap.get(suppState);
    }

    void setSupplicantState(String stateName) {
        this.mSupplicantState = WifiInfo.valueOf(stateName);
    }

    static SupplicantState valueOf(String stateName) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(stateName)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            return SupplicantState.valueOf(stateName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return SupplicantState.INVALID;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.mSSID == null ? none : this.mSSID).append(", BSSID: ").append(this.mBSSID == null ? none : this.mBSSID).append(", MAC: ").append(this.mMacAddress == null ? none : this.mMacAddress).append(", Supplicant state: ").append(this.mSupplicantState == null ? none : this.mSupplicantState).append(", RSSI: ").append(this.mRssi).append(", Link speed: ").append(this.mLinkSpeed).append(", Net ID: ").append(this.mNetworkId);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkId);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeed);
        dest.writeInt(this.mIpAddress);
        dest.writeString(this.getSSID());
        dest.writeString(this.mBSSID);
        dest.writeString(this.mMacAddress);
        this.mSupplicantState.writeToParcel(dest, flags);
    }

    static {
        stateMap.put(SupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(SupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.FOUR_WAY_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.GROUP_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(SupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        CREATOR = new Parcelable.Creator<WifiInfo>(){

            @Override
            public WifiInfo createFromParcel(Parcel in) {
                WifiInfo info = new WifiInfo();
                info.setNetworkId(in.readInt());
                info.setRssi(in.readInt());
                info.setLinkSpeed(in.readInt());
                info.setIpAddress(in.readInt());
                info.setSSID(in.readString());
                info.mBSSID = in.readString();
                info.mMacAddress = in.readString();
                info.mSupplicantState = SupplicantState.CREATOR.createFromParcel(in);
                return info;
            }

            public WifiInfo[] newArray(int size) {
                return new WifiInfo[size];
            }
        };
    }
}

