/*
 * Decompiled with CFR 0.152.
 */
package android.net.vpn;

import android.net.vpn.VpnManager;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public abstract class VpnProfile
implements Parcelable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String mName;
    private String mId;
    private String mServerName;
    private String mDomainSuffices;
    private String mRouteList;
    private String mSavedUsername;
    private boolean mIsCustomized;
    private transient VpnState mState = VpnState.IDLE;
    public static final Parcelable.Creator<VpnProfile> CREATOR = new Parcelable.Creator<VpnProfile>(){

        @Override
        public VpnProfile createFromParcel(Parcel in) {
            boolean customized;
            VpnType type = Enum.valueOf(VpnType.class, in.readString());
            VpnProfile p = new VpnManager(null).createVpnProfile(type, customized = in.readInt() > 0);
            if (p == null) {
                return null;
            }
            p.readFromParcel(in);
            return p;
        }

        public VpnProfile[] newArray(int size) {
            return new VpnProfile[size];
        }
    };

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setId(String id2) {
        this.mId = id2;
    }

    public String getId() {
        return this.mId;
    }

    public void setServerName(String name) {
        this.mServerName = name;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public void setDomainSuffices(String entries) {
        this.mDomainSuffices = entries;
    }

    public String getDomainSuffices() {
        return this.mDomainSuffices;
    }

    public void setRouteList(String entries) {
        this.mRouteList = entries;
    }

    public String getRouteList() {
        return this.mRouteList;
    }

    public void setSavedUsername(String name) {
        this.mSavedUsername = name;
    }

    public String getSavedUsername() {
        return this.mSavedUsername;
    }

    public void setState(VpnState state) {
        this.mState = state;
    }

    public VpnState getState() {
        return this.mState == null ? VpnState.IDLE : this.mState;
    }

    public boolean isIdle() {
        return this.mState == VpnState.IDLE;
    }

    public boolean isCustomized() {
        return this.mIsCustomized;
    }

    public abstract VpnType getType();

    void setCustomized(boolean customized) {
        this.mIsCustomized = customized;
    }

    protected void readFromParcel(Parcel in) {
        this.mName = in.readString();
        this.mId = in.readString();
        this.mServerName = in.readString();
        this.mDomainSuffices = in.readString();
        this.mRouteList = in.readString();
        this.mSavedUsername = in.readString();
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.getType().toString());
        parcel.writeInt(this.mIsCustomized ? 1 : 0);
        parcel.writeString(this.mName);
        parcel.writeString(this.mId);
        parcel.writeString(this.mServerName);
        parcel.writeString(this.mDomainSuffices);
        parcel.writeString(this.mRouteList);
        parcel.writeString(this.mSavedUsername);
    }

    public int describeContents() {
        return 0;
    }
}

