/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.os.SystemClock;
import android.security.Sha1MessageDigest;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

class CertificateValidatorCache {
    public static long mSave = 0L;
    public static long mCost = 0L;
    private static final long CACHE_ENTRY_LIFETIME = 600000L;
    private static CertificateFactory sCertificateFactory;
    private HashMap<Integer, CacheEntry> mCacheMap;
    private int mBigScrew;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] secureHash(Certificate[] certificates) {
        byte[] secureHash = null;
        long beg = SystemClock.uptimeMillis();
        if (certificates != null && certificates.length != 0) {
            byte[] encodedCertPath = null;
            try {
                Class<CertificateValidatorCache> clazz = CertificateValidatorCache.class;
                synchronized (CertificateValidatorCache.class) {
                    if (sCertificateFactory == null) {
                        try {
                            sCertificateFactory = CertificateFactory.getInstance("X.509");
                        }
                        catch (GeneralSecurityException e) {
                            // empty catch block
                        }
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    CertPath certPath = sCertificateFactory.generateCertPath(Arrays.asList(certificates));
                    if (certPath != null && (encodedCertPath = certPath.getEncoded()) != null) {
                        Sha1MessageDigest messageDigest = new Sha1MessageDigest();
                        secureHash = messageDigest.digest(encodedCertPath);
                    }
                }
            }
            catch (GeneralSecurityException e) {
                // empty catch block
            }
        }
        {
            long end = SystemClock.uptimeMillis();
            mCost += end - beg;
            return secureHash;
        }
    }

    public CertificateValidatorCache() {
        Random random = new Random();
        this.mBigScrew = random.nextInt();
        this.mCacheMap = new HashMap();
    }

    public boolean has(String domain, byte[] secureHash) {
        CacheEntry cacheEntry;
        boolean rval = false;
        if (domain != null && domain.length() != 0 && secureHash != null && secureHash.length != 0 && (cacheEntry = this.mCacheMap.get(new Integer(this.mBigScrew ^ domain.hashCode()))) != null) {
            if (!cacheEntry.expired()) {
                rval = cacheEntry.has(domain, secureHash);
                if (rval) {
                    mSave += cacheEntry.mSave;
                }
            } else {
                this.mCacheMap.remove(cacheEntry);
            }
        }
        return rval;
    }

    public boolean put(String domain, byte[] secureHash, long save) {
        if (domain != null && domain.length() != 0 && secureHash != null && secureHash.length != 0) {
            this.mCacheMap.put(new Integer(this.mBigScrew ^ domain.hashCode()), new CacheEntry(domain, secureHash, save));
            return true;
        }
        return false;
    }

    private class CacheEntry {
        private byte[] mHash;
        private long mTime;
        public long mSave;
        private String mDomain;

        public CacheEntry(String domain, byte[] secureHash, long save) {
            this.mDomain = domain;
            this.mHash = secureHash;
            this.mSave = save;
            this.mTime = SystemClock.uptimeMillis();
        }

        public boolean expired() {
            return 600000L < SystemClock.uptimeMillis() - this.mTime;
        }

        public boolean has(String domain, byte[] secureHash) {
            int hashLength;
            if (domain != null && 0 < domain.length() && !this.mDomain.equals(domain)) {
                return false;
            }
            if (secureHash != null && 0 < (hashLength = secureHash.length) && hashLength == this.mHash.length) {
                for (int i = 0; i < hashLength; ++i) {
                    if (secureHash[i] == this.mHash[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

