/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import com.android.internal.net.DomainNameValidator;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;

class CertificateChainValidator {
    private static final CertificateChainValidator sInstance = new CertificateChainValidator();

    public static CertificateChainValidator getInstance() {
        return sInstance;
    }

    private CertificateChainValidator() {
    }

    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection connection, SSLSocket sslSocket, String domain) throws IOException {
        X509Certificate[] serverCertificates = null;
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
        }
        catch (IOException e) {
            this.closeSocketThrowException(sslSocket, e.getMessage(), "failed to perform SSL handshake");
        }
        Certificate[] peerCertificates = sslSocket.getSession().getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length <= 0) {
            this.closeSocketThrowException(sslSocket, "failed to retrieve peer certificates");
        } else {
            serverCertificates = new X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                serverCertificates[i] = (X509Certificate)peerCertificates[i];
            }
            if (connection != null && serverCertificates[0] != null) {
                connection.setCertificate(new SslCertificate(serverCertificates[0]));
            }
        }
        X509Certificate currCertificate = serverCertificates[0];
        if (currCertificate == null) {
            this.closeSocketThrowException(sslSocket, "certificate for this site is null");
        } else if (!DomainNameValidator.match(currCertificate, domain)) {
            String errorMessage = "certificate not for this host: " + domain;
            sslSocket.getSession().invalidate();
            return new SslError(2, currCertificate);
        }
        int chainLength = serverCertificates.length;
        if (serverCertificates.length > 1) {
            int currIndex;
            for (currIndex = 0; currIndex < serverCertificates.length; ++currIndex) {
                boolean foundNext = false;
                for (int nextIndex = currIndex + 1; nextIndex < serverCertificates.length; ++nextIndex) {
                    if (!((Object)serverCertificates[currIndex].getIssuerDN()).equals(serverCertificates[nextIndex].getSubjectDN())) continue;
                    foundNext = true;
                    if (nextIndex == currIndex + 1) break;
                    X509Certificate tempCertificate = serverCertificates[nextIndex];
                    serverCertificates[nextIndex] = serverCertificates[currIndex + 1];
                    serverCertificates[currIndex + 1] = tempCertificate;
                    break;
                }
                if (!foundNext) break;
            }
            chainLength = currIndex + 1;
            X509Certificate lastCertificate = serverCertificates[chainLength - 1];
            Date now = new Date();
            if (((Object)lastCertificate.getSubjectDN()).equals(lastCertificate.getIssuerDN()) && now.after(lastCertificate.getNotAfter())) {
                --chainLength;
            }
        }
        X509Certificate[] newServerCertificates = null;
        newServerCertificates = new X509Certificate[chainLength];
        for (int i = 0; i < chainLength; ++i) {
            newServerCertificates[i] = serverCertificates[i];
        }
        try {
            SSLParametersImpl.getDefaultTrustManager().checkServerTrusted(newServerCertificates, "RSA");
            return null;
        }
        catch (CertificateException e) {
            sslSocket.getSession().invalidate();
            return new SslError(3, currCertificate);
        }
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage, String defaultErrorMessage) throws IOException {
        this.closeSocketThrowException(socket, errorMessage != null ? errorMessage : defaultErrorMessage);
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage) throws IOException {
        if (socket != null) {
            SSLSession session = socket.getSession();
            if (session != null) {
                session.invalidate();
            }
            socket.close();
        }
        throw new SSLHandshakeException(errorMessage);
    }
}

