/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileWriter;
import java.io.IOException;

public abstract class NetworkStateTracker
extends Handler {
    protected NetworkInfo mNetworkInfo;
    protected Context mContext;
    protected Handler mTarget;
    protected String mInterfaceName;
    protected String[] mDnsPropNames;
    private boolean mPrivateDnsRouteSet;
    protected int mDefaultGatewayAddr;
    private boolean mTeardownRequested;
    private static boolean DBG = false;
    private static final String TAG = "NetworkStateTracker";
    private static final int MIN_NETWORK_STATE_TRACKER_EVENT = 1;
    private static final int MAX_NETWORK_STATE_TRACKER_EVENT = 100;
    public static final int EVENT_STATE_CHANGED = 1;
    public static final int EVENT_SCAN_RESULTS_AVAILABLE = 2;
    public static final int EVENT_NOTIFICATION_CHANGED = 3;
    public static final int EVENT_CONFIGURATION_CHANGED = 4;
    public static final int EVENT_ROAMING_CHANGED = 5;
    public static final int EVENT_NETWORK_SUBTYPE_CHANGED = 6;

    public NetworkStateTracker(Context context, Handler target, int networkType, int subType, String typeName, String subtypeName) {
        this.mContext = context;
        this.mTarget = target;
        this.mTeardownRequested = false;
        this.mNetworkInfo = new NetworkInfo(networkType, subType, typeName, subtypeName);
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public abstract String getTcpBufferSizesPropName();

    public String[] getNameServers() {
        return NetworkStateTracker.getNameServerList(this.mDnsPropNames);
    }

    protected static String[] getNameServerList(String[] propertyNames) {
        String[] dnsAddresses = new String[propertyNames.length];
        int j = 0;
        for (int i = 0; i < propertyNames.length; ++i) {
            String value = SystemProperties.get(propertyNames[i]);
            if (TextUtils.isEmpty(value) || TextUtils.equals(value, "0.0.0.0")) continue;
            dnsAddresses[j++] = value;
        }
        return dnsAddresses;
    }

    public void addPrivateDnsRoutes() {
        if (DBG) {
            Log.d(TAG, "addPrivateDnsRoutes for " + this + "(" + this.mInterfaceName + ") - mPrivateDnsRouteSet = " + this.mPrivateDnsRouteSet);
        }
        if (this.mInterfaceName != null && !this.mPrivateDnsRouteSet) {
            for (String addrString : this.getNameServers()) {
                int addr = NetworkUtils.lookupHost(addrString);
                if (addr == -1 || addr == 0) continue;
                if (DBG) {
                    Log.d(TAG, "  adding " + addrString + " (" + addr + ")");
                }
                NetworkUtils.addHostRoute(this.mInterfaceName, addr);
            }
            this.mPrivateDnsRouteSet = true;
        }
    }

    public void removePrivateDnsRoutes() {
        if (this.mInterfaceName != null && this.mPrivateDnsRouteSet) {
            if (DBG) {
                Log.d(TAG, "removePrivateDnsRoutes for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + ")");
            }
            NetworkUtils.removeHostRoutes(this.mInterfaceName);
            this.mPrivateDnsRouteSet = false;
        }
    }

    public void addDefaultRoute() {
        if (this.mInterfaceName != null && this.mDefaultGatewayAddr != 0) {
            if (DBG) {
                Log.d(TAG, "addDefaultRoute for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + "), GatewayAddr=" + this.mDefaultGatewayAddr);
            }
            NetworkUtils.addHostRoute(this.mInterfaceName, this.mDefaultGatewayAddr);
            NetworkUtils.setDefaultRoute(this.mInterfaceName, this.mDefaultGatewayAddr);
        }
    }

    public void removeDefaultRoute() {
        if (this.mInterfaceName != null) {
            if (DBG) {
                Log.d(TAG, "removeDefaultRoute for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + ")");
            }
            NetworkUtils.removeDefaultRoute(this.mInterfaceName);
        }
    }

    public void updateNetworkSettings() {
        String key = this.getTcpBufferSizesPropName();
        String bufferSizes = SystemProperties.get(key);
        if (bufferSizes.length() == 0) {
            Log.w(TAG, key + " not found in system properties. Using defaults");
            key = "net.tcp.buffersize.default";
            bufferSizes = SystemProperties.get(key);
        }
        if (bufferSizes.length() != 0) {
            if (DBG) {
                Log.v(TAG, "Setting TCP values: [" + bufferSizes + "] which comes from [" + key + "]");
            }
            this.setBufferSize(bufferSizes);
        }
    }

    public void releaseWakeLock() {
    }

    private void setBufferSize(String bufferSizes) {
        try {
            String[] values = bufferSizes.split(",");
            if (values.length == 6) {
                String prefix = "/sys/kernel/ipv4/tcp_";
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", values[0]);
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", values[1]);
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", values[2]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", values[3]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", values[4]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", values[5]);
            } else {
                Log.w(TAG, "Invalid buffersize string: " + bufferSizes);
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Can't set tcp buffer sizes:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stringToFile(String filename, String string2) throws IOException {
        FileWriter out = new FileWriter(filename);
        try {
            out.write(string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void setDetailedState(NetworkInfo.DetailedState state) {
        this.setDetailedState(state, null, null);
    }

    public void setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        if (DBG) {
            Log.d(TAG, "setDetailed state, old =" + (Object)((Object)this.mNetworkInfo.getDetailedState()) + " and new state=" + (Object)((Object)state));
        }
        if (state != this.mNetworkInfo.getDetailedState()) {
            boolean wasConnecting = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String lastReason = this.mNetworkInfo.getReason();
            if (wasConnecting && state == NetworkInfo.DetailedState.CONNECTED && reason == null && lastReason != null) {
                reason = lastReason;
            }
            this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
            Message msg = this.mTarget.obtainMessage(1, this.mNetworkInfo);
            msg.sendToTarget();
        }
    }

    protected void setDetailedStateInternal(NetworkInfo.DetailedState state) {
        this.mNetworkInfo.setDetailedState(state, null, null);
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested = isRequested;
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    protected void sendScanResultsAvailable() {
        Message msg = this.mTarget.obtainMessage(2, this.mNetworkInfo);
        msg.sendToTarget();
    }

    protected void setRoamingStatus(boolean isRoaming) {
        if (isRoaming != this.mNetworkInfo.isRoaming()) {
            this.mNetworkInfo.setRoaming(isRoaming);
            Message msg = this.mTarget.obtainMessage(5, this.mNetworkInfo);
            msg.sendToTarget();
        }
    }

    protected void setSubtype(int subtype, String subtypeName) {
        int oldSubtype = this.mNetworkInfo.getSubtype();
        if (subtype != oldSubtype) {
            this.mNetworkInfo.setSubtype(subtype, subtypeName);
            if (this.mNetworkInfo.isConnected()) {
                Message msg = this.mTarget.obtainMessage(6, oldSubtype, 0, this.mNetworkInfo);
                msg.sendToTarget();
            }
        }
    }

    public abstract void startMonitoring();

    public abstract boolean teardown();

    public abstract boolean reconnect();

    public abstract boolean setRadio(boolean var1);

    public abstract boolean isAvailable();

    public abstract int startUsingNetworkFeature(String var1, int var2, int var3);

    public abstract int stopUsingNetworkFeature(String var1, int var2, int var3);

    public boolean requestRouteToHost(int hostAddress) {
        return false;
    }

    public void interpretScanResultsAvailable() {
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }
}

