/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.IMediaScannerListener;
import android.media.IMediaScannerService;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class MediaScannerConnection
implements ServiceConnection {
    private static final String TAG = "MediaScannerConnection";
    private Context mContext;
    private MediaScannerConnectionClient mClient;
    private IMediaScannerService mService;
    private boolean mConnected;
    private IMediaScannerListener.Stub mListener = new IMediaScannerListener.Stub(){

        public void scanCompleted(String path, Uri uri) {
            MediaScannerConnectionClient client = MediaScannerConnection.this.mClient;
            if (client != null) {
                client.onScanCompleted(path, uri);
            }
        }
    };

    public MediaScannerConnection(Context context, MediaScannerConnectionClient client) {
        this.mContext = context;
        this.mClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (!this.mConnected) {
                Intent intent = new Intent(IMediaScannerService.class.getName());
                this.mContext.bindService(intent, this, 1);
                this.mConnected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (this.mConnected) {
                try {
                    this.mContext.unbindService(this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.mConnected = false;
            }
        }
    }

    public synchronized boolean isConnected() {
        return this.mService != null && this.mConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanFile(String path, String mimeType) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (this.mService == null || !this.mConnected) {
                throw new IllegalStateException("not connected to MediaScannerService");
            }
            try {
                this.mService.requestScanFile(path, mimeType, this.mListener);
            }
            catch (RemoteException e) {
                Log.d(TAG, "Failed to scan file " + path);
            }
        }
    }

    public static void scanFile(Context context, String[] paths, String[] mimeTypes, OnScanCompletedListener callback) {
        MediaScannerConnection connection;
        ClientProxy client = new ClientProxy(paths, mimeTypes, callback);
        client.mConnection = connection = new MediaScannerConnection(context, client);
        connection.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName className, IBinder service) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            this.mService = IMediaScannerService.Stub.asInterface(service);
            if (this.mService != null && this.mClient != null) {
                this.mClient.onMediaScannerConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceDisconnected(ComponentName className) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            this.mService = null;
        }
    }

    static class ClientProxy
    implements MediaScannerConnectionClient {
        final String[] mPaths;
        final String[] mMimeTypes;
        final OnScanCompletedListener mClient;
        MediaScannerConnection mConnection;
        int mNextPath;

        ClientProxy(String[] paths, String[] mimeTypes, OnScanCompletedListener client) {
            this.mPaths = paths;
            this.mMimeTypes = mimeTypes;
            this.mClient = client;
        }

        public void onMediaScannerConnected() {
            this.scanNextPath();
        }

        public void onScanCompleted(String path, Uri uri) {
            if (this.mClient != null) {
                this.mClient.onScanCompleted(path, uri);
            }
            this.scanNextPath();
        }

        void scanNextPath() {
            if (this.mNextPath >= this.mPaths.length) {
                this.mConnection.disconnect();
                return;
            }
            String mimeType = this.mMimeTypes != null ? this.mMimeTypes[this.mNextPath] : null;
            this.mConnection.scanFile(this.mPaths[this.mNextPath], mimeType);
            ++this.mNextPath;
        }
    }

    public static interface MediaScannerConnectionClient
    extends OnScanCompletedListener {
        public void onMediaScannerConnected();

        public void onScanCompleted(String var1, Uri var2);
    }

    public static interface OnScanCompletedListener {
        public void onScanCompleted(String var1, Uri var2);
    }
}

