/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.Camera;
import java.util.Arrays;
import java.util.HashMap;

public class CameraProfile {
    public static final int QUALITY_LOW = 0;
    public static final int QUALITY_MEDIUM = 1;
    public static final int QUALITY_HIGH = 2;
    private static final HashMap<Integer, int[]> sCache = new HashMap();

    public static int getJpegEncodingQualityParameter(int quality) {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return CameraProfile.getJpegEncodingQualityParameter(i, quality);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getJpegEncodingQualityParameter(int cameraId, int quality) {
        if (quality < 0 || quality > 2) {
            throw new IllegalArgumentException("Unsupported quality level: " + quality);
        }
        HashMap<Integer, int[]> hashMap = sCache;
        synchronized (hashMap) {
            int[] levels = sCache.get(cameraId);
            if (levels == null) {
                levels = CameraProfile.getImageEncodingQualityLevels(cameraId);
                sCache.put(cameraId, levels);
            }
            return levels[quality];
        }
    }

    private static int[] getImageEncodingQualityLevels(int cameraId) {
        int nLevels = CameraProfile.native_get_num_image_encoding_quality_levels(cameraId);
        if (nLevels != 3) {
            throw new RuntimeException("Unexpected Jpeg encoding quality levels " + nLevels);
        }
        int[] levels = new int[nLevels];
        for (int i = 0; i < nLevels; ++i) {
            levels[i] = CameraProfile.native_get_image_encoding_quality_level(cameraId, i);
        }
        Arrays.sort(levels);
        return levels;
    }

    private static final native void native_init();

    private static final native int native_get_num_image_encoding_quality_levels(int var0);

    private static final native int native_get_image_encoding_quality_level(int var0, int var1);

    static {
        System.loadLibrary("media_jni");
        CameraProfile.native_init();
    }
}

