/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.Xfermode;

public class BoundaryPatch {
    private Paint mPaint;
    private Bitmap mTexture;
    private int mRows = 2;
    private int mCols = 2;
    private float[] mCubicPoints = new float[24];
    private boolean mDirty;
    private float[] mVerts;
    private short[] mIndices;

    public BoundaryPatch() {
        this.mPaint = new Paint();
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mDirty = true;
    }

    public void setCubicBoundary(float[] pts, int offset, int rows, int cols) {
        if (rows < 2 || cols < 2) {
            throw new RuntimeException("rows and cols must be >= 2");
        }
        System.arraycopy(pts, offset, this.mCubicPoints, 0, 24);
        if (this.mRows != rows || this.mCols != cols) {
            this.mRows = rows;
            this.mCols = cols;
        }
        this.mDirty = true;
    }

    public void setTexture(Bitmap texture) {
        if (this.mTexture != texture) {
            if (this.mTexture == null || this.mTexture.getWidth() != texture.getWidth() || this.mTexture.getHeight() != texture.getHeight()) {
                this.mDirty = true;
            }
            this.mTexture = texture;
            this.mPaint.setShader(new BitmapShader(texture, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        }
    }

    public int getPaintFlags() {
        return this.mPaint.getFlags();
    }

    public void setPaintFlags(int flags) {
        this.mPaint.setFlags(flags);
    }

    public void setXfermode(Xfermode mode) {
        this.mPaint.setXfermode(mode);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildCache();
            this.mDirty = false;
        }
        int vertCount = this.mVerts.length >> 1;
        canvas.drawVertices(Canvas.VertexMode.TRIANGLES, vertCount, this.mVerts, 0, this.mVerts, vertCount, null, 0, this.mIndices, 0, this.mIndices.length, this.mPaint);
    }

    private void buildCache() {
        int vertCount = this.mRows * this.mCols * 4;
        if (this.mVerts == null || this.mVerts.length != vertCount) {
            this.mVerts = new float[vertCount];
        }
        int indexCount = (this.mRows - 1) * (this.mCols - 1) * 6;
        if (this.mIndices == null || this.mIndices.length != indexCount) {
            this.mIndices = new short[indexCount];
        }
        BoundaryPatch.nativeComputeCubicPatch(this.mCubicPoints, this.mTexture.getWidth(), this.mTexture.getHeight(), this.mRows, this.mCols, this.mVerts, this.mIndices);
    }

    private static native void nativeComputeCubicPatch(float[] var0, int var1, int var2, int var3, int var4, float[] var5, short[] var6);
}

