/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable {
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private BitmapState mBitmapState;
    private Bitmap mBitmap;
    private int mTargetDensity;
    private final Rect mDstRect = new Rect();
    private boolean mApplyGravity;
    private boolean mRebuildShader;
    private boolean mMutated;
    private int mBitmapWidth;
    private int mBitmapHeight;

    @Deprecated
    public BitmapDrawable() {
        this.mBitmapState = new BitmapState((Bitmap)null);
    }

    public BitmapDrawable(Resources res) {
        this.mBitmapState = new BitmapState((Bitmap)null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    public BitmapDrawable(Bitmap bitmap) {
        this(new BitmapState(bitmap), null);
    }

    public BitmapDrawable(Resources res, Bitmap bitmap) {
        this(new BitmapState(bitmap), res);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    public BitmapDrawable(String filepath) {
        this(new BitmapState(BitmapFactory.decodeFile(filepath)), null);
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        }
    }

    public BitmapDrawable(Resources res, String filepath) {
        this(new BitmapState(BitmapFactory.decodeFile(filepath)), null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        }
    }

    @Deprecated
    public BitmapDrawable(InputStream is) {
        this(new BitmapState(BitmapFactory.decodeStream(is)), null);
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
        }
    }

    public BitmapDrawable(Resources res, InputStream is) {
        this(new BitmapState(BitmapFactory.decodeStream(is)), null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
        }
    }

    public final Paint getPaint() {
        return this.mBitmapState.mPaint;
    }

    public final Bitmap getBitmap() {
        return this.mBitmap;
    }

    private void computeBitmapSize() {
        this.mBitmapWidth = this.mBitmap.getScaledWidth(this.mTargetDensity);
        this.mBitmapHeight = this.mBitmap.getScaledHeight(this.mTargetDensity);
    }

    private void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        if (bitmap != null) {
            this.computeBitmapSize();
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics metrics) {
        this.mTargetDensity = metrics.densityDpi;
        if (this.mBitmap != null) {
            this.computeBitmapSize();
        }
    }

    public void setTargetDensity(int density) {
        int n = this.mTargetDensity = density == 0 ? 160 : density;
        if (this.mBitmap != null) {
            this.computeBitmapSize();
        }
    }

    public int getGravity() {
        return this.mBitmapState.mGravity;
    }

    public void setGravity(int gravity) {
        this.mBitmapState.mGravity = gravity;
        this.mApplyGravity = true;
    }

    public void setAntiAlias(boolean aa) {
        this.mBitmapState.mPaint.setAntiAlias(aa);
    }

    public void setFilterBitmap(boolean filter) {
        this.mBitmapState.mPaint.setFilterBitmap(filter);
    }

    public void setDither(boolean dither) {
        this.mBitmapState.mPaint.setDither(dither);
    }

    public Shader.TileMode getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    public Shader.TileMode getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    public void setTileModeX(Shader.TileMode mode) {
        this.setTileModeXY(mode, this.mBitmapState.mTileModeY);
    }

    public final void setTileModeY(Shader.TileMode mode) {
        this.setTileModeXY(this.mBitmapState.mTileModeX, mode);
    }

    public void setTileModeXY(Shader.TileMode xmode, Shader.TileMode ymode) {
        BitmapState state = this.mBitmapState;
        if (state.mPaint.getShader() == null || state.mTileModeX != xmode || state.mTileModeY != ymode) {
            state.mTileModeX = xmode;
            state.mTileModeY = ymode;
            this.mRebuildShader = true;
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mBitmapState.mChangingConfigurations;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mApplyGravity = true;
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null) {
            Shader shader;
            BitmapState state = this.mBitmapState;
            if (this.mRebuildShader) {
                Shader.TileMode tmx = state.mTileModeX;
                Shader.TileMode tmy = state.mTileModeY;
                if (tmx == null && tmy == null) {
                    state.mPaint.setShader(null);
                } else {
                    BitmapShader s = new BitmapShader(bitmap, tmx == null ? Shader.TileMode.CLAMP : tmx, tmy == null ? Shader.TileMode.CLAMP : tmy);
                    state.mPaint.setShader(s);
                }
                this.mRebuildShader = false;
                this.copyBounds(this.mDstRect);
            }
            if ((shader = state.mPaint.getShader()) == null) {
                if (this.mApplyGravity) {
                    Gravity.apply(state.mGravity, this.mBitmapWidth, this.mBitmapHeight, this.getBounds(), this.mDstRect);
                    this.mApplyGravity = false;
                }
                canvas.drawBitmap(bitmap, null, this.mDstRect, state.mPaint);
            } else {
                if (this.mApplyGravity) {
                    this.mDstRect.set(this.getBounds());
                    this.mApplyGravity = false;
                }
                canvas.drawRect(this.mDstRect, state.mPaint);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.mBitmapState.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBitmapState.mPaint.setColorFilter(cf);
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mBitmapState = new BitmapState(this.mBitmapState);
            this.mMutated = true;
        }
        return this;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.BitmapDrawable);
        int id2 = a.getResourceId(1, 0);
        if (id2 == 0) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <bitmap> requires a valid src attribute");
        }
        Bitmap bitmap = BitmapFactory.decodeResource(r, id2);
        if (bitmap == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <bitmap> requires a valid src attribute");
        }
        this.mBitmapState.mBitmap = bitmap;
        this.setBitmap(bitmap);
        this.setTargetDensity(r.getDisplayMetrics());
        Paint paint = this.mBitmapState.mPaint;
        paint.setAntiAlias(a.getBoolean(2, paint.isAntiAlias()));
        paint.setFilterBitmap(a.getBoolean(3, paint.isFilterBitmap()));
        paint.setDither(a.getBoolean(4, paint.isDither()));
        this.setGravity(a.getInt(0, 119));
        int tileMode = a.getInt(5, -1);
        if (tileMode != -1) {
            switch (tileMode) {
                case 0: {
                    this.setTileModeXY(Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    break;
                }
                case 1: {
                    this.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    break;
                }
                case 2: {
                    this.setTileModeXY(Shader.TileMode.MIRROR, Shader.TileMode.MIRROR);
                }
            }
        }
        a.recycle();
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public int getOpacity() {
        if (this.mBitmapState.mGravity != 119) {
            return -3;
        }
        Bitmap bm = this.mBitmap;
        return bm == null || bm.hasAlpha() || this.mBitmapState.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    public final Drawable.ConstantState getConstantState() {
        this.mBitmapState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mBitmapState;
    }

    private BitmapDrawable(BitmapState state, Resources res) {
        this.mBitmapState = state;
        this.mTargetDensity = res != null ? res.getDisplayMetrics().densityDpi : (state != null ? state.mTargetDensity : 160);
        this.setBitmap(state.mBitmap);
    }

    static final class BitmapState
    extends Drawable.ConstantState {
        Bitmap mBitmap;
        int mChangingConfigurations;
        int mGravity = 119;
        Paint mPaint = new Paint(6);
        Shader.TileMode mTileModeX;
        Shader.TileMode mTileModeY;
        int mTargetDensity = 160;

        BitmapState(Bitmap bitmap) {
            this.mBitmap = bitmap;
        }

        BitmapState(BitmapState bitmapState) {
            this(bitmapState.mBitmap);
            this.mChangingConfigurations = bitmapState.mChangingConfigurations;
            this.mGravity = bitmapState.mGravity;
            this.mTileModeX = bitmapState.mTileModeX;
            this.mTileModeY = bitmapState.mTileModeY;
            this.mTargetDensity = bitmapState.mTargetDensity;
            this.mPaint = new Paint(bitmapState.mPaint);
        }

        public Drawable newDrawable() {
            return new BitmapDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new BitmapDrawable(this, res);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

