/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    private final int mNativeMovie;

    private Movie(int nativeMovie) {
        if (nativeMovie == 0) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = nativeMovie;
    }

    public native int width();

    public native int height();

    public native boolean isOpaque();

    public native int duration();

    public native boolean setTime(int var1);

    public native void draw(Canvas var1, float var2, float var3, Paint var4);

    public void draw(Canvas canvas, float x, float y) {
        this.draw(canvas, x, y, null);
    }

    public static native Movie decodeStream(InputStream var0);

    public static native Movie decodeByteArray(byte[] var0, int var1, int var2);

    public static Movie decodeFile(String pathName) {
        FileInputStream is;
        try {
            is = new FileInputStream(pathName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return Movie.decodeTempStream(is);
    }

    private static Movie decodeTempStream(InputStream is) {
        Movie moov = null;
        try {
            moov = Movie.decodeStream(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moov;
    }
}

