/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class Bitmap
implements Parcelable {
    public static final int DENSITY_NONE = 0;
    private final int mNativeBitmap;
    private final boolean mIsMutable;
    private byte[] mNinePatchChunk;
    private int mWidth = -1;
    private int mHeight = -1;
    private boolean mRecycled;
    int mDensity = sDefaultDensity = Bitmap.getDefaultDensity();
    private static volatile Matrix sScaleMatrix;
    private static volatile int sDefaultDensity;
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    public static final Parcelable.Creator<Bitmap> CREATOR;

    public static void setDefaultDensity(int density) {
        sDefaultDensity = density;
    }

    static int getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    private Bitmap(int nativeBitmap, boolean isMutable, byte[] ninePatchChunk, int density) {
        if (nativeBitmap == 0) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mNativeBitmap = nativeBitmap;
        this.mIsMutable = isMutable;
        this.mNinePatchChunk = ninePatchChunk;
        if (density >= 0) {
            this.mDensity = density;
        }
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        this.mDensity = density;
    }

    public void setNinePatchChunk(byte[] chunk) {
        this.mNinePatchChunk = chunk;
    }

    public void recycle() {
        if (!this.mRecycled) {
            Bitmap.nativeRecycle(this.mNativeBitmap);
            this.mNinePatchChunk = null;
            this.mRecycled = true;
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkXYSign(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    private static void checkWidthHeight(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    public void copyPixelsToBuffer(Buffer dst) {
        int shift;
        int elements = dst.remaining();
        if (dst instanceof ByteBuffer) {
            shift = 0;
        } else if (dst instanceof ShortBuffer) {
            shift = 1;
        } else if (dst instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferSize = (long)elements << shift;
        long pixelSize = (long)this.getRowBytes() * (long)this.getHeight();
        if (bufferSize < pixelSize) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativeBitmap, dst);
        int position = dst.position();
        position = (int)((long)position + (pixelSize >> shift));
        dst.position(position);
    }

    public void copyPixelsFromBuffer(Buffer src) {
        int shift;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        int elements = src.remaining();
        if (src instanceof ByteBuffer) {
            shift = 0;
        } else if (src instanceof ShortBuffer) {
            shift = 1;
        } else if (src instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferBytes = (long)elements << shift;
        long bitmapBytes = (long)this.getRowBytes() * (long)this.getHeight();
        if (bufferBytes < bitmapBytes) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativeBitmap, src);
    }

    public Bitmap copy(Config config, boolean isMutable) {
        this.checkRecycled("Can't copy a recycled bitmap");
        Bitmap b = Bitmap.nativeCopy(this.mNativeBitmap, config.nativeInt, isMutable);
        if (b != null) {
            b.mDensity = this.mDensity;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Class<Bitmap> clazz = Bitmap.class;
        synchronized (Bitmap.class) {
            Matrix m = sScaleMatrix;
            sScaleMatrix = null;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (m == null) {
                m = new Matrix();
            }
            int width = src.getWidth();
            int height = src.getHeight();
            float sx = (float)dstWidth / (float)width;
            float sy = (float)dstHeight / (float)height;
            m.setScale(sx, sy);
            Bitmap b = Bitmap.createBitmap(src, 0, 0, width, height, m, filter);
            Class<Bitmap> clazz2 = Bitmap.class;
            synchronized (Bitmap.class) {
                if (sScaleMatrix == null) {
                    sScaleMatrix = m;
                }
                // ** MonitorExit[var10_12] (shouldn't be in output)
                return b;
            }
        }
    }

    public static Bitmap createBitmap(Bitmap src) {
        return Bitmap.createBitmap(src, 0, 0, src.getWidth(), src.getHeight());
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height) {
        return Bitmap.createBitmap(source, x, y, width, height, null, false);
    }

    public static Bitmap createBitmap(Bitmap source, int x, int y, int width, int height, Matrix m, boolean filter) {
        Paint paint;
        Bitmap bitmap;
        Bitmap.checkXYSign(x, y);
        Bitmap.checkWidthHeight(width, height);
        if (x + width > source.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > source.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!source.isMutable() && x == 0 && y == 0 && width == source.getWidth() && height == source.getHeight() && (m == null || m.isIdentity())) {
            return source;
        }
        int neww = width;
        int newh = height;
        Canvas canvas = new Canvas();
        Rect srcR = new Rect(x, y, x + width, y + height);
        RectF dstR = new RectF(0.0f, 0.0f, width, height);
        if (m == null || m.isIdentity()) {
            bitmap = Bitmap.createBitmap(neww, newh, source.hasAlpha() ? Config.ARGB_8888 : Config.RGB_565);
            paint = null;
        } else {
            boolean hasAlpha = source.hasAlpha() || !m.rectStaysRect();
            RectF deviceR = new RectF();
            m.mapRect(deviceR, dstR);
            neww = Math.round(deviceR.width());
            newh = Math.round(deviceR.height());
            bitmap = Bitmap.createBitmap(neww, newh, hasAlpha ? Config.ARGB_8888 : Config.RGB_565);
            if (hasAlpha) {
                bitmap.eraseColor(0);
            }
            canvas.translate(-deviceR.left, -deviceR.top);
            canvas.concat(m);
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (!m.rectStaysRect()) {
                paint.setAntiAlias(true);
            }
        }
        bitmap.mDensity = source.mDensity;
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(source, srcR, dstR, paint);
        return bitmap;
    }

    public static Bitmap createBitmap(int width, int height, Config config) {
        Bitmap bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true);
        bm.eraseColor(0);
        return bm;
    }

    public static Bitmap createBitmap(int[] colors, int offset, int stride, int width, int height, Config config) {
        Bitmap.checkWidthHeight(width, height);
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Bitmap.nativeCreate(colors, offset, stride, width, height, config.nativeInt, false);
    }

    public static Bitmap createBitmap(int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(colors, 0, width, width, height, config);
    }

    public byte[] getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    public boolean compress(CompressFormat format, int quality, OutputStream stream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (stream == null) {
            throw new NullPointerException();
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        return Bitmap.nativeCompress(this.mNativeBitmap, format.nativeInt, quality, stream, new byte[4096]);
    }

    public final boolean isMutable() {
        return this.mIsMutable;
    }

    public final int getWidth() {
        return this.mWidth == -1 ? (this.mWidth = Bitmap.nativeWidth(this.mNativeBitmap)) : this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight == -1 ? (this.mHeight = Bitmap.nativeHeight(this.mNativeBitmap)) : this.mHeight;
    }

    public int getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    public int getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    public int getScaledWidth(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledHeight(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, metrics.densityDpi);
    }

    public int getScaledWidth(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    public int getScaledHeight(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    public static int scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    public final int getRowBytes() {
        return Bitmap.nativeRowBytes(this.mNativeBitmap);
    }

    public final Config getConfig() {
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativeBitmap));
    }

    public final boolean hasAlpha() {
        return Bitmap.nativeHasAlpha(this.mNativeBitmap);
    }

    public void setHasAlpha(boolean hasAlpha) {
        Bitmap.nativeSetHasAlpha(this.mNativeBitmap, hasAlpha);
    }

    public void eraseColor(int c) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativeBitmap, c);
    }

    public int getPixel(int x, int y) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkPixelAccess(x, y);
        return Bitmap.nativeGetPixel(this.mNativeBitmap, x, y);
    }

    public void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeGetPixels(this.mNativeBitmap, pixels, offset, stride, x, y, width, height);
    }

    private void checkPixelAccess(int x, int y) {
        Bitmap.checkXYSign(x, y);
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private void checkPixelsAccess(int x, int y, int width, int height, int offset, int stride, int[] pixels) {
        Bitmap.checkXYSign(x, y);
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = pixels.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void setPixel(int x, int y, int color2) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(x, y);
        Bitmap.nativeSetPixel(this.mNativeBitmap, x, y, color2);
    }

    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeSetPixels(this.mNativeBitmap, pixels, offset, stride, x, y, width, height);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel p, int flags) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        if (!Bitmap.nativeWriteToParcel(this.mNativeBitmap, this.mIsMutable, this.mDensity, p)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    public Bitmap extractAlpha() {
        return this.extractAlpha(null, null);
    }

    public Bitmap extractAlpha(Paint paint, int[] offsetXY) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        int nativePaint = paint != null ? paint.mNativePaint : 0;
        Bitmap bm = Bitmap.nativeExtractAlpha(this.mNativeBitmap, nativePaint, offsetXY);
        if (bm == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bm.mDensity = this.mDensity;
        return bm;
    }

    public boolean sameAs(Bitmap other) {
        return this == other || other != null && Bitmap.nativeSameAs(this.mNativeBitmap, other.mNativeBitmap);
    }

    public void prepareToDraw() {
        Bitmap.nativePrepareToDraw(this.mNativeBitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Bitmap.nativeDestructor(this.mNativeBitmap);
        }
        finally {
            super.finalize();
        }
    }

    private static native Bitmap nativeCreate(int[] var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    private static native Bitmap nativeCopy(int var0, int var1, boolean var2);

    private static native void nativeDestructor(int var0);

    private static native void nativeRecycle(int var0);

    private static native boolean nativeCompress(int var0, int var1, int var2, OutputStream var3, byte[] var4);

    private static native void nativeErase(int var0, int var1);

    private static native int nativeWidth(int var0);

    private static native int nativeHeight(int var0);

    private static native int nativeRowBytes(int var0);

    private static native int nativeConfig(int var0);

    private static native boolean nativeHasAlpha(int var0);

    private static native int nativeGetPixel(int var0, int var1, int var2);

    private static native void nativeGetPixels(int var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeSetPixel(int var0, int var1, int var2, int var3);

    private static native void nativeSetPixels(int var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeCopyPixelsToBuffer(int var0, Buffer var1);

    private static native void nativeCopyPixelsFromBuffer(int var0, Buffer var1);

    private static native Bitmap nativeCreateFromParcel(Parcel var0);

    private static native boolean nativeWriteToParcel(int var0, boolean var1, int var2, Parcel var3);

    private static native Bitmap nativeExtractAlpha(int var0, int var1, int[] var2);

    private static native void nativePrepareToDraw(int var0);

    private static native void nativeSetHasAlpha(int var0, boolean var1);

    private static native boolean nativeSameAs(int var0, int var1);

    final int ni() {
        return this.mNativeBitmap;
    }

    static {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){

            @Override
            public Bitmap createFromParcel(Parcel p) {
                Bitmap bm = Bitmap.nativeCreateFromParcel(p);
                if (bm == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bm;
            }

            public Bitmap[] newArray(int size) {
                return new Bitmap[size];
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressFormat {
        JPEG(0),
        PNG(1);

        final int nativeInt;

        private CompressFormat(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Config {
        ALPHA_8(2),
        RGB_565(4),
        ARGB_4444(5),
        ARGB_8888(6);

        final int nativeInt;
        private static Config[] sConfigs;

        private Config(int ni) {
            this.nativeInt = ni;
        }

        static Config nativeToConfig(int ni) {
            return sConfigs[ni];
        }

        static {
            sConfigs = new Config[]{null, null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888};
        }
    }
}

