/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.AppGlobals;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.Debug;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import dalvik.system.BlockGuard;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends SQLiteClosable {
    private static final String TAG = "Database";
    private static final int EVENT_DB_OPERATION = 52000;
    private static final int EVENT_DB_CORRUPT = 75004;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    private static final int OPEN_READ_MASK = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    private boolean mInnerTransactionIsSuccessful;
    private boolean mTransactionIsSuccessful;
    private SQLiteTransactionListener mTransactionListener;
    private final ReentrantLock mLock = new ReentrantLock(true);
    private long mLockAcquiredWallTime = 0L;
    private long mLockAcquiredThreadTime = 0L;
    private static final int LOCK_WARNING_WINDOW_IN_MS = 20000;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS = 300;
    private static final int LOCK_ACQUIRED_WARNING_THREAD_TIME_IN_MS = 100;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS_ALWAYS_PRINT = 2000;
    private static final int SLEEP_AFTER_YIELD_QUANTUM = 1000;
    private static final Pattern EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    private long mLastLockMessageTime = 0L;
    private static int sQueryLogTimeInMillis = 0;
    private static final int QUERY_LOG_SQL_LENGTH = 64;
    private static final String COMMIT_SQL = "COMMIT;";
    private final Random mRandom = new Random();
    private String mLastSqlStatement = null;
    static final String GET_LOCK_LOG_PREFIX = "GETLOCK:";
    int mNativeHandle = 0;
    int mTempTableSequence = 0;
    private String mPath;
    private String mPathForLogs = null;
    private int mFlags;
    private CursorFactory mFactory;
    private WeakHashMap<SQLiteClosable, Object> mPrograms;
    Map<String, SQLiteCompiledSql> mCompiledQueries = Maps.newHashMap();
    public static final int MAX_SQL_CACHE_SIZE = 250;
    private int mMaxSqlCacheSize = 250;
    private int mCacheFullWarnings;
    private static final int MAX_WARNINGS_ON_CACHESIZE_CONDITION = 1;
    private int mNumCacheHits;
    private int mNumCacheMisses;
    private String mTimeOpened = null;
    private String mTimeClosed = null;
    private Throwable mStackTrace = null;
    private static final String LOG_SLOW_QUERIES_PROPERTY = "db.log.slow_query_threshold";
    private final int mSlowQueryThreshold;
    private boolean mLockingEnabled = true;
    private final Map<String, SyncUpdateInfo> mSyncUpdateInfo = new HashMap<String, SyncUpdateInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.put(closable, null);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.remove(closable);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        if (this.isOpen()) {
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                this.mTimeClosed = this.getTime();
            }
            this.dbclose();
        }
    }

    public static native int releaseMemory();

    public void setLockingEnabled(boolean lockingEnabled) {
        this.mLockingEnabled = lockingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCorruption() {
        Log.e(TAG, "Removing corrupt database: " + this.mPath);
        EventLog.writeEvent(75004, this.mPath);
        try {
            this.close();
        }
        finally {
            if (!this.mPath.equalsIgnoreCase(":memory")) {
                new File(this.mPath).delete();
            }
        }
    }

    void lock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.lock();
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
        }
    }

    private void lockForced() {
        this.mLock.lock();
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
        }
    }

    void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void unlockForced() {
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void checkLockHoldTime() {
        int threadTime;
        long elapsedTime = SystemClock.elapsedRealtime();
        long lockedTime = elapsedTime - this.mLockAcquiredWallTime;
        if (lockedTime < 2000L && !Log.isLoggable(TAG, 2) && elapsedTime - this.mLastLockMessageTime < 20000L) {
            return;
        }
        if (lockedTime > 300L && ((threadTime = (int)((Debug.threadCpuTimeNanos() - this.mLockAcquiredThreadTime) / 1000000L)) > 100 || lockedTime > 2000L)) {
            this.mLastLockMessageTime = elapsedTime;
            String msg = "lock held on " + this.mPath + " for " + lockedTime + "ms. Thread time was " + threadTime + "ms";
            if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING_STACK_TRACE) {
                Log.d(TAG, msg, new Exception());
            } else {
                Log.d(TAG, msg);
            }
        }
    }

    public void beginTransaction() {
        this.beginTransactionWithListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.lockForced();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        boolean ok = false;
        try {
            if (this.mLock.getHoldCount() > 1) {
                if (this.mInnerTransactionIsSuccessful) {
                    String msg = "Cannot call beginTransaction between calling setTransactionSuccessful and endTransaction";
                    IllegalStateException e = new IllegalStateException(msg);
                    Log.e(TAG, "beginTransaction() failed", e);
                    throw e;
                }
                ok = true;
                return;
            }
            this.execSQL("BEGIN EXCLUSIVE;");
            this.mTransactionListener = transactionListener;
            this.mTransactionIsSuccessful = true;
            this.mInnerTransactionIsSuccessful = false;
            if (transactionListener != null) {
                try {
                    transactionListener.onBegin();
                }
                catch (RuntimeException e) {
                    this.execSQL("ROLLBACK;");
                    throw e;
                }
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.unlockForced();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        block18: {
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            if (!this.mLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("no transaction pending");
            }
            try {
                if (this.mInnerTransactionIsSuccessful) {
                    this.mInnerTransactionIsSuccessful = false;
                } else {
                    this.mTransactionIsSuccessful = false;
                }
                if (this.mLock.getHoldCount() != 1) {
                    return;
                }
                RuntimeException savedException = null;
                if (this.mTransactionListener != null) {
                    try {
                        if (this.mTransactionIsSuccessful) {
                            this.mTransactionListener.onCommit();
                        } else {
                            this.mTransactionListener.onRollback();
                        }
                    }
                    catch (RuntimeException e) {
                        savedException = e;
                        this.mTransactionIsSuccessful = false;
                    }
                }
                if (this.mTransactionIsSuccessful) {
                    this.execSQL(COMMIT_SQL);
                    break block18;
                }
                try {
                    this.execSQL("ROLLBACK;");
                    if (savedException != null) {
                        throw savedException;
                    }
                }
                catch (SQLException e) {
                    Log.d(TAG, "exception during rollback, maybe the DB previously performed an auto-rollback");
                }
            }
            finally {
                this.mTransactionListener = null;
                this.unlockForced();
            }
        }
    }

    public void setTransactionSuccessful() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        if (this.mInnerTransactionIsSuccessful) {
            throw new IllegalStateException("setTransactionSuccessful may only be called once per call to beginTransaction");
        }
        this.mInnerTransactionIsSuccessful = true;
    }

    public boolean inTransaction() {
        return this.mLock.getHoldCount() > 0;
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mLock.isHeldByCurrentThread();
    }

    public boolean isDbLockedByOtherThreads() {
        return !this.mLock.isHeldByCurrentThread() && this.mLock.isLocked();
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    private boolean yieldIfContendedHelper(boolean checkFullyYielded, long sleepAfterYieldDelay) {
        if (this.mLock.getQueueLength() == 0) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
            return false;
        }
        this.setTransactionSuccessful();
        SQLiteTransactionListener transactionListener = this.mTransactionListener;
        this.endTransaction();
        if (checkFullyYielded && this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Db locked more than once. yielfIfContended cannot yield");
        }
        if (sleepAfterYieldDelay > 0L) {
            for (long remainingDelay = sleepAfterYieldDelay; remainingDelay > 0L; remainingDelay -= 1000L) {
                try {
                    Thread.sleep(remainingDelay < 1000L ? remainingDelay : 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.mLock.getQueueLength() != 0) continue;
            }
        }
        this.beginTransactionWithListener(transactionListener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSyncedTables() {
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            HashMap<String, String> tables = new HashMap<String, String>();
            for (String table : this.mSyncUpdateInfo.keySet()) {
                SyncUpdateInfo info = this.mSyncUpdateInfo.get(table);
                if (info.deletedTable == null) continue;
                tables.put(table, info.deletedTable);
            }
            return tables;
        }
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags) {
        SQLiteDatabase sqliteDatabase = null;
        try {
            sqliteDatabase = new SQLiteDatabase(path, factory, flags);
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                sqliteDatabase.enableSqlTracing(path);
            }
            if (SQLiteDebug.DEBUG_SQL_TIME) {
                sqliteDatabase.enableSqlProfiling(path);
            }
        }
        catch (SQLiteDatabaseCorruptException e) {
            Log.e(TAG, "Deleting and re-creating corrupt database " + path, e);
            EventLog.writeEvent(75004, path);
            if (!path.equalsIgnoreCase(":memory")) {
                new File(path).delete();
            }
            sqliteDatabase = new SQLiteDatabase(path, factory, flags);
        }
        ActiveDatabases.getInstance().mActiveDatabases.add(new WeakReference<SQLiteDatabase>(sqliteDatabase));
        return sqliteDatabase;
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 0x10000000);
    }

    public static SQLiteDatabase create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.lock();
        try {
            this.closeClosable();
            this.onAllReferencesReleased();
        }
        finally {
            this.unlock();
        }
    }

    private void closeClosable() {
        this.deallocCachedSqlStatements();
        for (Map.Entry<SQLiteClosable, Object> entry : this.mPrograms.entrySet()) {
            SQLiteClosable program = entry.getKey();
            if (program == null) continue;
            program.onAllReferencesReleasedFromContainer();
        }
    }

    private native void dbclose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            prog = new SQLiteStatement(this, "PRAGMA user_version;");
            long version = prog.simpleQueryForLong();
            int n = (int)version;
            return n;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaximumSize() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            prog = new SQLiteStatement(this, "PRAGMA max_page_count;");
            long pageCount = prog.simpleQueryForLong();
            long l = pageCount * this.getPageSize();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMaximumSize(long numBytes) {
        SQLiteProgram prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            long pageSize = this.getPageSize();
            long numPages = numBytes / pageSize;
            if (numBytes % pageSize != 0L) {
                ++numPages;
            }
            prog = new SQLiteStatement(this, "PRAGMA max_page_count = " + numPages);
            long newPageCount = ((SQLiteStatement)prog).simpleQueryForLong();
            long l = newPageCount * pageSize;
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPageSize() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            long size;
            prog = new SQLiteStatement(this, "PRAGMA page_size;");
            long l = size = prog.simpleQueryForLong();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    public void markTableSyncable(String table, String deletedTable) {
        this.markTableSyncable(table, "_id", table, deletedTable);
    }

    public void markTableSyncable(String table, String foreignKey, String updateTable) {
        this.markTableSyncable(table, foreignKey, updateTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markTableSyncable(String table, String foreignKey, String updateTable, String deletedTable) {
        this.lock();
        try {
            this.native_execSQL("SELECT _sync_dirty FROM " + updateTable + " LIMIT 0");
            this.native_execSQL("SELECT " + foreignKey + " FROM " + table + " LIMIT 0");
        }
        finally {
            this.unlock();
        }
        SyncUpdateInfo info = new SyncUpdateInfo(updateTable, deletedTable, foreignKey);
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            this.mSyncUpdateInfo.put(table, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowUpdated(String table, long rowId) {
        SyncUpdateInfo info;
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            info = this.mSyncUpdateInfo.get(table);
        }
        if (info != null) {
            this.execSQL("UPDATE " + info.masterTable + " SET _sync_dirty=1 WHERE _id=(SELECT " + info.foreignKey + " FROM " + table + " WHERE _id=" + rowId + ")");
        }
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql);
            return sQLiteStatement;
        }
        finally {
            this.unlock();
        }
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table));
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        Cursor cursor;
        block8: {
            long duration2;
            int count2;
            SQLiteDirectCursorDriver driver;
            long timeStart;
            block9: {
                if (!this.isOpen()) {
                    throw new IllegalStateException("database not open");
                }
                BlockGuard.getThreadPolicy().onReadFromDisk();
                timeStart = 0L;
                if (this.mSlowQueryThreshold != -1) {
                    timeStart = System.currentTimeMillis();
                }
                driver = new SQLiteDirectCursorDriver(this, sql, editTable);
                cursor = null;
                try {
                    cursor = driver.query(cursorFactory != null ? cursorFactory : this.mFactory, selectionArgs);
                    Object var10_8 = null;
                    if (this.mSlowQueryThreshold == -1) break block8;
                    count2 = -1;
                    if (cursor == null) break block9;
                    count2 = cursor.getCount();
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (this.mSlowQueryThreshold != -1) {
                        long duration2;
                        int count2 = -1;
                        if (cursor != null) {
                            count2 = cursor.getCount();
                        }
                        if ((duration2 = System.currentTimeMillis() - timeStart) >= (long)this.mSlowQueryThreshold) {
                            Log.v("Cursor", "query (" + duration2 + " ms): " + ((Object)driver).toString() + ", args are " + (selectionArgs != null ? TextUtils.join((CharSequence)",", selectionArgs) : "<null>") + ", count is " + count2);
                        }
                    }
                    throw throwable;
                }
            }
            if ((duration2 = System.currentTimeMillis() - timeStart) >= (long)this.mSlowQueryThreshold) {
                Log.v("Cursor", "query (" + duration2 + " ms): " + ((Object)driver).toString() + ", args are " + (selectionArgs != null ? TextUtils.join((CharSequence)",", selectionArgs) : "<null>") + ", count is " + count2);
            }
        }
        return cursor;
    }

    public Cursor rawQuery(String sql, String[] selectionArgs, int initialRead, int maxRead) {
        SQLiteCursor c = (SQLiteCursor)this.rawQueryWithFactory(null, sql, selectionArgs, null);
        c.setLoadStyle(initialRead, maxRead);
        return c;
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + values, e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting " + initialValues, e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        long l;
        block15: {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            StringBuilder sql = new StringBuilder(152);
            sql.append("INSERT");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(" INTO ");
            sql.append(table);
            StringBuilder values = new StringBuilder(40);
            Set<Map.Entry<String, Object>> entrySet = null;
            if (initialValues != null && initialValues.size() > 0) {
                entrySet = initialValues.valueSet();
                Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
                sql.append('(');
                boolean needSeparator = false;
                while (entriesIter.hasNext()) {
                    if (needSeparator) {
                        sql.append(", ");
                        values.append(", ");
                    }
                    needSeparator = true;
                    Map.Entry<String, Object> entry = entriesIter.next();
                    sql.append(entry.getKey());
                    values.append('?');
                }
                sql.append(')');
            } else {
                sql.append("(" + nullColumnHack + ") ");
                values.append("NULL");
            }
            sql.append(" VALUES(");
            sql.append((CharSequence)values);
            sql.append(");");
            this.lock();
            SQLiteStatement statement = null;
            try {
                statement = this.compileStatement(sql.toString());
                if (entrySet != null) {
                    int size = entrySet.size();
                    Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
                    for (int i = 0; i < size; ++i) {
                        Map.Entry<String, Object> entry = entriesIter.next();
                        DatabaseUtils.bindObjectToProgram(statement, i + 1, entry.getValue());
                    }
                }
                statement.execute();
                long insertedRowId = this.lastInsertRow();
                if (insertedRowId == -1L) {
                    Log.e(TAG, "Error inserting " + initialValues + " using " + sql);
                } else if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Inserting row " + insertedRowId + " from " + initialValues + " using " + sql);
                }
                l = insertedRowId;
                Object var14_16 = null;
                if (statement == null) break block15;
            }
            catch (SQLiteDatabaseCorruptException e) {
                try {
                    this.onCorruption();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    this.unlock();
                    throw throwable;
                }
            }
            statement.close();
        }
        this.unlock();
        return l;
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        int numArgs;
        block8: {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            SQLiteProgram statement = null;
            try {
                statement = this.compileStatement("DELETE FROM " + table + (!TextUtils.isEmpty(whereClause) ? " WHERE " + whereClause : ""));
                if (whereArgs != null) {
                    numArgs = whereArgs.length;
                    for (int i = 0; i < numArgs; ++i) {
                        DatabaseUtils.bindObjectToProgram(statement, i + 1, whereArgs[i]);
                    }
                }
                ((SQLiteStatement)statement).execute();
                numArgs = this.lastChangeCount();
                Object var8_8 = null;
                if (statement == null) break block8;
            }
            catch (SQLiteDatabaseCorruptException e) {
                try {
                    this.onCorruption();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    this.unlock();
                    throw throwable;
                }
            }
            statement.close();
        }
        this.unlock();
        return numArgs;
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        int n;
        block15: {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            if (values == null) throw new IllegalArgumentException("Empty values");
            if (values.size() == 0) {
                throw new IllegalArgumentException("Empty values");
            }
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            Set<Map.Entry<String, Object>> entrySet = values.valueSet();
            Iterator<Map.Entry<String, Object>> entriesIter = entrySet.iterator();
            while (entriesIter.hasNext()) {
                Map.Entry<String, Object> entry = entriesIter.next();
                sql.append(entry.getKey());
                sql.append("=?");
                if (!entriesIter.hasNext()) continue;
                sql.append(", ");
            }
            if (!TextUtils.isEmpty(whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            SQLiteStatement statement = null;
            try {
                try {
                    int i;
                    statement = this.compileStatement(sql.toString());
                    int size = entrySet.size();
                    entriesIter = entrySet.iterator();
                    int bindArg = 1;
                    for (i = 0; i < size; ++bindArg, ++i) {
                        Map.Entry<String, Object> entry = entriesIter.next();
                        DatabaseUtils.bindObjectToProgram(statement, bindArg, entry.getValue());
                    }
                    if (whereArgs != null) {
                        size = whereArgs.length;
                        for (i = 0; i < size; ++bindArg, ++i) {
                            statement.bindString(bindArg, whereArgs[i]);
                        }
                    }
                    statement.execute();
                    int numChangedRows = this.lastChangeCount();
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "Updated " + numChangedRows + " using " + values + " and " + sql);
                    }
                    n = numChangedRows;
                    Object var15_17 = null;
                    if (statement == null) break block15;
                }
                catch (SQLiteDatabaseCorruptException e) {
                    this.onCorruption();
                    throw e;
                }
                catch (SQLException e) {
                    Log.e(TAG, "Error updating " + values + " using " + sql);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (statement != null) {
                    statement.close();
                }
                this.unlock();
                throw throwable;
            }
            statement.close();
        }
        this.unlock();
        return n;
    }

    public void execSQL(String sql) throws SQLException {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        long timeStart = SystemClock.uptimeMillis();
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        this.logTimeStat(this.mLastSqlStatement, timeStart, GET_LOCK_LOG_PREFIX);
        try {
            try {
                this.native_execSQL(sql);
            }
            catch (SQLiteDatabaseCorruptException e) {
                this.onCorruption();
                throw e;
            }
            Object var6_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.unlock();
            throw throwable;
        }
        if (sql == COMMIT_SQL) {
            this.logTimeStat(this.mLastSqlStatement, timeStart, COMMIT_SQL);
        } else {
            this.logTimeStat(sql, timeStart, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        long timeStart;
        block9: {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            if (bindArgs == null) {
                throw new IllegalArgumentException("Empty bindArgs");
            }
            timeStart = SystemClock.uptimeMillis();
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            SQLiteStatement statement = null;
            try {
                try {
                    statement = this.compileStatement(sql);
                    if (bindArgs != null) {
                        int numArgs = bindArgs.length;
                        for (int i = 0; i < numArgs; ++i) {
                            DatabaseUtils.bindObjectToProgram(statement, i + 1, bindArgs[i]);
                        }
                    }
                    statement.execute();
                }
                catch (SQLiteDatabaseCorruptException e) {
                    this.onCorruption();
                    throw e;
                }
                Object var9_8 = null;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (statement != null) {
                    statement.close();
                }
                this.unlock();
                throw throwable;
            }
            statement.close();
        }
        this.unlock();
        this.logTimeStat(sql, timeStart);
    }

    protected void finalize() {
        if (this.isOpen()) {
            Log.e(TAG, "close() was never explicitly called on database '" + this.mPath + "' ", this.mStackTrace);
            this.closeClosable();
            this.onAllReferencesReleased();
        }
    }

    private SQLiteDatabase(String path, CursorFactory factory, int flags) {
        if (path == null) {
            throw new IllegalArgumentException("path should not be null");
        }
        this.mFlags = flags;
        this.mPath = path;
        this.mSlowQueryThreshold = SystemProperties.getInt(LOG_SLOW_QUERIES_PROPERTY, -1);
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mFactory = factory;
        this.dbopen(this.mPath, this.mFlags);
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            this.mTimeOpened = this.getTime();
        }
        this.mPrograms = new WeakHashMap();
        try {
            this.setLocale(Locale.getDefault());
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Failed to setLocale() when constructing, closing the database", e);
            this.dbclose();
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                this.mTimeClosed = this.getTime();
            }
            throw e;
        }
    }

    private String getTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ").format(System.currentTimeMillis());
    }

    public boolean isReadOnly() {
        return (this.mFlags & 1) == 1;
    }

    public boolean isOpen() {
        return this.mNativeHandle != 0;
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    public final String getPath() {
        return this.mPath;
    }

    void logTimeStat(String sql, long beginMillis) {
        this.logTimeStat(sql, beginMillis, null);
    }

    void logTimeStat(String sql, long beginMillis, String prefix) {
        String blockingPackage;
        int samplePercent;
        this.mLastSqlStatement = sql;
        long durationMillis = SystemClock.uptimeMillis() - beginMillis;
        if (durationMillis == 0L && prefix == GET_LOCK_LOG_PREFIX) {
            return;
        }
        if (sQueryLogTimeInMillis == 0) {
            sQueryLogTimeInMillis = SystemProperties.getInt("db.db_operation.threshold_ms", 500);
        }
        if (durationMillis >= (long)sQueryLogTimeInMillis) {
            samplePercent = 100;
        } else {
            samplePercent = (int)(100L * durationMillis / (long)sQueryLogTimeInMillis) + 1;
            if (this.mRandom.nextInt(100) >= samplePercent) {
                return;
            }
        }
        if (prefix != null) {
            sql = prefix + sql;
        }
        if (sql.length() > 64) {
            sql = sql.substring(0, 64);
        }
        if ((blockingPackage = AppGlobals.getInitialPackage()) == null) {
            blockingPackage = "";
        }
        EventLog.writeEvent(52000, this.getPathForLogs(), sql, durationMillis, blockingPackage, samplePercent);
    }

    private String getPathForLogs() {
        if (this.mPathForLogs != null) {
            return this.mPathForLogs;
        }
        if (this.mPath == null) {
            return null;
        }
        this.mPathForLogs = this.mPath.indexOf(64) == -1 ? this.mPath : EMAIL_IN_DB_PATTERN.matcher(this.mPath).replaceAll("XX@YY");
        return this.mPathForLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        this.lock();
        try {
            this.native_setLocale(locale.toString(), this.mFlags);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCompiledQueries(String sql, SQLiteCompiledSql compiledStatement) {
        if (this.mMaxSqlCacheSize == 0) {
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                Log.v(TAG, "|NOT adding_sql_to_cache|" + this.getPath() + "|" + sql);
            }
            return;
        }
        SQLiteCompiledSql compiledSql = null;
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            compiledSql = this.mCompiledQueries.get(sql);
            if (compiledSql != null) {
                return;
            }
            if (this.mCompiledQueries.size() == this.mMaxSqlCacheSize) {
                if (++this.mCacheFullWarnings == 1) {
                    Log.w(TAG, "Reached MAX size for compiled-sql statement cache for database " + this.getPath() + "; i.e., NO space for this sql statement in cache: " + sql + ". Please change your sql statements to use '?' for " + "bindargs, instead of using actual values");
                }
            } else {
                this.mCompiledQueries.put(sql, compiledStatement);
                if (SQLiteDebug.DEBUG_SQL_CACHE) {
                    Log.v(TAG, "|adding_sql_to_cache|" + this.getPath() + "|" + this.mCompiledQueries.size() + "|" + sql);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocCachedSqlStatements() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            for (SQLiteCompiledSql compiledSql : this.mCompiledQueries.values()) {
                compiledSql.releaseSqlStatement();
            }
            this.mCompiledQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLiteCompiledSql getCompiledStatementForSql(String sql) {
        boolean cacheHit;
        SQLiteCompiledSql compiledStatement = null;
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            if (this.mMaxSqlCacheSize == 0) {
                if (SQLiteDebug.DEBUG_SQL_CACHE) {
                    Log.v(TAG, "|cache NOT found|" + this.getPath());
                }
                return null;
            }
            compiledStatement = this.mCompiledQueries.get(sql);
            cacheHit = compiledStatement != null;
        }
        if (cacheHit) {
            ++this.mNumCacheHits;
        } else {
            ++this.mNumCacheMisses;
        }
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            Log.v(TAG, "|cache_stats|" + this.getPath() + "|" + this.mCompiledQueries.size() + "|" + this.mNumCacheHits + "|" + this.mNumCacheMisses + "|" + cacheHit + "|" + this.mTimeOpened + "|" + this.mTimeClosed + "|" + sql);
        }
        return compiledStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCompiledSqlCache(String sql) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            return this.mCompiledQueries.containsKey(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeFromCompiledSqlCache(String sql) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            this.mCompiledQueries.remove(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCompiledSqlCache() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            this.mCompiledQueries.clear();
        }
    }

    public synchronized int getMaxSqlCacheSize() {
        return this.mMaxSqlCacheSize;
    }

    public synchronized void setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 250 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 250");
        }
        if (cacheSize < this.mMaxSqlCacheSize) {
            throw new IllegalStateException("cannot set cacheSize to a value less than the value set with previous setMaxSqlCacheSize() call.");
        }
        this.mMaxSqlCacheSize = cacheSize;
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (WeakReference w : ActiveDatabases.getInstance().mActiveDatabases) {
            String path;
            SQLiteDatabase db = (SQLiteDatabase)w.get();
            if (db == null || !db.isOpen()) continue;
            int lookasideUsed = db.native_getDbLookaside();
            int indx = (path = db.getPath()).lastIndexOf("/");
            String lastnode = path.substring(indx != -1 ? ++indx : 0);
            ArrayList<Pair<String, String>> attachedDbs = SQLiteDatabase.getAttachedDbs(db);
            if (attachedDbs == null) continue;
            for (int i = 0; i < attachedDbs.size(); ++i) {
                String dbName;
                Pair<String, String> p = attachedDbs.get(i);
                long pageCount = SQLiteDatabase.getPragmaVal(db, (String)p.first + ".page_count;");
                if (i == 0) {
                    dbName = lastnode;
                } else {
                    lookasideUsed = 0;
                    dbName = "  (attached) " + (String)p.first;
                    if (((String)p.second).trim().length() > 0) {
                        int idx = ((String)p.second).lastIndexOf("/");
                        dbName = dbName + " : " + ((String)p.second).substring(idx != -1 ? ++idx : 0);
                    }
                }
                if (pageCount <= 0L) continue;
                dbStatsList.add(new SQLiteDebug.DbStats(dbName, pageCount, db.getPageSize(), lookasideUsed));
            }
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPragmaVal(SQLiteDatabase db, String pragma) {
        long l;
        block3: {
            if (!db.isOpen()) {
                return 0L;
            }
            SQLiteProgram prog = null;
            try {
                long val;
                prog = new SQLiteStatement(db, "PRAGMA " + pragma);
                l = val = ((SQLiteStatement)prog).simpleQueryForLong();
                Object var8_5 = null;
                if (prog == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_6 = null;
                    if (prog == null) break block4;
                    prog.close();
                }
                throw throwable;
            }
            prog.close();
        }
        return l;
    }

    private static ArrayList<Pair<String, String>> getAttachedDbs(SQLiteDatabase dbObj) {
        if (!dbObj.isOpen()) {
            return null;
        }
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Cursor c = dbObj.rawQuery("pragma database_list;", null);
        while (c.moveToNext()) {
            attachedDbs.add(new Pair<String, String>(c.getString(1), c.getString(2)));
        }
        c.close();
        return attachedDbs;
    }

    private native void dbopen(String var1, int var2);

    private native void enableSqlTracing(String var1);

    private native void enableSqlProfiling(String var1);

    native void native_execSQL(String var1) throws SQLException;

    native void native_setLocale(String var1, int var2);

    native long lastInsertRow();

    native int lastChangeCount();

    private native int native_getDbLookaside();

    static class ActiveDatabases {
        private static final ActiveDatabases activeDatabases = new ActiveDatabases();
        private HashSet<WeakReference<SQLiteDatabase>> mActiveDatabases = new HashSet();

        private ActiveDatabases() {
        }

        static ActiveDatabases getInstance() {
            return activeDatabases;
        }
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    private static class SyncUpdateInfo {
        String masterTable;
        String deletedTable;
        String foreignKey;

        SyncUpdateInfo(String masterTable, String deletedTable, String foreignKey) {
            this.masterTable = masterTable;
            this.deletedTable = deletedTable;
            this.foreignKey = foreignKey;
        }
    }
}

