/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.MemoryFile;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SQLiteContentHelper {
    public static AssetFileDescriptor getBlobColumnAsAssetFile(SQLiteDatabase db, String sql, String[] selectionArgs) throws FileNotFoundException {
        try {
            MemoryFile file = SQLiteContentHelper.simpleQueryForBlobMemoryFile(db, sql, selectionArgs);
            if (file == null) {
                throw new FileNotFoundException("No results.");
            }
            return AssetFileDescriptor.fromMemoryFile(file);
        }
        catch (IOException ex) {
            throw new FileNotFoundException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MemoryFile simpleQueryForBlobMemoryFile(SQLiteDatabase db, String sql, String[] selectionArgs) throws IOException {
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        if (cursor == null) {
            return null;
        }
        try {
            if (!cursor.moveToFirst()) {
                MemoryFile memoryFile = null;
                return memoryFile;
            }
            byte[] bytes = cursor.getBlob(0);
            if (bytes == null) {
                MemoryFile memoryFile = null;
                return memoryFile;
            }
            MemoryFile file = new MemoryFile(null, bytes.length);
            file.writeBytes(bytes, 0, 0, bytes.length);
            file.deactivate();
            MemoryFile memoryFile = file;
            return memoryFile;
        }
        finally {
            cursor.close();
        }
    }
}

