/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CharArrayBuffer;
import android.database.CursorWindow;
import android.database.StaleDataException;
import java.util.HashMap;

public abstract class AbstractWindowedCursor
extends AbstractCursor {
    protected CursorWindow mWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                return (byte[])this.getUpdatedField(columnIndex);
            }
        }
        return this.mWindow.getBlob(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                return (String)this.getUpdatedField(columnIndex);
            }
        }
        return this.mWindow.getString(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                super.copyStringToBuffer(columnIndex, buffer);
            }
        }
        this.mWindow.copyStringToBuffer(this.mPos, columnIndex, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                Number value = (Number)this.getUpdatedField(columnIndex);
                return value.shortValue();
            }
        }
        return this.mWindow.getShort(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                Number value = (Number)this.getUpdatedField(columnIndex);
                return value.intValue();
            }
        }
        return this.mWindow.getInt(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                Number value = (Number)this.getUpdatedField(columnIndex);
                return value.longValue();
            }
        }
        return this.mWindow.getLong(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                Number value = (Number)this.getUpdatedField(columnIndex);
                return value.floatValue();
            }
        }
        return this.mWindow.getFloat(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                Number value = (Number)this.getUpdatedField(columnIndex);
                return value.doubleValue();
            }
        }
        return this.mWindow.getDouble(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                return this.getUpdatedField(columnIndex) == null;
            }
        }
        return this.mWindow.isNull(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlob(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                Object object = this.getUpdatedField(columnIndex);
                return object == null || object instanceof byte[];
            }
        }
        return this.mWindow.isBlob(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isString(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                Object object = this.getUpdatedField(columnIndex);
                return object == null || object instanceof String;
            }
        }
        return this.mWindow.isString(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLong(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                Object object = this.getUpdatedField(columnIndex);
                return object != null && (object instanceof Integer || object instanceof Long);
            }
        }
        return this.mWindow.isLong(this.mPos, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFloat(int columnIndex) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(columnIndex)) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                Object object = this.getUpdatedField(columnIndex);
                return object != null && (object instanceof Float || object instanceof Double);
            }
        }
        return this.mWindow.isFloat(this.mPos, columnIndex);
    }

    protected void checkPosition() {
        super.checkPosition();
        if (this.mWindow == null) {
            throw new StaleDataException("Access closed cursor");
        }
    }

    public CursorWindow getWindow() {
        return this.mWindow;
    }

    public void setWindow(CursorWindow window) {
        if (this.mWindow != null) {
            this.mWindow.close();
        }
        this.mWindow = window;
    }

    public boolean hasWindow() {
        return this.mWindow != null;
    }
}

