/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.TypedValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public final class AssetManager {
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV = false;
    private static final boolean DEBUG_REFS = false;
    private static final Object sSync = new Object();
    private static AssetManager sSystem = null;
    private final TypedValue mValue = new TypedValue();
    private final long[] mOffsets = new long[2];
    private int mObject;
    private int mNObject;
    private StringBlock[] mStringBlocks = null;
    private int mNumRefs = 1;
    private boolean mOpen = true;
    private HashMap<Integer, RuntimeException> mRefStacks;
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DENSITY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetManager() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.init();
            AssetManager.ensureSystemAssets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager system = new AssetManager(true);
                system.makeStringBlocks(false);
                sSystem = system;
            }
        }
    }

    private AssetManager(boolean isSystem) {
        this.init();
    }

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CharSequence getResourceText(int ident) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceValue(ident, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CharSequence getResourceBagText(int ident, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceBagValue(ident, bagEntryId, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    final String[] getResourceStringArray(int id2) {
        String[] retArray = this.getArrayStringResource(id2);
        return retArray;
    }

    final boolean getResourceValue(int ident, TypedValue outValue, boolean resolveRefs) {
        int block = this.loadResourceValue(ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            outValue.string = this.mStringBlocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    final CharSequence[] getResourceTextArray(int id2) {
        int[] rawInfoArray = this.getArrayStringInfo(id2);
        int rawInfoArrayLen = rawInfoArray.length;
        int infoArrayLen = rawInfoArrayLen / 2;
        CharSequence[] retArray = new CharSequence[infoArrayLen];
        int i = 0;
        int j = 0;
        while (i < rawInfoArrayLen) {
            int block = rawInfoArray[i];
            int index = rawInfoArray[i + 1];
            retArray[j] = index >= 0 ? this.mStringBlocks[block].get(index) : null;
            i += 2;
            ++j;
        }
        return retArray;
    }

    final boolean getThemeValue(int theme, int ident, TypedValue outValue, boolean resolveRefs) {
        int block = AssetManager.loadThemeAttributeValue(theme, ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            StringBlock[] blocks = this.mStringBlocks;
            if (blocks == null) {
                this.ensureStringBlocks();
            }
            outValue.string = blocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureStringBlocks() {
        if (this.mStringBlocks == null) {
            AssetManager assetManager = this;
            synchronized (assetManager) {
                if (this.mStringBlocks == null) {
                    this.makeStringBlocks(true);
                }
            }
        }
    }

    private final void makeStringBlocks(boolean copyFromSystem) {
        int sysNum = copyFromSystem ? AssetManager.sSystem.mStringBlocks.length : 0;
        int num = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[num];
        for (int i = 0; i < num; ++i) {
            this.mStringBlocks[i] = i < sysNum ? AssetManager.sSystem.mStringBlocks[i] : new StringBlock(this.getNativeStringBlock(i), true);
        }
    }

    final CharSequence getPooledString(int block, int id2) {
        return this.mStringBlocks[block - 1].get(id2);
    }

    public final InputStream open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream open(String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int asset = this.openAsset(fileName, accessMode);
            if (asset != 0) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AssetFileDescriptor openFd(String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openAssetFd(fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    public final native String[] list(String var1) throws IOException;

    public final InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    public final InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    public final InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int asset = this.openNonAssetNative(cookie, fileName, accessMode);
            if (asset != 0) {
                AssetInputStream res = new AssetInputStream(asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public final AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openNonAssetFdNative(cookie, fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public final XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock block = this.openXmlBlockAsset(cookie, fileName);
        XmlResourceParser rp = block.newParser();
        block.close();
        return rp;
    }

    final XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int xmlBlock = this.openXmlAssetNative(cookie, fileName);
            if (xmlBlock != 0) {
                XmlBlock res = new XmlBlock(this, xmlBlock);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset XML file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int res = this.newTheme();
            this.incRefsLocked(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseTheme(int theme) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.deleteTheme(theme);
            this.decRefsLocked(theme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public final native int addAssetPath(String var1);

    public final int[] addAssetPaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        int[] cookies = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            cookies[i] = this.addAssetPath(paths[i]);
        }
        return cookies;
    }

    public final native boolean isUpToDate();

    public final native void setLocale(String var1);

    public final native String[] getLocales();

    public final native void setConfiguration(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    final native int getResourceIdentifier(String var1, String var2, String var3);

    final native String getResourceName(int var1);

    final native String getResourcePackageName(int var1);

    final native String getResourceTypeName(int var1);

    final native String getResourceEntryName(int var1);

    private final native int openAsset(String var1, int var2);

    private final native ParcelFileDescriptor openAssetFd(String var1, long[] var2) throws IOException;

    private final native int openNonAssetNative(int var1, String var2, int var3);

    private native ParcelFileDescriptor openNonAssetFdNative(int var1, String var2, long[] var3) throws IOException;

    private final native void destroyAsset(int var1);

    private final native int readAssetChar(int var1);

    private final native int readAsset(int var1, byte[] var2, int var3, int var4);

    private final native long seekAsset(int var1, long var2, int var4);

    private final native long getAssetLength(int var1);

    private final native long getAssetRemainingLength(int var1);

    private final native int loadResourceValue(int var1, TypedValue var2, boolean var3);

    private final native int loadResourceBagValue(int var1, int var2, TypedValue var3, boolean var4);

    static final native boolean applyStyle(int var0, int var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

    final native boolean retrieveAttributes(int var1, int[] var2, int[] var3, int[] var4);

    final native int getArraySize(int var1);

    final native int retrieveArray(int var1, int[] var2);

    private final native int getStringBlockCount();

    private final native int getNativeStringBlock(int var1);

    public final native String getCookieName(int var1);

    public static final native int getGlobalAssetCount();

    public static final native String getAssetAllocations();

    public static final native int getGlobalAssetManagerCount();

    private final native int newTheme();

    private final native void deleteTheme(int var1);

    static final native void applyThemeStyle(int var0, int var1, boolean var2);

    static final native void copyTheme(int var0, int var1);

    static final native int loadThemeAttributeValue(int var0, int var1, TypedValue var2, boolean var3);

    static final native void dumpTheme(int var0, int var1, String var2, String var3);

    private final native int openXmlAssetNative(int var1, String var2);

    private final native String[] getArrayStringResource(int var1);

    private final native int[] getArrayStringInfo(int var1);

    final native int[] getArrayIntResource(int var1);

    private final native void init();

    private final native void destroy();

    private final void incRefsLocked(int id2) {
        ++this.mNumRefs;
    }

    private final void decRefsLocked(int id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    public final class AssetInputStream
    extends InputStream {
        private int mAsset;
        private long mLength;
        private long mMarkPos;

        public final int getAssetInt() {
            return this.mAsset;
        }

        private AssetInputStream(int asset) {
            this.mAsset = asset;
            this.mLength = AssetManager.this.getAssetLength(asset);
        }

        public final int read() throws IOException {
            return AssetManager.this.readAssetChar(this.mAsset);
        }

        public final boolean markSupported() {
            return true;
        }

        public final int available() throws IOException {
            long len = AssetManager.this.getAssetRemainingLength(this.mAsset);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0) {
                    AssetManager.this.destroyAsset(this.mAsset);
                    this.mAsset = 0;
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        public final void mark(int readlimit) {
            this.mMarkPos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
        }

        public final void reset() throws IOException {
            AssetManager.this.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        public final int read(byte[] b) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, 0, b.length);
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, off, len);
        }

        public final long skip(long n) throws IOException {
            long pos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.this.seekAsset(this.mAsset, n, 0);
            }
            return n;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

