/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncInfo;
import android.content.SyncOperation;
import android.content.SyncQueue;
import android.content.SyncResult;
import android.content.SyncStatusInfo;
import android.content.SyncStorageEngine;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ArrayUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;

public class SyncManager
implements OnAccountsUpdateListener {
    private static final String TAG = "SyncManager";
    private static final long LOCAL_SYNC_DELAY;
    private static final long MAX_TIME_PER_SYNC;
    private static final long SYNC_NOTIFICATION_DELAY = 30000L;
    private static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    private static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    private static final int DELAY_RETRY_SYNC_IN_PROGRESS_IN_SECONDS = 10;
    private static final long ERROR_NOTIFICATION_DELAY_MS = 600000L;
    private static final int INITIALIZATION_UNBIND_DELAY_MS = 5000;
    private static final String SYNC_WAKE_LOCK = "*sync*";
    private static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarm";
    private Context mContext;
    private volatile Account[] mAccounts = INITIAL_ACCOUNTS_ARRAY;
    private volatile PowerManager.WakeLock mSyncWakeLock;
    private volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    private volatile boolean mDataConnectionIsConnected = false;
    private volatile boolean mStorageIsLow = false;
    private final NotificationManager mNotificationMgr;
    private AlarmManager mAlarmService = null;
    private final SyncStorageEngine mSyncStorageEngine;
    public final SyncQueue mSyncQueue;
    private ActiveSyncContext mActiveSyncContext = null;
    private boolean mNeedSyncErrorNotification = false;
    private boolean mNeedSyncActiveNotification = false;
    private final PendingIntent mSyncAlarmIntent;
    private ConnectivityManager mConnManagerDoNotUseDirectly;
    private final SyncAdaptersCache mSyncAdapters;
    private BroadcastReceiver mStorageIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is low.");
                }
                SyncManager.this.mStorageIsLow = true;
                SyncManager.this.cancelActiveSync(null, null);
            } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is ok.");
                }
                SyncManager.this.mStorageIsLow = false;
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    private BroadcastReceiver mBootCompletedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mSyncHandler.onBootCompleted();
        }
    };
    private BroadcastReceiver mBackgroundDataSettingChanged = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (SyncManager.this.getConnectivityManager().getBackgroundDataSetting()) {
                SyncManager.this.scheduleSync(null, null, new Bundle(), 0L, false);
            }
        }
    };
    private static final Account[] INITIAL_ACCOUNTS_ARRAY;
    private BroadcastReceiver mConnectivityIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkInfo.State state;
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkInfo.State state2 = state = networkInfo == null ? NetworkInfo.State.UNKNOWN : networkInfo.getState();
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "received connectivity action.  network info: " + networkInfo);
            }
            boolean wasConnected = SyncManager.this.mDataConnectionIsConnected;
            switch (state) {
                case CONNECTED: {
                    SyncManager.this.mDataConnectionIsConnected = true;
                    break;
                }
                case DISCONNECTED: {
                    if (intent.getBooleanExtra("noConnectivity", false)) {
                        SyncManager.this.mDataConnectionIsConnected = false;
                        break;
                    }
                    SyncManager.this.mDataConnectionIsConnected = true;
                    break;
                }
            }
            if (SyncManager.this.mDataConnectionIsConnected) {
                if (!wasConnected) {
                    if (Log.isLoggable(SyncManager.TAG, 2)) {
                        Log.v(SyncManager.TAG, "Reconnection detected: clearing all backoffs");
                    }
                    SyncManager.this.mSyncStorageEngine.clearAllBackoffs();
                }
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    private BroadcastReceiver mShutdownIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.w(SyncManager.TAG, "Writing sync state before shutdown...");
            SyncManager.this.getSyncStorageEngine().writeAllState();
        }
    };
    private static final String ACTION_SYNC_ALARM = "android.content.syncmanager.SYNC_ALARM";
    private final SyncHandler mSyncHandler;
    private final Handler mMainHandler;
    private volatile boolean mBootCompleted = false;

    public void onAccountsUpdated(Account[] accounts) {
        boolean justBootedUp = this.mAccounts == INITIAL_ACCOUNTS_ARRAY;
        this.mAccounts = accounts;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext != null && !ArrayUtils.contains(accounts, activeSyncContext.mSyncOperation.account)) {
            Log.d(TAG, "canceling sync since the account has been removed");
            this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
        }
        this.sendCheckAlarmsMessage();
        if (this.mBootCompleted) {
            this.mSyncStorageEngine.doDatabaseCleanup(accounts);
        }
        if (accounts.length > 0) {
            boolean onlyThoseWithUnkownSyncableState = justBootedUp;
            this.scheduleSync(null, null, null, 0L, onlyThoseWithUnkownSyncableState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectivityManager getConnectivityManager() {
        SyncManager syncManager = this;
        synchronized (syncManager) {
            if (this.mConnManagerDoNotUseDirectly == null) {
                this.mConnManagerDoNotUseDirectly = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            }
            return this.mConnManagerDoNotUseDirectly;
        }
    }

    public SyncManager(Context context, boolean factoryTest) {
        SyncStorageEngine.init(context);
        this.mSyncStorageEngine = SyncStorageEngine.getSingleton();
        this.mSyncQueue = new SyncQueue(this.mSyncStorageEngine);
        this.mContext = context;
        HandlerThread syncThread = new HandlerThread("SyncHandlerThread", 10);
        syncThread.start();
        this.mSyncHandler = new SyncHandler(syncThread.getLooper());
        this.mMainHandler = new Handler(this.mContext.getMainLooper());
        this.mSyncAdapters = new SyncAdaptersCache(this.mContext);
        this.mSyncAdapters.setListener(new RegisteredServicesCacheListener<SyncAdapterType>(){

            @Override
            public void onServiceChanged(SyncAdapterType type, boolean removed) {
                if (!removed) {
                    SyncManager.this.scheduleSync(null, type.authority, null, 0L, false);
                }
            }
        }, this.mSyncHandler);
        this.mSyncAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_SYNC_ALARM), 0);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.mConnectivityIntentReceiver, intentFilter);
        if (!factoryTest) {
            intentFilter = new IntentFilter("android.intent.action.BOOT_COMPLETED");
            context.registerReceiver(this.mBootCompletedReceiver, intentFilter);
        }
        intentFilter = new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
        context.registerReceiver(this.mBackgroundDataSettingChanged, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        context.registerReceiver(this.mStorageIntentReceiver, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.setPriority(100);
        context.registerReceiver(this.mShutdownIntentReceiver, intentFilter);
        if (!factoryTest) {
            this.mNotificationMgr = (NotificationManager)context.getSystemService("notification");
            context.registerReceiver(new SyncAlarmIntentReceiver(), new IntentFilter(ACTION_SYNC_ALARM));
        } else {
            this.mNotificationMgr = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mSyncWakeLock = pm.newWakeLock(1, SYNC_WAKE_LOCK);
        this.mSyncWakeLock.setReferenceCounted(false);
        this.mHandleAlarmWakeLock = pm.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        this.mSyncStorageEngine.addStatusChangeListener(1, new ISyncStatusObserver.Stub(){

            public void onStatusChanged(int which) {
                SyncManager.this.sendCheckAlarmsMessage();
            }
        });
        if (!factoryTest) {
            AccountManager.get(this.mContext).addOnAccountsUpdatedListener(this, this.mSyncHandler, false);
            this.onAccountsUpdated(AccountManager.get(this.mContext).getAccounts());
        }
    }

    private long jitterize(long minValue, long maxValue) {
        Random random = new Random(SystemClock.elapsedRealtime());
        long spread = maxValue - minValue;
        if (spread > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        return minValue + (long)random.nextInt((int)spread);
    }

    public SyncStorageEngine getSyncStorageEngine() {
        return this.mSyncStorageEngine;
    }

    private void ensureAlarmService() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    private void initializeSyncAdapter(Account account, String authority) {
        SyncAdapterType syncAdapterType;
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "initializeSyncAdapter: " + account + ", authority " + authority);
        }
        if ((syncAdapterInfo = this.mSyncAdapters.getServiceInfo(syncAdapterType = SyncAdapterType.newKey(authority, account.type))) == null) {
            Log.w(TAG, "can't find a sync adapter for " + syncAdapterType + ", removing");
            this.mSyncStorageEngine.removeAuthority(account, authority);
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.content.SyncAdapter");
        intent.setComponent(syncAdapterInfo.componentName);
        if (!this.mContext.bindService(intent, new InitializerServiceConnection(account, authority, this.mContext, this.mMainHandler), 5)) {
            Log.w(TAG, "initializeSyncAdapter: failed to bind to " + intent);
        }
    }

    public void scheduleSync(Account requestedAccount, String requestedAuthority, Bundle extras, long delay, boolean onlyThoseWithUnkownSyncableState) {
        Account[] accounts;
        Boolean expedited;
        boolean backgroundDataUsageAllowed;
        boolean isLoggable = Log.isLoggable(TAG, 2);
        boolean bl = backgroundDataUsageAllowed = !this.mBootCompleted || this.getConnectivityManager().getBackgroundDataSetting();
        if (extras == null) {
            extras = new Bundle();
        }
        if ((expedited = Boolean.valueOf(extras.getBoolean("expedited", false))).booleanValue()) {
            delay = -1L;
        }
        if (requestedAccount != null) {
            accounts = new Account[]{requestedAccount};
        } else {
            accounts = this.mAccounts;
            if (accounts.length == 0) {
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: no accounts configured, dropping");
                }
                return;
            }
        }
        boolean uploadOnly = extras.getBoolean("upload", false);
        boolean manualSync = extras.getBoolean("force", false);
        if (manualSync) {
            extras.putBoolean("ignore_backoff", true);
            extras.putBoolean("ignore_settings", true);
        }
        boolean ignoreSettings = extras.getBoolean("ignore_settings", false);
        int source = uploadOnly ? 1 : (manualSync ? 3 : (requestedAuthority == null ? 2 : 0));
        HashSet<String> syncableAuthorities = new HashSet<String>();
        for (RegisteredServicesCache.ServiceInfo syncAdapter : this.mSyncAdapters.getAllServices()) {
            syncableAuthorities.add(((SyncAdapterType)syncAdapter.type).authority);
        }
        if (requestedAuthority != null) {
            boolean hasSyncAdapter = syncableAuthorities.contains(requestedAuthority);
            syncableAuthorities.clear();
            if (hasSyncAdapter) {
                syncableAuthorities.add(requestedAuthority);
            }
        }
        boolean masterSyncAutomatically = this.mSyncStorageEngine.getMasterSyncAutomatically();
        for (String authority : syncableAuthorities) {
            for (Account account : accounts) {
                boolean syncAllowed;
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo;
                int isSyncable = this.mSyncStorageEngine.getIsSyncable(account, authority);
                if (isSyncable == 0 || onlyThoseWithUnkownSyncableState && isSyncable >= 0 || (syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(authority, account.type))) == null || !((SyncAdapterType)syncAdapterInfo.type).supportsUploading() && uploadOnly) continue;
                boolean bl2 = syncAllowed = isSyncable < 0 || ignoreSettings || backgroundDataUsageAllowed && masterSyncAutomatically && this.mSyncStorageEngine.getSyncAutomatically(account, authority);
                if (!syncAllowed) {
                    if (!isLoggable) continue;
                    Log.d(TAG, "scheduleSync: sync of " + account + ", " + authority + " is not allowed, dropping request");
                    continue;
                }
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: delay " + delay + ", source " + source + ", account " + account + ", authority " + authority + ", extras " + extras);
                }
                this.scheduleSyncOperation(new SyncOperation(account, source, authority, extras, delay));
            }
        }
    }

    public void scheduleLocalSync(Account account, String authority) {
        Bundle extras = new Bundle();
        extras.putBoolean("upload", true);
        this.scheduleSync(account, authority, extras, LOCAL_SYNC_DELAY, false);
    }

    public SyncAdapterType[] getSyncAdapterTypes() {
        Collection serviceInfos = this.mSyncAdapters.getAllServices();
        SyncAdapterType[] types = new SyncAdapterType[serviceInfos.size()];
        int i = 0;
        for (RegisteredServicesCache.ServiceInfo serviceInfo : serviceInfos) {
            types[i] = (SyncAdapterType)serviceInfo.type;
            ++i;
        }
        return types;
    }

    private void sendSyncAlarmMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_ALARM");
        }
        this.mSyncHandler.sendEmptyMessage(2);
    }

    private void sendCheckAlarmsMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_CHECK_ALARMS");
        }
        this.mSyncHandler.sendEmptyMessage(3);
    }

    private void sendSyncFinishedOrCanceledMessage(ActiveSyncContext syncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 1;
        msg.obj = new SyncHandlerMessagePayload(syncContext, syncResult);
        this.mSyncHandler.sendMessage(msg);
    }

    private void clearBackoffSetting(SyncOperation op) {
        this.mSyncStorageEngine.setBackoff(op.account, op.authority, -1L, -1L);
    }

    private void increaseBackoffSetting(SyncOperation op) {
        long maxSyncRetryTimeInSeconds;
        long now = SystemClock.elapsedRealtime();
        Pair<Long, Long> previousSettings = this.mSyncStorageEngine.getBackoff(op.account, op.authority);
        long newDelayInMs = previousSettings == null || (Long)previousSettings.second <= 0L ? this.jitterize(30000L, 33000L) : (Long)previousSettings.second * 2L;
        if (newDelayInMs > (maxSyncRetryTimeInSeconds = Settings.Secure.getLong(this.mContext.getContentResolver(), "sync_max_retry_delay_in_seconds", 3600L)) * 1000L) {
            newDelayInMs = maxSyncRetryTimeInSeconds * 1000L;
        }
        this.mSyncStorageEngine.setBackoff(op.account, op.authority, now + newDelayInMs, newDelayInMs);
    }

    private void setDelayUntilTime(SyncOperation op, long delayUntilSeconds) {
        long delayUntil = delayUntilSeconds * 1000L;
        long absoluteNow = System.currentTimeMillis();
        long newDelayUntilTime = delayUntil > absoluteNow ? SystemClock.elapsedRealtime() + (delayUntil - absoluteNow) : 0L;
        this.mSyncStorageEngine.setDelayUntilTime(op.account, op.authority, newDelayUntilTime);
    }

    public void cancelActiveSync(Account account, String authority) {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext != null) {
            if (account != null && !account.equals(activeSyncContext.mSyncOperation.account)) {
                return;
            }
            if (authority != null && !authority.equals(activeSyncContext.mSyncOperation.authority)) {
                return;
            }
            this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSyncOperation(SyncOperation syncOperation) {
        boolean queueChanged;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (syncOperation.expedited && activeSyncContext != null) {
            boolean hasSameKey = activeSyncContext.mSyncOperation.key.equals(syncOperation.key);
            if (!activeSyncContext.mSyncOperation.expedited && !hasSameKey) {
                this.scheduleSyncOperation(new SyncOperation(activeSyncContext.mSyncOperation));
                this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
            }
        }
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            queueChanged = this.mSyncQueue.add(syncOperation);
        }
        if (queueChanged) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "scheduleSyncOperation: enqueued " + syncOperation);
            }
            this.sendCheckAlarmsMessage();
        } else if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "scheduleSyncOperation: dropping duplicate sync operation " + syncOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScheduledSyncOperations(Account account, String authority) {
        this.mSyncStorageEngine.setBackoff(account, authority, -1L, -1L);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.remove(account, authority);
        }
    }

    void maybeRescheduleSync(SyncResult syncResult, SyncOperation operation) {
        boolean isLoggable = Log.isLoggable(TAG, 3);
        if (isLoggable) {
            Log.d(TAG, "encountered error(s) during the sync: " + syncResult + ", " + operation);
        }
        operation = new SyncOperation(operation);
        if (operation.extras.getBoolean("ignore_backoff", false)) {
            operation.extras.remove("ignore_backoff");
        }
        if (operation.extras.getBoolean("do_not_retry", false)) {
            Log.d(TAG, "not retrying sync operation because SYNC_EXTRAS_DO_NOT_RETRY was specified " + operation);
        } else if (operation.extras.getBoolean("upload", false)) {
            operation.extras.remove("upload");
            Log.d(TAG, "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + operation);
            this.scheduleSyncOperation(operation);
        } else if (syncResult.tooManyRetries) {
            Log.d(TAG, "not retrying sync operation because it retried too many times: " + operation);
        } else if (syncResult.madeSomeProgress()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because even though it had an error it achieved some success");
            }
            this.scheduleSyncOperation(operation);
        } else if (syncResult.syncAlreadyInProgress) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation that failed because there was already a sync in progress: " + operation);
            }
            this.scheduleSyncOperation(new SyncOperation(operation.account, operation.syncSource, operation.authority, operation.extras, 10000L));
        } else if (syncResult.hasSoftError()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because it encountered a soft error: " + operation);
            }
            this.scheduleSyncOperation(operation);
        } else {
            Log.d(TAG, "not retrying sync operation because the error is a hard error: " + operation);
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter pw) {
        StringBuilder sb = new StringBuilder();
        this.dumpSyncState(pw, sb);
        this.dumpSyncHistory(pw, sb);
        pw.println();
        pw.println("SyncAdapters:");
        for (RegisteredServicesCache.ServiceInfo info : this.mSyncAdapters.getAllServices()) {
            pw.println("  " + info);
        }
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpSyncState(PrintWriter pw, StringBuilder sb) {
        pw.print("data connected: ");
        pw.println(this.mDataConnectionIsConnected);
        pw.print("memory low: ");
        pw.println(this.mStorageIsLow);
        Account[] accounts = this.mAccounts;
        pw.print("accounts: ");
        if (accounts != INITIAL_ACCOUNTS_ARRAY) {
            pw.println(accounts.length);
        } else {
            pw.println("not known yet");
        }
        long now = SystemClock.elapsedRealtime();
        pw.print("now: ");
        pw.print(now);
        pw.println(" (" + SyncManager.formatTime(System.currentTimeMillis()) + ")");
        pw.print("uptime: ");
        pw.print(DateUtils.formatElapsedTime(now / 1000L));
        pw.println(" (HH:MM:SS)");
        pw.print("time spent syncing: ");
        pw.print(DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L));
        pw.print(" (HH:MM:SS), sync ");
        pw.print(this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ");
        pw.println("in progress");
        if (this.mSyncHandler.mAlarmScheduleTime != null) {
            pw.print("next alarm time: ");
            pw.print(this.mSyncHandler.mAlarmScheduleTime);
            pw.print(" (");
            pw.print(DateUtils.formatElapsedTime((this.mSyncHandler.mAlarmScheduleTime - now) / 1000L));
            pw.println(" (HH:MM:SS) from now)");
        } else {
            pw.println("no alarm is scheduled (there had better not be any pending syncs)");
        }
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        pw.print("active sync: ");
        pw.println(activeSyncContext);
        pw.print("notification info: ");
        sb.setLength(0);
        this.mSyncHandler.mSyncNotificationInfo.toString(sb);
        pw.println(sb.toString());
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            pw.print("sync queue: ");
            sb.setLength(0);
            this.mSyncQueue.dump(sb);
            pw.println(sb.toString());
        }
        SyncInfo active = this.mSyncStorageEngine.getCurrentSync();
        if (active != null) {
            SyncStorageEngine.AuthorityInfo authority = this.mSyncStorageEngine.getAuthority(active.authorityId);
            long durationInSeconds = (now - active.startTime) / 1000L;
            pw.print("Active sync: ");
            pw.print(authority != null ? authority.account : "<no account>");
            pw.print(" ");
            pw.print(authority != null ? authority.authority : "<no account>");
            if (activeSyncContext != null) {
                pw.print(" ");
                pw.print(SyncStorageEngine.SOURCES[activeSyncContext.mSyncOperation.syncSource]);
            }
            pw.print(", duration is ");
            pw.println(DateUtils.formatElapsedTime(durationInSeconds));
        } else {
            pw.println("No sync is in progress.");
        }
        ArrayList<SyncStorageEngine.PendingOperation> ops = this.mSyncStorageEngine.getPendingOperations();
        if (ops != null && ops.size() > 0) {
            pw.println();
            pw.println("Pending Syncs");
            int N = ops.size();
            for (int i = 0; i < N; ++i) {
                SyncStorageEngine.PendingOperation op = ops.get(i);
                pw.print("  #");
                pw.print(i);
                pw.print(": account=");
                pw.print(op.account.name);
                pw.print(":");
                pw.print(op.account.type);
                pw.print(" authority=");
                pw.print(op.authority);
                pw.print(" expedited=");
                pw.println(op.expedited);
                if (op.extras == null || op.extras.size() <= 0) continue;
                sb.setLength(0);
                SyncOperation.extrasToStringBuilder(op.extras, sb, false);
                pw.print("    extras: ");
                pw.println(sb.toString());
            }
        }
        pw.println();
        pw.println("Sync Status");
        for (Account account : accounts) {
            pw.print("  Account ");
            pw.print(account.name);
            pw.print(" ");
            pw.print(account.type);
            pw.println(":");
            for (RegisteredServicesCache.ServiceInfo syncAdapterType : this.mSyncAdapters.getAllServices()) {
                if (!((SyncAdapterType)syncAdapterType.type).accountType.equals(account.type)) continue;
                SyncStorageEngine.AuthorityInfo settings = this.mSyncStorageEngine.getOrCreateAuthority(account, ((SyncAdapterType)syncAdapterType.type).authority);
                SyncStatusInfo status = this.mSyncStorageEngine.getOrCreateSyncStatus(settings);
                pw.print("    ");
                pw.print(settings.authority);
                pw.println(":");
                pw.print("      settings:");
                pw.print(" " + (settings.syncable > 0 ? "syncable" : (settings.syncable == 0 ? "not syncable" : "not initialized")));
                pw.print(", " + (settings.enabled ? "enabled" : "disabled"));
                if (settings.delayUntil > now) {
                    pw.print(", delay for " + (settings.delayUntil - now) / 1000L + " sec");
                }
                if (settings.backoffTime > now) {
                    pw.print(", backoff for " + (settings.backoffTime - now) / 1000L + " sec");
                }
                if (settings.backoffDelay > 0L) {
                    pw.print(", the backoff increment is " + settings.backoffDelay / 1000L + " sec");
                }
                pw.println();
                for (int periodicIndex = 0; periodicIndex < settings.periodicSyncs.size(); ++periodicIndex) {
                    Pair<Bundle, Long> info = settings.periodicSyncs.get(periodicIndex);
                    long lastPeriodicTime = status.getPeriodicSyncTime(periodicIndex);
                    long nextPeriodicTime = lastPeriodicTime + (Long)info.second * 1000L;
                    pw.println("      periodic period=" + info.second + ", extras=" + info.first + ", next=" + SyncManager.formatTime(nextPeriodicTime));
                }
                pw.print("      count: local=");
                pw.print(status.numSourceLocal);
                pw.print(" poll=");
                pw.print(status.numSourcePoll);
                pw.print(" periodic=");
                pw.print(status.numSourcePeriodic);
                pw.print(" server=");
                pw.print(status.numSourceServer);
                pw.print(" user=");
                pw.print(status.numSourceUser);
                pw.print(" total=");
                pw.print(status.numSyncs);
                pw.println();
                pw.print("      total duration: ");
                pw.println(DateUtils.formatElapsedTime(status.totalElapsedTime / 1000L));
                if (status.lastSuccessTime != 0L) {
                    pw.print("      SUCCESS: source=");
                    pw.print(SyncStorageEngine.SOURCES[status.lastSuccessSource]);
                    pw.print(" time=");
                    pw.println(SyncManager.formatTime(status.lastSuccessTime));
                }
                if (status.lastFailureTime == 0L) continue;
                pw.print("      FAILURE: source=");
                pw.print(SyncStorageEngine.SOURCES[status.lastFailureSource]);
                pw.print(" initialTime=");
                pw.print(SyncManager.formatTime(status.initialFailureTime));
                pw.print(" lastTime=");
                pw.println(SyncManager.formatTime(status.lastFailureTime));
                pw.print("      message: ");
                pw.println(status.lastFailureMesg);
            }
        }
    }

    private void dumpTimeSec(PrintWriter pw, long time) {
        pw.print(time / 1000L);
        pw.print('.');
        pw.print(time / 100L % 10L);
        pw.print('s');
    }

    private void dumpDayStatistic(PrintWriter pw, SyncStorageEngine.DayStats ds) {
        pw.print("Success (");
        pw.print(ds.successCount);
        if (ds.successCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.successTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.successTime / (long)ds.successCount);
        }
        pw.print(") Failure (");
        pw.print(ds.failureCount);
        if (ds.failureCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.failureTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.failureTime / (long)ds.failureCount);
        }
        pw.println(")");
    }

    protected void dumpSyncHistory(PrintWriter pw, StringBuilder sb) {
        ArrayList<SyncStorageEngine.SyncHistoryItem> items;
        SyncStorageEngine.DayStats[] dses = this.mSyncStorageEngine.getDayStatistics();
        if (dses != null && dses[0] != null) {
            int delta;
            SyncStorageEngine.DayStats ds;
            int i;
            pw.println();
            pw.println("Sync Statistics");
            pw.print("  Today:  ");
            this.dumpDayStatistic(pw, dses[0]);
            int today = dses[0].day;
            for (i = 1; i <= 6 && i < dses.length && (ds = dses[i]) != null && (delta = today - ds.day) <= 6; ++i) {
                pw.print("  Day-");
                pw.print(delta);
                pw.print(":  ");
                this.dumpDayStatistic(pw, ds);
            }
            int weekDay = today;
            while (i < dses.length) {
                SyncStorageEngine.DayStats aggr = null;
                weekDay -= 7;
                while (i < dses.length) {
                    ds = dses[i];
                    if (ds == null) {
                        i = dses.length;
                        break;
                    }
                    int delta2 = weekDay - ds.day;
                    if (delta2 > 6) break;
                    ++i;
                    if (aggr == null) {
                        aggr = new SyncStorageEngine.DayStats(weekDay);
                    }
                    aggr.successCount += ds.successCount;
                    aggr.successTime += ds.successTime;
                    aggr.failureCount += ds.failureCount;
                    aggr.failureTime += ds.failureTime;
                }
                if (aggr == null) continue;
                pw.print("  Week-");
                pw.print((today - weekDay) / 7);
                pw.print(": ");
                this.dumpDayStatistic(pw, aggr);
            }
        }
        if ((items = this.mSyncStorageEngine.getSyncHistory()) != null && items.size() > 0) {
            pw.println();
            pw.println("Recent Sync History");
            int N = items.size();
            for (int i = 0; i < N; ++i) {
                SyncStorageEngine.SyncHistoryItem item = items.get(i);
                SyncStorageEngine.AuthorityInfo authority = this.mSyncStorageEngine.getAuthority(item.authorityId);
                pw.print("  #");
                pw.print(i + 1);
                pw.print(": ");
                if (authority != null) {
                    pw.print(authority.account.name);
                    pw.print(":");
                    pw.print(authority.account.type);
                    pw.print(" ");
                    pw.print(authority.authority);
                } else {
                    pw.print("<no account>");
                }
                Time time = new Time();
                time.set(item.eventTime);
                pw.print(" ");
                pw.print(SyncStorageEngine.SOURCES[item.source]);
                pw.print(" @ ");
                pw.print(SyncManager.formatTime(item.eventTime));
                pw.print(" for ");
                this.dumpTimeSec(pw, item.elapsedTime);
                pw.println();
                if (item.event != 1 || item.upstreamActivity != 0L || item.downstreamActivity != 0L) {
                    pw.print("    event=");
                    pw.print(item.event);
                    pw.print(" upstreamActivity=");
                    pw.print(item.upstreamActivity);
                    pw.print(" downstreamActivity=");
                    pw.println(item.downstreamActivity);
                }
                if (item.mesg == null || "success".equals(item.mesg)) continue;
                pw.print("    mesg=");
                pw.println(item.mesg);
            }
        }
    }

    static {
        String localSyncDelayString = SystemProperties.get("sync.local_sync_delay");
        long localSyncDelay = 30000L;
        if (localSyncDelayString != null) {
            try {
                localSyncDelay = Long.parseLong(localSyncDelayString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        LOCAL_SYNC_DELAY = localSyncDelay;
        String maxTimePerSyncString = SystemProperties.get("sync.max_time_per_sync");
        long maxTimePerSync = 300000L;
        if (maxTimePerSyncString != null) {
            try {
                maxTimePerSync = Long.parseLong(maxTimePerSyncString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        MAX_TIME_PER_SYNC = maxTimePerSync;
        INITIAL_ACCOUNTS_ARRAY = new Account[0];
    }

    class SyncHandler
    extends Handler {
        private static final int MESSAGE_SYNC_FINISHED = 1;
        private static final int MESSAGE_SYNC_ALARM = 2;
        private static final int MESSAGE_CHECK_ALARMS = 3;
        private static final int MESSAGE_SERVICE_CONNECTED = 4;
        private static final int MESSAGE_SERVICE_DISCONNECTED = 5;
        public final SyncNotificationInfo mSyncNotificationInfo;
        private Long mAlarmScheduleTime;
        public final SyncTimeTracker mSyncTimeTracker;
        private boolean mErrorNotificationInstalled;
        private volatile CountDownLatch mReadyToRunLatch;

        public void onBootCompleted() {
            SyncManager.this.mBootCompleted = true;
            SyncManager.this.mSyncStorageEngine.doDatabaseCleanup(AccountManager.get(SyncManager.this.mContext).getAccounts());
            if (this.mReadyToRunLatch != null) {
                this.mReadyToRunLatch.countDown();
            }
        }

        private void waitUntilReadyToRun() {
            CountDownLatch latch = this.mReadyToRunLatch;
            if (latch != null) {
                while (true) {
                    try {
                        latch.await();
                        this.mReadyToRunLatch = null;
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }

        public SyncHandler(Looper looper) {
            super(looper);
            this.mSyncNotificationInfo = new SyncNotificationInfo();
            this.mAlarmScheduleTime = null;
            this.mSyncTimeTracker = new SyncTimeTracker();
            this.mErrorNotificationInstalled = false;
            this.mReadyToRunLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            boolean isSyncInProgress22;
            Long earliestFuturePollTime;
            block30: {
                boolean isSyncInProgress22;
                block29: {
                    earliestFuturePollTime = null;
                    try {
                        this.waitUntilReadyToRun();
                        earliestFuturePollTime = this.scheduleReadyPeriodicSyncs();
                        switch (msg.what) {
                            case 1: {
                                if (Log.isLoggable(SyncManager.TAG, 2)) {
                                    Log.v(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SYNC_FINISHED");
                                }
                                SyncHandlerMessagePayload payload = (SyncHandlerMessagePayload)msg.obj;
                                if (SyncManager.this.mActiveSyncContext != payload.activeSyncContext) {
                                    Log.d(SyncManager.TAG, "handleSyncHandlerMessage: sync context doesn't match, dropping: mActiveSyncContext " + SyncManager.this.mActiveSyncContext + " != " + payload.activeSyncContext);
                                    Object var9_4 = null;
                                    break block29;
                                } else {
                                    this.runSyncFinishedOrCanceled(payload.syncResult);
                                    this.runStateIdle();
                                    break;
                                }
                            }
                            case 4: {
                                ServiceConnectionData msgData = (ServiceConnectionData)msg.obj;
                                if (Log.isLoggable(SyncManager.TAG, 2)) {
                                    Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SERVICE_CONNECTED: " + msgData.activeSyncContext + " active is " + SyncManager.this.mActiveSyncContext);
                                }
                                if (SyncManager.this.mActiveSyncContext == msgData.activeSyncContext) {
                                    this.runBoundToSyncAdapter(msgData.syncAdapter);
                                    break;
                                }
                                break block30;
                            }
                            case 5: {
                                ServiceConnectionData msgData = (ServiceConnectionData)msg.obj;
                                if (Log.isLoggable(SyncManager.TAG, 2)) {
                                    Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SERVICE_DISCONNECTED: " + msgData.activeSyncContext + " active is " + SyncManager.this.mActiveSyncContext);
                                }
                                if (SyncManager.this.mActiveSyncContext != msgData.activeSyncContext) break block30;
                                if (((SyncManager)SyncManager.this).mActiveSyncContext.mSyncAdapter != null) {
                                    try {
                                        ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncAdapter.cancelSync(SyncManager.this.mActiveSyncContext);
                                    }
                                    catch (RemoteException e) {
                                        // empty catch block
                                    }
                                }
                                SyncResult syncResult = new SyncResult();
                                ++syncResult.stats.numIoExceptions;
                                this.runSyncFinishedOrCanceled(syncResult);
                                this.runStateIdle();
                                break;
                            }
                            case 2: {
                                boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
                                if (isLoggable) {
                                    Log.v(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SYNC_ALARM");
                                }
                                this.mAlarmScheduleTime = null;
                                try {
                                    if (SyncManager.this.mActiveSyncContext != null) {
                                        if (isLoggable) {
                                            Log.v(SyncManager.TAG, "handleSyncHandlerMessage: sync context is active");
                                        }
                                        this.runStateSyncing();
                                    }
                                    if (SyncManager.this.mActiveSyncContext == null) {
                                        if (isLoggable) {
                                            Log.v(SyncManager.TAG, "handleSyncHandlerMessage: sync context is not active");
                                        }
                                        this.runStateIdle();
                                    }
                                    Object var7_15 = null;
                                    SyncManager.this.mHandleAlarmWakeLock.release();
                                    break;
                                }
                                catch (Throwable throwable) {
                                    Object var7_16 = null;
                                    SyncManager.this.mHandleAlarmWakeLock.release();
                                    throw throwable;
                                }
                            }
                            case 3: {
                                if (Log.isLoggable(SyncManager.TAG, 2)) {
                                    Log.v(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_CHECK_ALARMS");
                                }
                                break block30;
                            }
                        }
                        break block30;
                    }
                    catch (Throwable throwable) {
                        boolean isSyncInProgress22;
                        Object var9_6 = null;
                        boolean bl = isSyncInProgress22 = SyncManager.this.mActiveSyncContext != null;
                        if (!isSyncInProgress22) {
                            SyncManager.this.mSyncWakeLock.release();
                        }
                        this.manageSyncNotification();
                        this.manageErrorNotification();
                        this.manageSyncAlarm(earliestFuturePollTime);
                        this.mSyncTimeTracker.update();
                        throw throwable;
                    }
                }
                boolean bl = isSyncInProgress22 = SyncManager.this.mActiveSyncContext != null;
                if (!isSyncInProgress22) {
                    SyncManager.this.mSyncWakeLock.release();
                }
                this.manageSyncNotification();
                this.manageErrorNotification();
                this.manageSyncAlarm(earliestFuturePollTime);
                this.mSyncTimeTracker.update();
                return;
            }
            Object var9_5 = null;
            boolean bl = isSyncInProgress22 = SyncManager.this.mActiveSyncContext != null;
            if (!isSyncInProgress22) {
                SyncManager.this.mSyncWakeLock.release();
            }
            this.manageSyncNotification();
            this.manageErrorNotification();
            this.manageSyncAlarm(earliestFuturePollTime);
            this.mSyncTimeTracker.update();
        }

        private Long scheduleReadyPeriodicSyncs() {
            boolean backgroundDataUsageAllowed = SyncManager.this.getConnectivityManager().getBackgroundDataSetting();
            Long earliestFuturePollTime = null;
            if (!backgroundDataUsageAllowed || !SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically()) {
                return earliestFuturePollTime;
            }
            long nowAbsolute = System.currentTimeMillis();
            ArrayList<SyncStorageEngine.AuthorityInfo> infos = SyncManager.this.mSyncStorageEngine.getAuthorities();
            for (SyncStorageEngine.AuthorityInfo info : infos) {
                if (!ArrayUtils.contains(SyncManager.this.mAccounts, info.account) || !SyncManager.this.mSyncStorageEngine.getSyncAutomatically(info.account, info.authority) || SyncManager.this.mSyncStorageEngine.getIsSyncable(info.account, info.authority) == 0) continue;
                SyncStatusInfo status = SyncManager.this.mSyncStorageEngine.getOrCreateSyncStatus(info);
                int N = info.periodicSyncs.size();
                for (int i = 0; i < N; ++i) {
                    Bundle extras = (Bundle)info.periodicSyncs.get((int)i).first;
                    Long periodInSeconds = (Long)info.periodicSyncs.get((int)i).second;
                    long lastPollTimeAbsolute = status.getPeriodicSyncTime(i);
                    long nextPollTimeAbsolute = lastPollTimeAbsolute + periodInSeconds * 1000L;
                    if (nextPollTimeAbsolute <= nowAbsolute) {
                        SyncManager.this.scheduleSyncOperation(new SyncOperation(info.account, 4, info.authority, extras, 0L));
                        status.setPeriodicSyncTime(i, nowAbsolute);
                        continue;
                    }
                    if (earliestFuturePollTime != null && nextPollTimeAbsolute >= earliestFuturePollTime) continue;
                    earliestFuturePollTime = nextPollTimeAbsolute;
                }
            }
            if (earliestFuturePollTime == null) {
                return null;
            }
            return SystemClock.elapsedRealtime() + (earliestFuturePollTime < nowAbsolute ? 0L : earliestFuturePollTime - nowAbsolute);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runStateSyncing() {
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            long now = SystemClock.elapsedRealtime();
            if (now > activeSyncContext.mTimeoutStartTime + MAX_TIME_PER_SYNC) {
                Pair<SyncOperation, Long> nextOpAndRunTime;
                SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                synchronized (syncQueue) {
                    nextOpAndRunTime = SyncManager.this.mSyncQueue.nextOperation();
                }
                if (nextOpAndRunTime != null && (Long)nextOpAndRunTime.second <= now) {
                    Log.d(SyncManager.TAG, "canceling and rescheduling sync because it ran too long: " + activeSyncContext.mSyncOperation);
                    SyncManager.this.scheduleSyncOperation(new SyncOperation(activeSyncContext.mSyncOperation));
                    SyncManager.this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
                } else {
                    activeSyncContext.mTimeoutStartTime = now + MAX_TIME_PER_SYNC;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runStateIdle() {
            int syncableState;
            SyncOperation op;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "runStateIdle");
            }
            if (!SyncManager.this.mDataConnectionIsConnected) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: no data connection, skipping");
                }
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: memory low, skipping");
                }
                return;
            }
            Account[] accounts = SyncManager.this.mAccounts;
            if (accounts == INITIAL_ACCOUNTS_ARRAY) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: accounts not known, skipping");
                }
                return;
            }
            boolean backgroundDataUsageAllowed = SyncManager.this.getConnectivityManager().getBackgroundDataSetting();
            boolean masterSyncAutomatically = SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically();
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            synchronized (syncQueue) {
                long now = SystemClock.elapsedRealtime();
                do {
                    Pair<SyncOperation, Long> nextOpAndRunTime;
                    if ((nextOpAndRunTime = SyncManager.this.mSyncQueue.nextOperation()) == null || (Long)nextOpAndRunTime.second > now) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "runStateIdle: no more ready sync operations, returning");
                        }
                        return;
                    }
                    op = (SyncOperation)nextOpAndRunTime.first;
                    SyncManager.this.mSyncQueue.remove(op);
                } while (!ArrayUtils.contains(SyncManager.this.mAccounts, op.account) || (syncableState = SyncManager.this.mSyncStorageEngine.getIsSyncable(op.account, op.authority)) == 0 || !op.extras.getBoolean("ignore_settings", false) && syncableState > 0 && (!masterSyncAutomatically || !backgroundDataUsageAllowed || !SyncManager.this.mSyncStorageEngine.getSyncAutomatically(op.account, op.authority)));
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runStateIdle: we are going to sync " + op);
                }
            }
            boolean initializeIsSet = op.extras.getBoolean("initialize", false);
            if (syncableState < 0 && !initializeIsSet) {
                op.extras.putBoolean("initialize", true);
                op = new SyncOperation(op);
            } else if (syncableState > 0 && initializeIsSet) {
                op.extras.putBoolean("initialize", false);
                op = new SyncOperation(op);
            }
            SyncAdapterType syncAdapterType = SyncAdapterType.newKey(op.authority, op.account.type);
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(syncAdapterType);
            if (syncAdapterInfo == null) {
                Log.d(SyncManager.TAG, "can't find a sync adapter for " + syncAdapterType + ", removing settings for it");
                SyncManager.this.mSyncStorageEngine.removeAuthority(op.account, op.authority);
                this.runStateIdle();
                return;
            }
            ActiveSyncContext activeSyncContext = new ActiveSyncContext(op, this.insertStartSyncEvent(op));
            SyncManager.this.mActiveSyncContext = activeSyncContext;
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "runStateIdle: setting mActiveSyncContext to " + SyncManager.this.mActiveSyncContext);
            }
            SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            if (!activeSyncContext.bindToSyncAdapter(syncAdapterInfo)) {
                Log.e(SyncManager.TAG, "Bind attempt failed to " + syncAdapterInfo);
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.this.mActiveSyncContext = null;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                SyncManager.this.mSyncWakeLock.setWorkSource(null);
                this.runStateIdle();
                return;
            }
            SyncManager.this.mSyncWakeLock.setWorkSource(new WorkSource(syncAdapterInfo.uid));
            SyncManager.this.mSyncWakeLock.acquire();
        }

        private void runBoundToSyncAdapter(ISyncAdapter syncAdapter) {
            ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncAdapter = syncAdapter;
            SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
            try {
                syncAdapter.startSync(SyncManager.this.mActiveSyncContext, syncOperation.authority, syncOperation.account, syncOperation.extras);
            }
            catch (RemoteException remoteExc) {
                Log.d(SyncManager.TAG, "runStateIdle: caught a RemoteException, rescheduling", remoteExc);
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.this.mActiveSyncContext = null;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                SyncManager.this.increaseBackoffSetting(syncOperation);
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation));
            }
            catch (RuntimeException exc) {
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.this.mActiveSyncContext = null;
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                Log.e(SyncManager.TAG, "Caught RuntimeException while starting the sync " + syncOperation, exc);
            }
        }

        private void runSyncFinishedOrCanceled(SyncResult syncResult) {
            int upstreamActivity;
            int downstreamActivity;
            String historyMessage;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            SyncManager.this.mActiveSyncContext = null;
            SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            long elapsedTime = SystemClock.elapsedRealtime() - activeSyncContext.mStartTime;
            if (syncResult != null) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [finished]: " + syncOperation + ", result " + syncResult);
                }
                if (!syncResult.hasError()) {
                    historyMessage = "success";
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                    SyncManager.this.clearBackoffSetting(syncOperation);
                    if (syncOperation.extras.getBoolean("initialize", false) && SyncManager.this.mSyncStorageEngine.getIsSyncable(syncOperation.account, syncOperation.authority) > 0) {
                        SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation));
                    }
                } else {
                    Log.d(SyncManager.TAG, "failed sync operation " + syncOperation + ", " + syncResult);
                    if (!syncResult.syncAlreadyInProgress) {
                        SyncManager.this.increaseBackoffSetting(syncOperation);
                    }
                    SyncManager.this.maybeRescheduleSync(syncResult, syncOperation);
                    historyMessage = Integer.toString(this.syncResultToErrorNumber(syncResult));
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                }
                SyncManager.this.setDelayUntilTime(syncOperation, syncResult.delayUntil);
            } else {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [canceled]: " + syncOperation);
                }
                if (activeSyncContext.mSyncAdapter != null) {
                    try {
                        activeSyncContext.mSyncAdapter.cancelSync(activeSyncContext);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                historyMessage = "canceled";
                downstreamActivity = 0;
                upstreamActivity = 0;
            }
            this.stopSyncEvent(activeSyncContext.mHistoryRowId, syncOperation, historyMessage, upstreamActivity, downstreamActivity, elapsedTime);
            activeSyncContext.close();
            if (syncResult != null && syncResult.tooManyDeletions) {
                this.installHandleTooManyDeletesNotification(syncOperation.account, syncOperation.authority, syncResult.stats.numDeletes);
            } else {
                SyncManager.this.mNotificationMgr.cancel(syncOperation.account.hashCode() ^ syncOperation.authority.hashCode());
            }
            if (syncResult != null && syncResult.fullSyncRequested) {
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation.account, syncOperation.syncSource, syncOperation.authority, new Bundle(), 0L));
            }
        }

        private int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            throw new IllegalStateException("we are not in an error state, " + syncResult);
        }

        private void manageSyncNotification() {
            SyncOperation syncOperation;
            boolean shouldInstall;
            boolean shouldCancel;
            if (SyncManager.this.mActiveSyncContext == null) {
                this.mSyncNotificationInfo.startTime = null;
                shouldCancel = this.mSyncNotificationInfo.isActive;
                shouldInstall = false;
            } else {
                syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                long now = SystemClock.elapsedRealtime();
                if (this.mSyncNotificationInfo.startTime == null) {
                    this.mSyncNotificationInfo.startTime = now;
                }
                boolean bl = shouldCancel = this.mSyncNotificationInfo.isActive && (!syncOperation.authority.equals(this.mSyncNotificationInfo.authority) || !syncOperation.account.equals(this.mSyncNotificationInfo.account));
                if (this.mSyncNotificationInfo.isActive) {
                    shouldInstall = shouldCancel;
                } else {
                    boolean timeToShowNotification = now > this.mSyncNotificationInfo.startTime + 30000L;
                    boolean manualSync = syncOperation.extras.getBoolean("force", false);
                    boolean bl2 = shouldInstall = timeToShowNotification || manualSync;
                }
            }
            if (shouldCancel && !shouldInstall) {
                SyncManager.this.mNeedSyncActiveNotification = false;
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = false;
            }
            if (shouldInstall) {
                syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                SyncManager.this.mNeedSyncActiveNotification = true;
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = true;
                this.mSyncNotificationInfo.account = syncOperation.account;
                this.mSyncNotificationInfo.authority = syncOperation.authority;
            }
        }

        private void manageErrorNotification() {
            long when = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime();
            if (when > 0L && when + 600000L < System.currentTimeMillis()) {
                if (!this.mErrorNotificationInstalled) {
                    SyncManager.this.mNeedSyncErrorNotification = true;
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = true;
            } else {
                if (this.mErrorNotificationInstalled) {
                    SyncManager.this.mNeedSyncErrorNotification = false;
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageSyncAlarm(Long earliestFuturePollElapsedTime) {
            boolean needAlarm;
            long when;
            Long alarmTime;
            if (!SyncManager.this.mDataConnectionIsConnected) {
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            if (activeSyncContext == null) {
                SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                synchronized (syncQueue) {
                    Pair<SyncOperation, Long> candidate = SyncManager.this.mSyncQueue.nextOperation();
                    alarmTime = earliestFuturePollElapsedTime == null && candidate == null ? null : (earliestFuturePollElapsedTime == null ? (Long)candidate.second : (candidate == null ? earliestFuturePollElapsedTime : Long.valueOf(Math.min(earliestFuturePollElapsedTime, (Long)candidate.second))));
                }
            } else {
                long notificationTime = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.startTime + 30000L;
                long timeoutTime = ((SyncManager)SyncManager.this).mActiveSyncContext.mTimeoutStartTime + MAX_TIME_PER_SYNC;
                alarmTime = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.isActive ? Long.valueOf(timeoutTime) : Long.valueOf(Math.min(notificationTime, timeoutTime));
            }
            if (!this.mErrorNotificationInstalled && (when = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime()) > 0L) {
                long delay = (when += 600000L) - System.currentTimeMillis();
                when = now + delay;
                alarmTime = alarmTime != null ? Math.min(alarmTime, when) : when;
            }
            boolean shouldSet = false;
            boolean shouldCancel = false;
            boolean alarmIsActive = this.mAlarmScheduleTime != null;
            boolean bl = needAlarm = alarmTime != null;
            if (needAlarm) {
                if (!alarmIsActive || alarmTime < this.mAlarmScheduleTime) {
                    shouldSet = true;
                }
            } else {
                shouldCancel = alarmIsActive;
            }
            SyncManager.this.ensureAlarmService();
            if (shouldSet) {
                this.mAlarmScheduleTime = alarmTime;
                SyncManager.this.mAlarmService.set(2, alarmTime, SyncManager.this.mSyncAlarmIntent);
            } else if (shouldCancel) {
                this.mAlarmScheduleTime = null;
                SyncManager.this.mAlarmService.cancel(SyncManager.this.mSyncAlarmIntent);
            }
        }

        private void sendSyncStateIntent() {
            Intent syncStateIntent = new Intent("android.intent.action.SYNC_STATE_CHANGED");
            syncStateIntent.addFlags(0x10000000);
            syncStateIntent.putExtra("active", SyncManager.this.mNeedSyncActiveNotification);
            syncStateIntent.putExtra("failing", SyncManager.this.mNeedSyncErrorNotification);
            SyncManager.this.mContext.sendBroadcast(syncStateIntent);
        }

        private void installHandleTooManyDeletesNotification(Account account, String authority, long numDeletes) {
            if (SyncManager.this.mNotificationMgr == null) {
                return;
            }
            ProviderInfo providerInfo = SyncManager.this.mContext.getPackageManager().resolveContentProvider(authority, 0);
            if (providerInfo == null) {
                return;
            }
            CharSequence authorityName = providerInfo.loadLabel(SyncManager.this.mContext.getPackageManager());
            Intent clickIntent = new Intent();
            clickIntent.setClassName("com.android.providers.subscribedfeeds", "com.android.settings.SyncActivityTooManyDeletes");
            clickIntent.putExtra("account", account);
            clickIntent.putExtra("authority", authority);
            clickIntent.putExtra("provider", ((Object)authorityName).toString());
            clickIntent.putExtra("numDeletes", numDeletes);
            if (!this.isActivityAvailable(clickIntent)) {
                Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity(SyncManager.this.mContext, 0, clickIntent, 0x10000000);
            CharSequence tooManyDeletesDescFormat = SyncManager.this.mContext.getResources().getText(0x1040110);
            Notification notification = new Notification(17302163, SyncManager.this.mContext.getString(17039630), System.currentTimeMillis());
            notification.setLatestEventInfo(SyncManager.this.mContext, SyncManager.this.mContext.getString(17039631), String.format(((Object)tooManyDeletesDescFormat).toString(), authorityName), pendingIntent);
            notification.flags |= 2;
            SyncManager.this.mNotificationMgr.notify(account.hashCode() ^ authority.hashCode(), notification);
        }

        private boolean isActivityAvailable(Intent intent) {
            PackageManager pm = SyncManager.this.mContext.getPackageManager();
            List<ResolveInfo> list = pm.queryIntentActivities(intent, 0);
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ResolveInfo resolveInfo = list.get(i);
                if ((resolveInfo.activityInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            return false;
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            int source = syncOperation.syncSource;
            long now = System.currentTimeMillis();
            EventLog.writeEvent(2720, syncOperation.authority, 0, source, syncOperation.account.name.hashCode());
            return SyncManager.this.mSyncStorageEngine.insertStartSyncEvent(syncOperation.account, syncOperation.authority, now, source);
        }

        public void stopSyncEvent(long rowId, SyncOperation syncOperation, String resultMessage, int upstreamActivity, int downstreamActivity, long elapsedTime) {
            EventLog.writeEvent(2720, syncOperation.authority, 1, syncOperation.syncSource, syncOperation.account.name.hashCode());
            SyncManager.this.mSyncStorageEngine.stopSyncEvent(rowId, elapsedTime, resultMessage, downstreamActivity, upstreamActivity);
        }

        class SyncNotificationInfo {
            public Account account;
            public String authority;
            public boolean isActive = false;
            public Long startTime = null;

            SyncNotificationInfo() {
            }

            public void toString(StringBuilder sb) {
                sb.append("account ").append(this.account).append(", authority ").append(this.authority).append(", isActive ").append(this.isActive).append(", startTime ").append(this.startTime);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.toString(sb);
                return sb.toString();
            }
        }
    }

    class ServiceConnectionData {
        public final ActiveSyncContext activeSyncContext;
        public final ISyncAdapter syncAdapter;

        ServiceConnectionData(ActiveSyncContext activeSyncContext, ISyncAdapter syncAdapter) {
            this.activeSyncContext = activeSyncContext;
            this.syncAdapter = syncAdapter;
        }
    }

    private class SyncTimeTracker {
        boolean mLastWasSyncing = false;
        long mWhenSyncStarted = 0L;
        private long mTimeSpentSyncing;

        private SyncTimeTracker() {
        }

        public synchronized void update() {
            boolean isSyncInProgress;
            boolean bl = isSyncInProgress = SyncManager.this.mActiveSyncContext != null;
            if (isSyncInProgress == this.mLastWasSyncing) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            if (isSyncInProgress) {
                this.mWhenSyncStarted = now;
            } else {
                this.mTimeSpentSyncing += now - this.mWhenSyncStarted;
            }
            this.mLastWasSyncing = isSyncInProgress;
        }

        public synchronized long timeSpentSyncing() {
            if (!this.mLastWasSyncing) {
                return this.mTimeSpentSyncing;
            }
            long now = SystemClock.elapsedRealtime();
            return this.mTimeSpentSyncing + (now - this.mWhenSyncStarted);
        }
    }

    class ActiveSyncContext
    extends ISyncContext.Stub
    implements ServiceConnection {
        final SyncOperation mSyncOperation;
        final long mHistoryRowId;
        ISyncAdapter mSyncAdapter;
        final long mStartTime;
        long mTimeoutStartTime;
        boolean mBound;

        public ActiveSyncContext(SyncOperation syncOperation, long historyRowId) {
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = historyRowId;
            this.mSyncAdapter = null;
            this.mTimeoutStartTime = this.mStartTime = SystemClock.elapsedRealtime();
        }

        public void sendHeartbeat() {
        }

        public void onFinished(SyncResult result) {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, result);
        }

        public void toString(StringBuilder sb) {
            sb.append("startTime ").append(this.mStartTime).append(", mTimeoutStartTime ").append(this.mTimeoutStartTime).append(", mHistoryRowId ").append(this.mHistoryRowId).append(", syncOperation ").append(this.mSyncOperation);
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 4;
            msg.obj = new ServiceConnectionData(this, ISyncAdapter.Stub.asInterface(service));
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        public void onServiceDisconnected(ComponentName name) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 5;
            msg.obj = new ServiceConnectionData(this, null);
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        boolean bindToSyncAdapter(RegisteredServicesCache.ServiceInfo info) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "bindToSyncAdapter: " + info.componentName + ", connection " + this);
            }
            Intent intent = new Intent();
            intent.setAction("android.content.SyncAdapter");
            intent.setComponent(info.componentName);
            intent.putExtra("android.intent.extra.client_label", 17040238);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(SyncManager.this.mContext, 0, new Intent("android.settings.SYNC_SETTINGS"), 0));
            this.mBound = true;
            boolean bindResult = SyncManager.this.mContext.bindService(intent, this, 5);
            if (!bindResult) {
                this.mBound = false;
            }
            return bindResult;
        }

        protected void close() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "unBindFromSyncAdapter: connection " + this);
            }
            if (this.mBound) {
                this.mBound = false;
                SyncManager.this.mContext.unbindService(this);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }
    }

    class SyncAlarmIntentReceiver
    extends BroadcastReceiver {
        SyncAlarmIntentReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mHandleAlarmWakeLock.acquire();
            SyncManager.this.sendSyncAlarmMessage();
        }
    }

    class SyncHandlerMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        SyncHandlerMessagePayload(ActiveSyncContext syncContext, SyncResult syncResult) {
            this.activeSyncContext = syncContext;
            this.syncResult = syncResult;
        }
    }

    private static class InitializerServiceConnection
    implements ServiceConnection {
        private final Account mAccount;
        private final String mAuthority;
        private final Handler mHandler;
        private volatile Context mContext;
        private volatile boolean mInitialized;

        public InitializerServiceConnection(Account account, String authority, Context context, Handler handler) {
            this.mAccount = account;
            this.mAuthority = authority;
            this.mContext = context;
            this.mHandler = handler;
            this.mInitialized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                try {
                    if (!this.mInitialized) {
                        this.mInitialized = true;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.v(SyncManager.TAG, "calling initialize: " + this.mAccount + ", authority " + this.mAuthority);
                        }
                        ISyncAdapter.Stub.asInterface(service).initialize(this.mAccount, this.mAuthority);
                    }
                }
                catch (RemoteException e) {
                    Log.d(SyncManager.TAG, "error while initializing: " + this.mAccount + ", authority " + this.mAuthority, e);
                    Object var5_4 = null;
                    this.mHandler.postDelayed(new Runnable(){

                        public void run() {
                            if (InitializerServiceConnection.this.mContext != null) {
                                InitializerServiceConnection.this.mContext.unbindService(InitializerServiceConnection.this);
                                InitializerServiceConnection.this.mContext = null;
                            }
                        }
                    }, 5000L);
                    return;
                }
                Object var5_3 = null;
                this.mHandler.postDelayed(new /* invalid duplicate definition of identical inner class */, 5000L);
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.mHandler.postDelayed(new /* invalid duplicate definition of identical inner class */, 5000L);
                throw throwable;
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            if (this.mContext != null) {
                this.mContext.unbindService(this);
                this.mContext = null;
            }
        }
    }
}

