/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.content.SyncAdapterType;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyncAdaptersCache
extends RegisteredServicesCache<SyncAdapterType> {
    private static final String TAG = "Account";
    private static final String SERVICE_INTERFACE = "android.content.SyncAdapter";
    private static final String SERVICE_META_DATA = "android.content.SyncAdapter";
    private static final String ATTRIBUTES_NAME = "sync-adapter";
    private static final MySerializer sSerializer = new MySerializer();

    SyncAdaptersCache(Context context) {
        super(context, "android.content.SyncAdapter", "android.content.SyncAdapter", ATTRIBUTES_NAME, sSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncAdapterType parseServiceAttributes(Resources res, String packageName, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.SyncAdapter);
        try {
            String authority = sa.getString(1);
            String accountType = sa.getString(0);
            if (authority == null || accountType == null) {
                SyncAdapterType syncAdapterType = null;
                return syncAdapterType;
            }
            boolean userVisible = sa.getBoolean(2, true);
            boolean supportsUploading = sa.getBoolean(3, true);
            SyncAdapterType syncAdapterType = new SyncAdapterType(authority, accountType, userVisible, supportsUploading);
            return syncAdapterType;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MySerializer
    implements XmlSerializerAndParser<SyncAdapterType> {
        MySerializer() {
        }

        @Override
        public void writeAsXml(SyncAdapterType item, XmlSerializer out) throws IOException {
            out.attribute(null, "authority", item.authority);
            out.attribute(null, "accountType", item.accountType);
        }

        @Override
        public SyncAdapterType createFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            String authority = parser.getAttributeValue(null, "authority");
            String accountType = parser.getAttributeValue(null, "accountType");
            return SyncAdapterType.newKey(authority, accountType);
        }
    }
}

