/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public abstract class BroadcastReceiver {
    private int mResultCode;
    private String mResultData;
    private Bundle mResultExtras;
    private boolean mAbortBroadcast;
    private boolean mDebugUnregister;
    private boolean mOrderedHint;
    private boolean mInitialStickyHint;

    public abstract void onReceive(Context var1, Intent var2);

    public IBinder peekService(Context myContext, Intent service) {
        IActivityManager am = ActivityManagerNative.getDefault();
        IBinder binder = null;
        try {
            binder = am.peekService(service, service.resolveTypeIfNeeded(myContext.getContentResolver()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return binder;
    }

    public final void setResultCode(int code) {
        this.checkSynchronousHint();
        this.mResultCode = code;
    }

    public final int getResultCode() {
        return this.mResultCode;
    }

    public final void setResultData(String data) {
        this.checkSynchronousHint();
        this.mResultData = data;
    }

    public final String getResultData() {
        return this.mResultData;
    }

    public final void setResultExtras(Bundle extras) {
        this.checkSynchronousHint();
        this.mResultExtras = extras;
    }

    public final Bundle getResultExtras(boolean makeMap) {
        Bundle e = this.mResultExtras;
        if (!makeMap) {
            return e;
        }
        if (e == null) {
            this.mResultExtras = e = new Bundle();
        }
        return e;
    }

    public final void setResult(int code, String data, Bundle extras) {
        this.checkSynchronousHint();
        this.mResultCode = code;
        this.mResultData = data;
        this.mResultExtras = extras;
    }

    public final boolean getAbortBroadcast() {
        return this.mAbortBroadcast;
    }

    public final void abortBroadcast() {
        this.checkSynchronousHint();
        this.mAbortBroadcast = true;
    }

    public final void clearAbortBroadcast() {
        this.mAbortBroadcast = false;
    }

    public final boolean isOrderedBroadcast() {
        return this.mOrderedHint;
    }

    public final boolean isInitialStickyBroadcast() {
        return this.mInitialStickyHint;
    }

    public final void setOrderedHint(boolean isOrdered) {
        this.mOrderedHint = isOrdered;
    }

    public final void setInitialStickyHint(boolean isInitialSticky) {
        this.mInitialStickyHint = isInitialSticky;
    }

    public final void setDebugUnregister(boolean debug) {
        this.mDebugUnregister = debug;
    }

    public final boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    void checkSynchronousHint() {
        if (this.mOrderedHint || this.mInitialStickyHint) {
            return;
        }
        RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        e.fillInStackTrace();
        Log.e("BroadcastReceiver", e.getMessage(), e);
    }
}

