/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TimePicker;
import java.util.Calendar;

public class TimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String IS_24_HOUR = "is24hour";
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mCallback;
    private final Calendar mCalendar;
    private final java.text.DateFormat mDateFormat;
    int mInitialHourOfDay;
    int mInitialMinute;
    boolean mIs24HourView;

    public TimePickerDialog(Context context, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        this(context, 16973987, callBack, hourOfDay, minute, is24HourView);
    }

    public TimePickerDialog(Context context, int theme, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        super(context, theme);
        this.mCallback = callBack;
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.mDateFormat = DateFormat.getTimeFormat(context);
        this.mCalendar = Calendar.getInstance();
        this.updateTitle(this.mInitialHourOfDay, this.mInitialMinute);
        this.setButton(context.getText(17040168), this);
        this.setButton2(context.getText(0x1040000), (DialogInterface.OnClickListener)null);
        this.setIcon(17301908);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(17367142, null);
        this.setView(view);
        this.mTimePicker = (TimePicker)view.findViewById(16908827);
        this.mTimePicker.setCurrentHour(this.mInitialHourOfDay);
        this.mTimePicker.setCurrentMinute(this.mInitialMinute);
        this.mTimePicker.setIs24HourView(this.mIs24HourView);
        this.mTimePicker.setOnTimeChangedListener(this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallback != null) {
            this.mTimePicker.clearFocus();
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        this.updateTitle(hourOfDay, minute);
    }

    public void updateTime(int hourOfDay, int minutOfHour) {
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minutOfHour);
    }

    private void updateTitle(int hour, int minute) {
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, minute);
        this.setTitle(this.mDateFormat.format(this.mCalendar.getTime()));
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(HOUR, this.mTimePicker.getCurrentHour());
        state.putInt(MINUTE, this.mTimePicker.getCurrentMinute());
        state.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int hour = savedInstanceState.getInt(HOUR);
        int minute = savedInstanceState.getInt(MINUTE);
        this.mTimePicker.setCurrentHour(hour);
        this.mTimePicker.setCurrentMinute(minute);
        this.mTimePicker.setIs24HourView(savedInstanceState.getBoolean(IS_24_HOUR));
        this.mTimePicker.setOnTimeChangedListener(this);
        this.updateTitle(hour, minute);
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3);
    }
}

