/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.PendingIntent;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.app.SuggestionsAdapter;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "SearchDialog";
    private static final boolean DBG_LOG_TIMING = false;
    private static final String INSTANCE_KEY_COMPONENT = "comp";
    private static final String INSTANCE_KEY_APPDATA = "data";
    private static final String INSTANCE_KEY_STORED_APPDATA = "sData";
    private static final String INSTANCE_KEY_USER_QUERY = "uQry";
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final int SEARCH_PLATE_LEFT_PADDING_GLOBAL = 12;
    private static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private TextView mBadgeLabel;
    private ImageView mAppIcon;
    private SearchAutoComplete mSearchAutoComplete;
    private Button mGoButton;
    private ImageButton mVoiceButton;
    private View mSearchPlate;
    private Drawable mWorkingSpinner;
    private SearchableInfo mSearchable;
    private ComponentName mLaunchComponent;
    private Bundle mAppSearchData;
    private Context mActivityContext;
    private SearchManager mSearchManager;
    private final Intent mVoiceWebSearchIntent;
    private final Intent mVoiceAppSearchIntent;
    private SuggestionsAdapter mSuggestionsAdapter;
    private static final boolean REWRITE_QUERIES = true;
    private String mUserQuery;
    private String mInitialQuery;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache = new WeakHashMap();
    private int mSearchAutoCompleteImeOptions;
    private BroadcastReceiver mConfChangeListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                SearchDialog.this.onConfigurationChanged();
            }
        }
    };
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            if (!SearchDialog.this.mSearchAutoComplete.isPerformingCompletion()) {
                SearchDialog.this.mUserQuery = s == null ? "" : ((Object)s).toString();
            }
            SearchDialog.this.updateWidgetState();
            SearchDialog.this.updateVoiceButton(SearchDialog.this.mSearchAutoComplete.isEmpty() || SearchDialog.this.isBrowserSearch() && SearchDialog.this.mInitialQuery.equals(SearchDialog.this.mUserQuery) || SearchDialog.this.mAppSearchData != null && SearchDialog.this.mAppSearchData.getBoolean("android.search.CONTEXT_IS_VOICE"));
        }

        public void afterTextChanged(Editable s) {
            int options;
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            if (SearchDialog.this.mSearchable.autoUrlDetect() && !SearchDialog.this.mSearchAutoComplete.isPerformingCompletion() && (options = SearchDialog.this.mSearchAutoComplete.getImeOptions() & 0xFFFFFF00 | 2) != SearchDialog.this.mSearchAutoCompleteImeOptions) {
                SearchDialog.this.mSearchAutoCompleteImeOptions = options;
                SearchDialog.this.mSearchAutoComplete.setImeOptions(options);
                SearchDialog.this.mSearchAutoComplete.setInputType(SearchDialog.this.mSearchAutoComplete.getInputType());
            }
        }
    };
    View.OnKeyListener mButtonsKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchDialog.this.mSearchable == null) {
                return false;
            }
            if (!event.isSystem() && keyCode != 19 && keyCode != 21 && keyCode != 22 && keyCode != 23 && SearchDialog.this.mSearchAutoComplete.requestFocus()) {
                return SearchDialog.this.mSearchAutoComplete.dispatchKeyEvent(event);
            }
            return false;
        }
    };
    View.OnClickListener mGoButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            SearchDialog.this.launchQuerySearch();
        }
    };
    View.OnClickListener mVoiceButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchDialog.this.mSearchable == null) {
                return;
            }
            SearchableInfo searchable = SearchDialog.this.mSearchable;
            try {
                if (searchable.getVoiceSearchLaunchWebSearch()) {
                    Intent webSearchIntent = SearchDialog.this.createVoiceWebSearchIntent(SearchDialog.this.mVoiceWebSearchIntent, searchable);
                    SearchDialog.this.getContext().startActivity(webSearchIntent);
                } else if (searchable.getVoiceSearchLaunchRecognizer()) {
                    Intent appSearchIntent = SearchDialog.this.createVoiceAppSearchIntent(SearchDialog.this.mVoiceAppSearchIntent, searchable);
                    SearchDialog.this.getContext().startActivity(appSearchIntent);
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(SearchDialog.LOG_TAG, "Could not find voice search activity");
            }
            SearchDialog.this.dismiss();
        }
    };
    View.OnKeyListener mTextKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchDialog.this.mSearchable == null) {
                return false;
            }
            if (SearchDialog.this.mSearchAutoComplete.isPopupShowing() && SearchDialog.this.mSearchAutoComplete.getListSelection() != -1) {
                return SearchDialog.this.onSuggestionsKey(v, keyCode, event);
            }
            if (!SearchDialog.this.mSearchAutoComplete.isEmpty()) {
                SearchableInfo.ActionKeyInfo actionKey;
                if (keyCode == 66 && event.getAction() == 1) {
                    v.cancelLongPress();
                    if (SearchDialog.this.mSearchable.autoUrlDetect() && (SearchDialog.this.mSearchAutoCompleteImeOptions & 0xFF) == 2) {
                        Uri uri = Uri.parse(SearchDialog.this.fixUrl(SearchDialog.this.mSearchAutoComplete.getText().toString()));
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        intent.setFlags(0x10000000);
                        SearchDialog.this.launchIntent(intent);
                    } else {
                        SearchDialog.this.launchQuerySearch();
                    }
                    return true;
                }
                if (event.getAction() == 0 && (actionKey = SearchDialog.this.mSearchable.findActionKey(keyCode)) != null && actionKey.getQueryActionMsg() != null) {
                    SearchDialog.this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg());
                    return true;
                }
            }
            return false;
        }
    };
    private AtomicLong mLastLogTime = new AtomicLong(SystemClock.uptimeMillis());

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, 16973988);
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mSearchManager = searchManager;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 55;
        lp.softInputMode = 16;
        theWindow.setAttributes(lp);
        this.setCanceledOnTouchOutside(true);
    }

    private void createContentView() {
        this.setContentView(17367130);
        SearchBar searchBar = (SearchBar)this.findViewById(16908814);
        searchBar.setSearchDialog(this);
        this.mBadgeLabel = (TextView)this.findViewById(0x1020210);
        this.mSearchAutoComplete = (SearchAutoComplete)this.findViewById(16908819);
        this.mAppIcon = (ImageView)this.findViewById(0x1020212);
        this.mGoButton = (Button)this.findViewById(16908820);
        this.mVoiceButton = (ImageButton)this.findViewById(16908821);
        this.mSearchPlate = this.findViewById(16908815);
        this.mWorkingSpinner = this.getContext().getResources().getDrawable(17302137);
        this.mSearchAutoComplete.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mWorkingSpinner, null);
        this.setWorking(false);
        this.mSearchAutoComplete.addTextChangedListener(this.mTextWatcher);
        this.mSearchAutoComplete.setOnKeyListener(this.mTextKeyListener);
        this.mSearchAutoComplete.setOnItemClickListener(this);
        this.mSearchAutoComplete.setOnItemSelectedListener(this);
        this.mGoButton.setOnClickListener(this.mGoButtonClickListener);
        this.mGoButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mVoiceButton.setOnClickListener(this.mVoiceButtonClickListener);
        this.mVoiceButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    public boolean show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        boolean success = this.doShow(initialQuery, selectInitialQuery, componentName, appSearchData);
        if (success) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return success;
    }

    private boolean doShow(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        if (!this.show(componentName, appSearchData)) {
            return false;
        }
        this.mInitialQuery = initialQuery == null ? "" : initialQuery;
        this.setUserQuery(initialQuery);
        if (selectInitialQuery) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    private boolean show(ComponentName componentName, Bundle appSearchData) {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchable = searchManager.getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.show();
        }
        this.updateUI();
        return true;
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, filter);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.closeSuggestionsAdapter();
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
        this.mInitialQuery = null;
    }

    public void setWorking(boolean working) {
        this.mWorkingSpinner.setAlpha(working ? 255 : 0);
        this.mWorkingSpinner.setVisible(working, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    private void closeSuggestionsAdapter() {
        this.mSearchAutoComplete.setAdapter(null);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.close();
        }
        this.mSuggestionsAdapter = null;
    }

    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle appSearchData = savedInstanceState.getBundle(INSTANCE_KEY_APPDATA);
        String userQuery = savedInstanceState.getString(INSTANCE_KEY_USER_QUERY);
        if (!this.doShow(userQuery, false, launchComponent, appSearchData)) {
            return;
        }
    }

    public void onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchButton();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            this.updateQueryHint();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.ensureImeVisible(true);
            }
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
    }

    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private void updateUI() {
        if (this.mSearchable != null) {
            this.mDecor.setVisibility(0);
            this.updateSearchAutoComplete();
            this.updateSearchButton();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            this.updateQueryHint();
            this.updateVoiceButton(TextUtils.isEmpty(this.mUserQuery));
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchAutoComplete.setInputType(inputType);
            this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
            this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
            if (this.mSearchable.getVoiceSearchEnabled()) {
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            } else {
                this.mSearchAutoComplete.setPrivateImeOptions(null);
            }
        }
    }

    private void updateSearchAutoComplete() {
        this.closeSuggestionsAdapter();
        this.mSearchAutoComplete.setDropDownAnimationStyle(0);
        this.mSearchAutoComplete.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(true);
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mSearchAutoComplete.setAdapter(this.mSuggestionsAdapter);
        }
    }

    private void updateSearchButton() {
        String textLabel = null;
        Drawable iconLabel = null;
        int textId = this.mSearchable.getSearchButtonText();
        if (this.isBrowserSearch()) {
            iconLabel = this.getContext().getResources().getDrawable(17301897);
        } else if (textId != 0) {
            textLabel = this.mActivityContext.getResources().getString(textId);
        } else {
            iconLabel = this.getContext().getResources().getDrawable(0x1080188);
        }
        this.mGoButton.setText(textLabel);
        this.mGoButton.setCompoundDrawablesWithIntrinsicBounds(iconLabel, null, null, null);
    }

    private void updateSearchAppIcon() {
        if (this.isBrowserSearch()) {
            this.mAppIcon.setImageResource(0);
            this.mAppIcon.setVisibility(8);
            this.mSearchPlate.setPadding(12, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
        } else {
            Drawable icon;
            PackageManager pm = this.getContext().getPackageManager();
            try {
                ActivityInfo info = pm.getActivityInfo(this.mLaunchComponent, 0);
                icon = pm.getApplicationIcon(info.applicationInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                icon = pm.getDefaultActivityIcon();
                Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
            }
            this.mAppIcon.setImageDrawable(icon);
            this.mAppIcon.setVisibility(0);
            this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
        }
    }

    private void updateSearchBadge() {
        int visibility = 8;
        Drawable icon = null;
        String text = null;
        if (this.mSearchable.useBadgeIcon()) {
            icon = this.mActivityContext.getResources().getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            text = ((Object)this.mActivityContext.getResources().getText(this.mSearchable.getLabelId())).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    private void updateQueryHint() {
        if (this.isShowing()) {
            int hintId;
            String hint = null;
            if (this.mSearchable != null && (hintId = this.mSearchable.getHintId()) != 0) {
                hint = this.mActivityContext.getString(hintId);
            }
            this.mSearchAutoComplete.setHint(hint);
        }
    }

    private void updateVoiceButton(boolean empty) {
        int visibility = 8;
        if ((this.mAppSearchData == null || !this.mAppSearchData.getBoolean("android.search.DISABLE_VOICE_SEARCH", false)) && this.mSearchable.getVoiceSearchEnabled() && empty) {
            ResolveInfo ri;
            Intent testIntent = null;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                testIntent = this.mVoiceWebSearchIntent;
            } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                testIntent = this.mVoiceAppSearchIntent;
            }
            if (testIntent != null && (ri = this.getContext().getPackageManager().resolveActivity(testIntent, 65536)) != null) {
                visibility = 0;
            }
        }
        this.mVoiceButton.setVisibility(visibility);
    }

    void onDataSetChanged() {
        if (this.mSearchAutoComplete != null && this.mSuggestionsAdapter != null) {
            this.mSearchAutoComplete.onFilterComplete(this.mSuggestionsAdapter.getCount());
        }
    }

    private boolean isBrowserSearch() {
        return this.mLaunchComponent.flattenToShortString().startsWith("com.android.browser/");
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, event)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private boolean isOutOfBounds(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return x < -slop || y < -slop || x > v.getWidth() + slop || y > v.getHeight() + slop;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
        if (actionKey != null && actionKey.getQueryActionMsg() != null) {
            this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg());
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void updateWidgetState() {
        boolean enabled;
        boolean bl = enabled = !this.mSearchAutoComplete.isEmpty();
        if (this.isBrowserSearch()) {
            if (enabled && !this.mInitialQuery.equals(this.mUserQuery)) {
                this.mSearchAutoComplete.setBackgroundResource(17302301);
                this.mGoButton.setVisibility(0);
                this.mGoButton.setEnabled(true);
                this.mGoButton.setFocusable(true);
            } else {
                this.mSearchAutoComplete.setBackgroundResource(17302303);
                this.mGoButton.setVisibility(8);
            }
        } else {
            this.mGoButton.setEnabled(enabled);
            this.mGoButton.setFocusable(enabled);
        }
    }

    private Intent createVoiceWebSearchIntent(Intent baseIntent, SearchableInfo searchable) {
        Intent voiceIntent = new Intent(baseIntent);
        ComponentName searchActivity = searchable.getSearchActivity();
        voiceIntent.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        return voiceIntent;
    }

    private Intent createVoiceAppSearchIntent(Intent baseIntent, SearchableInfo searchable) {
        ComponentName searchActivity = searchable.getSearchActivity();
        Intent queryIntent = new Intent("android.intent.action.SEARCH");
        queryIntent.setComponent(searchActivity);
        PendingIntent pending = PendingIntent.getActivity(this.getContext(), 0, queryIntent, 0x40000000);
        Bundle queryExtras = new Bundle();
        if (this.mAppSearchData != null) {
            queryExtras.putBundle("app_data", this.mAppSearchData);
        }
        Intent voiceIntent = new Intent(baseIntent);
        String languageModel = "free_form";
        String prompt = null;
        String language = null;
        int maxResults = 1;
        Resources resources = this.mActivityContext.getResources();
        if (searchable.getVoiceLanguageModeId() != 0) {
            languageModel = resources.getString(searchable.getVoiceLanguageModeId());
        }
        if (searchable.getVoicePromptTextId() != 0) {
            prompt = resources.getString(searchable.getVoicePromptTextId());
        }
        if (searchable.getVoiceLanguageId() != 0) {
            language = resources.getString(searchable.getVoiceLanguageId());
        }
        if (searchable.getVoiceMaxResults() != 0) {
            maxResults = searchable.getVoiceMaxResults();
        }
        voiceIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", languageModel);
        voiceIntent.putExtra("android.speech.extra.PROMPT", prompt);
        voiceIntent.putExtra("android.speech.extra.LANGUAGE", language);
        voiceIntent.putExtra("android.speech.extra.MAX_RESULTS", maxResults);
        voiceIntent.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pending);
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", queryExtras);
        return voiceIntent;
    }

    private String fixUrl(String inUrl) {
        if (inUrl.startsWith("http://") || inUrl.startsWith("https://")) {
            return inUrl;
        }
        if (inUrl.startsWith("http:") || inUrl.startsWith("https:")) {
            inUrl = inUrl.startsWith("http:/") || inUrl.startsWith("https:/") ? inUrl.replaceFirst("/", "//") : inUrl.replaceFirst(":", "://");
        }
        if (inUrl.indexOf("://") == -1) {
            inUrl = "http://" + inUrl;
        }
        return inUrl;
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    private boolean onSuggestionsKey(View v, int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (event.getAction() == 0) {
            String actionMsg;
            Cursor c;
            int position;
            if (keyCode == 66 || keyCode == 84) {
                int position2 = this.mSearchAutoComplete.getListSelection();
                return this.launchSuggestion(position2);
            }
            if (keyCode == 21 || keyCode == 22) {
                int selPoint = keyCode == 21 ? 0 : this.mSearchAutoComplete.length();
                this.mSearchAutoComplete.setSelection(selPoint);
                this.mSearchAutoComplete.setListSelection(0);
                this.mSearchAutoComplete.clearListSelection();
                this.mSearchAutoComplete.ensureImeVisible(true);
                return true;
            }
            if (keyCode == 19 && 0 == this.mSearchAutoComplete.getListSelection()) {
                this.restoreUserQuery();
                return false;
            }
            SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
            if (actionKey != null && (actionKey.getSuggestActionMsg() != null || actionKey.getSuggestActionMsgColumn() != null) && (position = this.mSearchAutoComplete.getListSelection()) != -1 && (c = this.mSuggestionsAdapter.getCursor()).moveToPosition(position) && (actionMsg = SearchDialog.getActionKeyMessage(c, actionKey)) != null && actionMsg.length() > 0) {
                return this.launchSuggestion(position, keyCode, actionMsg);
            }
        }
        return false;
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    protected void launchQuerySearch(int actionKey, String actionMsg) {
        String query = this.mSearchAutoComplete.getText().toString();
        String action = "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action, null, null, query, null, actionKey, actionMsg);
        this.launchIntent(intent);
    }

    protected boolean launchSuggestion(int position) {
        return this.launchSuggestion(position, 0, null);
    }

    protected boolean launchSuggestion(int position, int actionKey, String actionMsg) {
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c != null && c.moveToPosition(position)) {
            Intent intent = this.createIntentFromSuggestion(c, actionKey, actionMsg);
            this.launchIntent(intent);
            return true;
        }
        return false;
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            Log.i(LOG_TAG, "Starting (as ourselves) " + intent.toURI());
            this.getContext().startActivity(intent);
            this.dismiss();
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, ex);
        }
    }

    private void setBrowserApplicationId(Intent intent) {
        String scheme;
        Uri data = intent.getData();
        if ("android.intent.action.VIEW".equals(intent.getAction()) && data != null && (scheme = data.getScheme()) != null && scheme.startsWith("http")) {
            intent.putExtra("com.android.browser.application_id", data.toString());
        }
    }

    public void setListSelection(int index) {
        this.mSearchAutoComplete.setListSelection(index);
    }

    private Intent createIntentFromSuggestion(Cursor c, int actionKey, String actionMsg) {
        try {
            String id2;
            String data;
            String action = SuggestionsAdapter.getColumnString(c, "suggest_intent_action");
            if ("android.search.action.ZILCH".equals(action)) {
                return null;
            }
            if (action == null) {
                action = this.mSearchable.getSuggestIntentAction();
            }
            if (action == null) {
                action = "android.intent.action.SEARCH";
            }
            if ((data = SuggestionsAdapter.getColumnString(c, "suggest_intent_data")) == null) {
                data = this.mSearchable.getSuggestIntentData();
            }
            if (data != null && (id2 = SuggestionsAdapter.getColumnString(c, "suggest_intent_data_id")) != null) {
                data = data + "/" + Uri.encode(id2);
            }
            Uri dataUri = data == null ? null : Uri.parse(data);
            String componentName = SuggestionsAdapter.getColumnString(c, "suggest_intent_component");
            String query = SuggestionsAdapter.getColumnString(c, "suggest_intent_query");
            String extraData = SuggestionsAdapter.getColumnString(c, "suggest_intent_extra_data");
            return this.createIntent(action, dataUri, extraData, query, componentName, actionKey, actionMsg);
        }
        catch (RuntimeException e) {
            int rowNum;
            try {
                rowNum = c.getPosition();
            }
            catch (RuntimeException e2) {
                rowNum = -1;
            }
            Log.w(LOG_TAG, "Search Suggestions cursor at row " + rowNum + " returned exception" + e.toString());
            return null;
        }
    }

    private Intent createIntent(String action, Uri data, String extraData, String query, String componentName, int actionKey, String actionMsg) {
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    private static String getActionKeyMessage(Cursor c, SearchableInfo.ActionKeyInfo actionKey) {
        String result = null;
        String column = actionKey.getSuggestActionMsgColumn();
        if (column != null) {
            result = SuggestionsAdapter.getColumnString(c, column);
        }
        if (result == null) {
            result = actionKey.getSuggestActionMsg();
        }
        return result;
    }

    @Override
    public void onBackPressed() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null && imm.isFullscreenMode() && imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.launchSuggestion(position);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.rewriteQueryFromSuggestion(position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    private void rewriteQueryFromSuggestion(int position) {
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c == null) {
            return;
        }
        if (c.moveToPosition(position)) {
            CharSequence newQuery = this.mSuggestionsAdapter.convertToString(c);
            if (newQuery != null) {
                this.setQuery(newQuery);
            } else {
                this.restoreUserQuery();
            }
        } else {
            Log.w(LOG_TAG, "Bad suggestion position: " + position);
            this.restoreUserQuery();
        }
    }

    private void restoreUserQuery() {
        this.setQuery(this.mUserQuery);
    }

    private void setQuery(CharSequence query) {
        this.mSearchAutoComplete.setText(query, false);
        if (query != null) {
            this.mSearchAutoComplete.setSelection(query.length());
        }
    }

    private void setUserQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.mUserQuery = query;
        this.mSearchAutoComplete.setText(query);
        this.mSearchAutoComplete.setSelection(query.length());
    }

    private void dbgLogTiming(String caller) {
        long millis = SystemClock.uptimeMillis();
        long oldTime = this.mLastLogTime.getAndSet(millis);
        long delta = millis - oldTime;
        String report = millis + " (+" + delta + ") ticks for Search keystroke in " + caller;
        Log.d(LOG_TAG, report);
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        private int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public void setThreshold(int threshold) {
            super.setThreshold(threshold);
            this.mThreshold = threshold;
        }

        private boolean isEmpty() {
            return TextUtils.getTrimmedLength(this.getText()) == 0;
        }

        protected void replaceText(CharSequence text) {
        }

        public void performCompletion() {
        }

        public void onWindowFocusChanged(boolean hasWindowFocus) {
            super.onWindowFocusChanged(hasWindowFocus);
            if (hasWindowFocus) {
                InputMethodManager inputManager = (InputMethodManager)this.getContext().getSystemService("input_method");
                inputManager.showSoftInput(this, 0);
                if (SearchDialog.isLandscapeMode(this.getContext())) {
                    this.ensureImeVisible(true);
                }
            }
        }

        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }
    }

    public static class SearchBar
    extends LinearLayout {
        private SearchDialog mSearchDialog;

        public SearchBar(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchBar(Context context) {
            super(context);
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }

        public boolean dispatchKeyEventPreIme(KeyEvent event) {
            KeyEvent.DispatcherState state;
            if (this.mSearchDialog != null && event.getKeyCode() == 4 && (state = this.getKeyDispatcherState()) != null) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    state.startTracking(event, this);
                    return true;
                }
                if (event.getAction() == 1 && !event.isCanceled() && state.isTracking(event)) {
                    this.mSearchDialog.onBackPressed();
                    return true;
                }
            }
            return super.dispatchKeyEventPreIme(event);
        }
    }
}

