/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSessionAdapter;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.server.sip.SipSessionGroup;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.sip.SipException;

public final class SipService
extends ISipService.Stub {
    static final String TAG = "SipService";
    static final boolean DEBUGV = false;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TIMER = false;
    private static final int EXPIRY_TIME = 3600;
    private static final int SHORT_EXPIRY_TIME = 10;
    private static final int MIN_EXPIRY_TIME = 60;
    private Context mContext;
    private String mLocalIp;
    private String mNetworkType;
    private boolean mConnected;
    private WakeupTimer mTimer;
    private WifiScanProcess mWifiScanProcess;
    private WifiManager.WifiLock mWifiLock;
    private boolean mWifiOnly;
    private MyExecutor mExecutor;
    private Map<String, SipSessionGroupExt> mSipGroups = new HashMap<String, SipSessionGroupExt>();
    private Map<String, ISipSession> mPendingSessions = new HashMap<String, ISipSession>();
    private ConnectivityReceiver mConnectivityReceiver;
    private boolean mWifiEnabled;
    private SipWakeLock mMyWakeLock;
    private BroadcastReceiver mWifiStateReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.WIFI_STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("wifi_state", 4);
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    switch (state) {
                        case 3: {
                            SipService.this.mWifiEnabled = true;
                            if (!SipService.this.anyOpenedToReceiveCalls()) break;
                            SipService.this.grabWifiLock();
                            break;
                        }
                        case 1: {
                            SipService.this.mWifiEnabled = false;
                            SipService.this.releaseWifiLock();
                        }
                    }
                }
            }
        }
    };

    public static void start(Context context) {
        if (SipManager.isApiSupported(context)) {
            ServiceManager.addService("sip", new SipService(context));
            context.sendBroadcast(new Intent("android.net.sip.SIP_SERVICE_UP"));
        }
    }

    private SipService(Context context) {
        this.mContext = context;
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.mMyWakeLock = new SipWakeLock((PowerManager)context.getSystemService("power"));
        this.mTimer = new WakeupTimer(context);
        this.mWifiOnly = SipManager.isSipWifiOnly(context);
    }

    private void registerReceivers() {
        this.mContext.registerReceiver(this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.mContext.registerReceiver(this.mWifiStateReceiver, new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED"));
    }

    private void unregisterReceivers() {
        this.mContext.unregisterReceiver(this.mConnectivityReceiver);
        this.mContext.unregisterReceiver(this.mWifiStateReceiver);
    }

    private MyExecutor getExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = new MyExecutor();
        }
        return this.mExecutor;
    }

    public synchronized SipProfile[] getListOfProfiles() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        boolean isCallerRadio = this.isCallerRadio();
        ArrayList<SipProfile> profiles = new ArrayList<SipProfile>();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!isCallerRadio && !this.isCallerCreator(group)) continue;
            profiles.add(group.getLocalProfile());
        }
        return profiles.toArray(new SipProfile[profiles.size()]);
    }

    public synchronized void open(SipProfile localProfile) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        try {
            boolean addingFirstProfile = this.mSipGroups.isEmpty();
            this.createGroup(localProfile);
            if (addingFirstProfile && !this.mSipGroups.isEmpty()) {
                this.registerReceivers();
            }
        }
        catch (SipException e) {
            Log.e(TAG, "openToMakeCalls()", e);
        }
    }

    public synchronized void open3(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (incomingCallPendingIntent == null) {
            Log.w(TAG, "incomingCallPendingIntent cannot be null; the profile is not opened");
            return;
        }
        try {
            boolean addingFirstProfile = this.mSipGroups.isEmpty();
            SipSessionGroupExt group = this.createGroup(localProfile, incomingCallPendingIntent, listener);
            if (addingFirstProfile && !this.mSipGroups.isEmpty()) {
                this.registerReceivers();
            }
            if (localProfile.getAutoRegistration()) {
                group.openToReceiveCalls();
                if (this.mWifiEnabled) {
                    this.grabWifiLock();
                }
            }
        }
        catch (SipException e) {
            Log.e(TAG, "openToReceiveCalls()", e);
        }
    }

    private boolean isCallerCreator(SipSessionGroupExt group) {
        SipProfile profile = group.getLocalProfile();
        return profile.getCallingUid() == Binder.getCallingUid();
    }

    private boolean isCallerCreatorOrRadio(SipSessionGroupExt group) {
        return this.isCallerRadio() || this.isCallerCreator(group);
    }

    private boolean isCallerRadio() {
        return Binder.getCallingUid() == 1001;
    }

    public synchronized void close(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (!this.isCallerCreatorOrRadio(group)) {
            Log.w(TAG, "only creator or radio can close this profile");
            return;
        }
        group = this.mSipGroups.remove(localProfileUri);
        this.notifyProfileRemoved(group.getLocalProfile());
        group.close();
        if (!this.anyOpenedToReceiveCalls()) {
            this.releaseWifiLock();
            this.mMyWakeLock.reset();
        }
        if (this.mSipGroups.isEmpty()) {
            this.unregisterReceivers();
        }
    }

    public synchronized boolean isOpened(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return true;
        }
        Log.w(TAG, "only creator or radio can query on the profile");
        return false;
    }

    public synchronized boolean isRegistered(String localProfileUri) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return false;
        }
        if (this.isCallerCreatorOrRadio(group)) {
            return group.isRegistered();
        }
        Log.w(TAG, "only creator or radio can query on the profile");
        return false;
    }

    public synchronized void setRegistrationListener(String localProfileUri, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        SipSessionGroupExt group = this.mSipGroups.get(localProfileUri);
        if (group == null) {
            return;
        }
        if (this.isCallerCreator(group)) {
            group.setListener(listener);
        } else {
            Log.w(TAG, "only creator can set listener on the profile");
        }
    }

    public synchronized ISipSession createSession(SipProfile localProfile, ISipSessionListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        localProfile.setCallingUid(Binder.getCallingUid());
        if (!this.mConnected) {
            return null;
        }
        try {
            SipSessionGroupExt group = this.createGroup(localProfile);
            return group.createSession(listener);
        }
        catch (SipException e) {
            return null;
        }
    }

    public synchronized ISipSession getPendingSession(String callId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
        if (callId == null) {
            return null;
        }
        return this.mPendingSessions.get(callId);
    }

    private String determineLocalIp() {
        try {
            DatagramSocket s = new DatagramSocket();
            s.connect(InetAddress.getByName("192.168.1.1"), 80);
            return s.getLocalAddress().getHostAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group == null) {
            group = new SipSessionGroupExt(localProfile, null, null);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        } else if (!this.isCallerCreator(group)) {
            throw new SipException("only creator can access the profile");
        }
        return group;
    }

    private SipSessionGroupExt createGroup(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
        String key = localProfile.getUriString();
        SipSessionGroupExt group = this.mSipGroups.get(key);
        if (group != null) {
            if (!this.isCallerCreator(group)) {
                throw new SipException("only creator can access the profile");
            }
            group.setIncomingCallPendingIntent(incomingCallPendingIntent);
            group.setListener(listener);
        } else {
            group = new SipSessionGroupExt(localProfile, incomingCallPendingIntent, listener);
            this.mSipGroups.put(key, group);
            this.notifyProfileAdded(localProfile);
        }
        return group;
    }

    private void notifyProfileAdded(SipProfile localProfile) {
        Intent intent = new Intent("com.android.phone.SIP_ADD_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    private void notifyProfileRemoved(SipProfile localProfile) {
        Intent intent = new Intent("com.android.phone.SIP_REMOVE_PHONE");
        intent.putExtra("android:localSipUri", localProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    private boolean anyOpenedToReceiveCalls() {
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (!group.isOpenedToReceiveCalls()) continue;
            return true;
        }
        return false;
    }

    private void grabWifiLock() {
        if (this.mWifiLock == null) {
            this.mWifiLock = ((WifiManager)this.mContext.getSystemService("wifi")).createWifiLock(1, TAG);
            this.mWifiLock.acquire();
            if (!this.mConnected) {
                this.startWifiScanner();
            }
        }
    }

    private void releaseWifiLock() {
        if (this.mWifiLock != null) {
            this.mWifiLock.release();
            this.mWifiLock = null;
            this.stopWifiScanner();
        }
    }

    private synchronized void startWifiScanner() {
        if (this.mWifiScanProcess == null) {
            this.mWifiScanProcess = new WifiScanProcess();
        }
        this.mWifiScanProcess.start();
    }

    private synchronized void stopWifiScanner() {
        if (this.mWifiScanProcess != null) {
            this.mWifiScanProcess.stop();
        }
    }

    private synchronized void onConnectivityChanged(String type, boolean connected) {
        boolean sameType = type.equals(this.mNetworkType);
        if (!sameType && !connected) {
            return;
        }
        boolean wasWifi = "WIFI".equalsIgnoreCase(this.mNetworkType);
        boolean isWifi = "WIFI".equalsIgnoreCase(type);
        boolean wifiOff = isWifi && !connected || wasWifi && !sameType;
        boolean wifiOn = isWifi && connected;
        try {
            boolean wasConnected = this.mConnected;
            this.mNetworkType = type;
            this.mConnected = connected;
            if (wasConnected) {
                this.mLocalIp = null;
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(false);
                }
            }
            if (connected) {
                this.mLocalIp = this.determineLocalIp();
                for (SipSessionGroupExt group : this.mSipGroups.values()) {
                    group.onConnectivityChanged(true);
                }
                if (isWifi && this.mWifiLock != null) {
                    this.stopWifiScanner();
                }
            } else {
                this.mMyWakeLock.reset();
                if (isWifi && this.mWifiLock != null) {
                    this.startWifiScanner();
                }
            }
        }
        catch (SipException e) {
            Log.e(TAG, "onConnectivityChanged()", e);
        }
    }

    private synchronized void addPendingSession(ISipSession session) {
        try {
            this.cleanUpPendingSessions();
            this.mPendingSessions.put(session.getCallId(), session);
        }
        catch (RemoteException e) {
            Log.e(TAG, "addPendingSession()", e);
        }
    }

    private void cleanUpPendingSessions() throws RemoteException {
        Map.Entry[] entries;
        for (Map.Entry entry : entries = this.mPendingSessions.entrySet().toArray(new Map.Entry[this.mPendingSessions.size()])) {
            if (((ISipSession)entry.getValue()).getState() == 3) continue;
            this.mPendingSessions.remove(entry.getKey());
        }
    }

    private synchronized boolean callingSelf(SipSessionGroupExt ringingGroup, SipSessionGroup.SipSessionImpl ringingSession) {
        String callId = ringingSession.getCallId();
        for (SipSessionGroupExt group : this.mSipGroups.values()) {
            if (group == ringingGroup || !group.containsSession(callId)) continue;
            return true;
        }
        return false;
    }

    private static Looper createLooper() {
        HandlerThread thread = new HandlerThread("SipService.Executor");
        thread.start();
        return thread.getLooper();
    }

    private class MyExecutor
    extends Handler {
        MyExecutor() {
            super(SipService.createLooper());
        }

        void execute(Runnable task) {
            SipService.this.mMyWakeLock.acquire(task);
            Message.obtain(this, 0, task).sendToTarget();
        }

        public void handleMessage(Message msg) {
            if (msg.obj instanceof Runnable) {
                this.executeInternal((Runnable)msg.obj);
            } else {
                Log.w(SipService.TAG, "can't handle msg: " + msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeInternal(Runnable task) {
            try {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    Log.e(SipService.TAG, "run task: " + task, t);
                    Object var4_3 = null;
                    SipService.this.mMyWakeLock.release(task);
                }
                Object var4_2 = null;
                SipService.this.mMyWakeLock.release(task);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                SipService.this.mMyWakeLock.release(task);
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyEventComparator
    implements Comparator<MyEvent> {
        private MyEventComparator() {
        }

        @Override
        public int compare(MyEvent e1, MyEvent e2) {
            if (e1 == e2) {
                return 0;
            }
            int diff = e1.mMaxPeriod - e2.mMaxPeriod;
            if (diff == 0) {
                diff = -1;
            }
            return diff;
        }

        @Override
        public boolean equals(Object that) {
            return this == that;
        }
    }

    private static class MyEvent {
        int mPeriod;
        int mMaxPeriod;
        long mTriggerTime;
        long mLastTriggerTime;
        Runnable mCallback;

        MyEvent(int period, Runnable callback, long now) {
            this.mPeriod = this.mMaxPeriod = period;
            this.mCallback = callback;
            this.mLastTriggerTime = now;
        }

        public String toString() {
            String s = super.toString();
            s = s.substring(s.indexOf("@"));
            return s + ":" + this.mPeriod / 1000 + ":" + this.mMaxPeriod / 1000 + ":" + this.toString(this.mCallback);
        }

        private String toString(Object o) {
            String s = o.toString();
            int index = s.indexOf("$");
            if (index > 0) {
                s = s.substring(index + 1);
            }
            return s;
        }
    }

    class WakeupTimer
    extends BroadcastReceiver {
        private static final String TAG = "_SIP.WkTimer_";
        private static final String TRIGGER_TIME = "TriggerTime";
        private Context mContext;
        private AlarmManager mAlarmManager;
        private TreeSet<MyEvent> mEventQueue = new TreeSet<MyEvent>(new MyEventComparator());
        private PendingIntent mPendingIntent;

        public WakeupTimer(Context context) {
            this.mContext = context;
            this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
            IntentFilter filter = new IntentFilter(this.getAction());
            context.registerReceiver(this, filter);
        }

        public synchronized void stop() {
            this.mContext.unregisterReceiver(this);
            if (this.mPendingIntent != null) {
                this.mAlarmManager.cancel(this.mPendingIntent);
                this.mPendingIntent = null;
            }
            this.mEventQueue.clear();
            this.mEventQueue = null;
        }

        private synchronized boolean stopped() {
            if (this.mEventQueue == null) {
                Log.w(TAG, "Timer stopped");
                return true;
            }
            return false;
        }

        private void cancelAlarm() {
            this.mAlarmManager.cancel(this.mPendingIntent);
            this.mPendingIntent = null;
        }

        private void recalculatePeriods() {
            if (this.mEventQueue.isEmpty()) {
                return;
            }
            MyEvent firstEvent = this.mEventQueue.first();
            int minPeriod = firstEvent.mMaxPeriod;
            long minTriggerTime = firstEvent.mTriggerTime;
            for (MyEvent e : this.mEventQueue) {
                e.mPeriod = e.mMaxPeriod / minPeriod * minPeriod;
                int interval = (int)(e.mLastTriggerTime + (long)e.mMaxPeriod - minTriggerTime);
                interval = interval / minPeriod * minPeriod;
                e.mTriggerTime = minTriggerTime + (long)interval;
            }
            TreeSet<MyEvent> newQueue = new TreeSet<MyEvent>(this.mEventQueue.comparator());
            newQueue.addAll(this.mEventQueue);
            this.mEventQueue.clear();
            this.mEventQueue = newQueue;
        }

        private void insertEvent(MyEvent event) {
            long now = SystemClock.elapsedRealtime();
            if (this.mEventQueue.isEmpty()) {
                event.mTriggerTime = now + (long)event.mPeriod;
                this.mEventQueue.add(event);
                return;
            }
            MyEvent firstEvent = this.mEventQueue.first();
            int minPeriod = firstEvent.mPeriod;
            if (minPeriod <= event.mMaxPeriod) {
                event.mPeriod = event.mMaxPeriod / minPeriod * minPeriod;
                int interval = event.mMaxPeriod;
                interval -= (int)(firstEvent.mTriggerTime - now);
                interval = interval / minPeriod * minPeriod;
                event.mTriggerTime = firstEvent.mTriggerTime + (long)interval;
                this.mEventQueue.add(event);
            } else {
                long triggerTime = now + (long)event.mPeriod;
                if (firstEvent.mTriggerTime < triggerTime) {
                    event.mTriggerTime = firstEvent.mTriggerTime;
                    event.mLastTriggerTime -= (long)event.mPeriod;
                } else {
                    event.mTriggerTime = triggerTime;
                }
                this.mEventQueue.add(event);
                this.recalculatePeriods();
            }
        }

        public synchronized void set(int period, Runnable callback) {
            if (this.stopped()) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            MyEvent event = new MyEvent(period, callback, now);
            this.insertEvent(event);
            if (this.mEventQueue.first() == event) {
                if (this.mEventQueue.size() > 1) {
                    this.cancelAlarm();
                }
                this.scheduleNext();
            }
            long triggerTime = event.mTriggerTime;
        }

        public synchronized void cancel(Runnable callback) {
            if (this.stopped() || this.mEventQueue.isEmpty()) {
                return;
            }
            MyEvent firstEvent = this.mEventQueue.first();
            Iterator<MyEvent> iter = this.mEventQueue.iterator();
            while (iter.hasNext()) {
                MyEvent event = iter.next();
                if (event.mCallback != callback) continue;
                iter.remove();
            }
            if (this.mEventQueue.isEmpty()) {
                this.cancelAlarm();
            } else if (this.mEventQueue.first() != firstEvent) {
                this.cancelAlarm();
                firstEvent = this.mEventQueue.first();
                firstEvent.mPeriod = firstEvent.mMaxPeriod;
                firstEvent.mTriggerTime = firstEvent.mLastTriggerTime + (long)firstEvent.mPeriod;
                this.recalculatePeriods();
                this.scheduleNext();
            }
        }

        private void scheduleNext() {
            if (this.stopped() || this.mEventQueue.isEmpty()) {
                return;
            }
            if (this.mPendingIntent != null) {
                throw new RuntimeException("pendingIntent is not null!");
            }
            MyEvent event = this.mEventQueue.first();
            Intent intent = new Intent(this.getAction());
            intent.putExtra(TRIGGER_TIME, event.mTriggerTime);
            PendingIntent pendingIntent = this.mPendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
            this.mAlarmManager.set(2, event.mTriggerTime, pendingIntent);
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (this.getAction().equals(action) && intent.getExtras().containsKey(TRIGGER_TIME)) {
                this.mPendingIntent = null;
                long triggerTime = intent.getLongExtra(TRIGGER_TIME, -1L);
                this.execute(triggerTime);
            } else {
                Log.d(TAG, "unrecognized intent: " + intent);
            }
        }

        private void printQueue() {
            int count = 0;
            for (MyEvent event : this.mEventQueue) {
                Log.d(TAG, "     " + event + ": scheduled at " + this.showTime(event.mTriggerTime) + ": last at " + this.showTime(event.mLastTriggerTime));
                if (++count < 5) continue;
                break;
            }
            if (this.mEventQueue.size() > count) {
                Log.d(TAG, "     .....");
            } else if (count == 0) {
                Log.d(TAG, "     <empty>");
            }
        }

        private synchronized void execute(long triggerTime) {
            if (this.stopped() || this.mEventQueue.isEmpty()) {
                return;
            }
            for (MyEvent event : this.mEventQueue) {
                if (event.mTriggerTime != triggerTime) break;
                event.mLastTriggerTime = event.mTriggerTime;
                event.mTriggerTime += (long)event.mPeriod;
                SipService.this.getExecutor().execute(event.mCallback);
            }
            this.scheduleNext();
        }

        private String getAction() {
            return this.toString();
        }

        private String showTime(long time) {
            int ms = (int)(time % 1000L);
            int s = (int)(time / 1000L);
            int m = s / 60;
            return String.format("%d.%d.%d", m, s %= 60, ms);
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private Timer mTimer = new Timer();
        private MyTimerTask mTask;

        private ConnectivityReceiver() {
        }

        public void onReceive(final Context context, final Intent intent) {
            SipService.this.getExecutor().execute(new Runnable(){

                public void run() {
                    ConnectivityReceiver.this.onReceiveInternal(context, intent);
                }
            });
        }

        private void onReceiveInternal(Context context, Intent intent) {
            Bundle b;
            String action = intent.getAction();
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE") && (b = intent.getExtras()) != null) {
                NetworkInfo netInfo = (NetworkInfo)b.get("networkInfo");
                String type = netInfo.getTypeName();
                NetworkInfo.State state = netInfo.getState();
                if (SipService.this.mWifiOnly && netInfo.getType() != 1) {
                    return;
                }
                NetworkInfo activeNetInfo = this.getActiveNetworkInfo();
                if (state == NetworkInfo.State.CONNECTED && activeNetInfo != null && activeNetInfo.getType() != netInfo.getType()) {
                    return;
                }
                if (state == NetworkInfo.State.CONNECTED) {
                    this.onChanged(type, true);
                } else if (state == NetworkInfo.State.DISCONNECTED) {
                    this.onChanged(type, false);
                }
            }
        }

        private NetworkInfo getActiveNetworkInfo() {
            ConnectivityManager cm = (ConnectivityManager)SipService.this.mContext.getSystemService("connectivity");
            return cm.getActiveNetworkInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onChanged(String type, boolean connected) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (connected) {
                    if (this.mTask != null) {
                        this.mTask.cancel();
                        SipService.this.mMyWakeLock.release(this.mTask);
                    }
                    this.mTask = new MyTimerTask(type, connected);
                    this.mTimer.schedule((TimerTask)this.mTask, 2000L);
                    SipService.this.mMyWakeLock.acquire(this.mTask);
                } else {
                    if (this.mTask != null && this.mTask.mNetworkType.equals(type)) {
                        this.mTask.cancel();
                        SipService.this.mMyWakeLock.release(this.mTask);
                    }
                    SipService.this.onConnectivityChanged(type, false);
                }
            }
        }

        private class MyTimerTask
        extends TimerTask {
            private boolean mConnected;
            private String mNetworkType;

            public MyTimerTask(String type, boolean connected) {
                this.mNetworkType = type;
                this.mConnected = connected;
            }

            public void run() {
                SipService.this.getExecutor().execute(new Runnable(){

                    public void run() {
                        MyTimerTask.this.realRun();
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void realRun() {
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    if (ConnectivityReceiver.this.mTask != this) {
                        Log.w(SipService.TAG, "  unexpected task: " + this.mNetworkType + (this.mConnected ? " CONNECTED" : "DISCONNECTED"));
                        SipService.this.mMyWakeLock.release(this);
                        return;
                    }
                    ConnectivityReceiver.this.mTask = null;
                    SipService.this.onConnectivityChanged(this.mNetworkType, this.mConnected);
                    SipService.this.mMyWakeLock.release(this);
                }
            }
        }
    }

    private class AutoRegistrationProcess
    extends SipSessionAdapter
    implements Runnable {
        private SipSessionGroup.SipSessionImpl mSession;
        private SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        private KeepAliveProcess mKeepAliveProcess;
        private int mBackoff = 1;
        private boolean mRegistered;
        private long mExpiryTime;
        private int mErrorCode;
        private String mErrorMessage;
        private boolean mRunning = false;

        private AutoRegistrationProcess() {
        }

        private String getAction() {
            return this.toString();
        }

        public void start(SipSessionGroup group) {
            if (!this.mRunning) {
                this.mRunning = true;
                this.mBackoff = 1;
                this.mSession = (SipSessionGroup.SipSessionImpl)group.createSession(this);
                if (this.mSession == null) {
                    return;
                }
                SipService.this.mMyWakeLock.acquire(this.mSession);
                this.mSession.unregister();
            }
        }

        public void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            SipService.this.mMyWakeLock.release(this.mSession);
            if (this.mSession != null) {
                this.mSession.setListener(null);
                if (SipService.this.mConnected && this.mRegistered) {
                    this.mSession.unregister();
                }
            }
            SipService.this.mTimer.cancel(this);
            if (this.mKeepAliveProcess != null) {
                this.mKeepAliveProcess.stop();
                this.mKeepAliveProcess = null;
            }
            this.mRegistered = false;
            this.setListener(this.mProxy.getListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setListener(ISipSessionListener listener) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                this.mProxy.setListener(listener);
                try {
                    int state;
                    int n = state = this.mSession == null ? 0 : this.mSession.getState();
                    if (state == 1 || state == 2) {
                        this.mProxy.onRegistering(this.mSession);
                    } else if (this.mRegistered) {
                        int duration = (int)(this.mExpiryTime - SystemClock.elapsedRealtime());
                        this.mProxy.onRegistrationDone(this.mSession, duration);
                    } else if (this.mErrorCode != 0) {
                        if (this.mErrorCode == -5) {
                            this.mProxy.onRegistrationTimeout(this.mSession);
                        } else {
                            this.mProxy.onRegistrationFailed(this.mSession, this.mErrorCode, this.mErrorMessage);
                        }
                    } else if (!SipService.this.mConnected) {
                        this.mProxy.onRegistrationFailed(this.mSession, -10, "no data connection");
                    } else if (!this.mRunning) {
                        this.mProxy.onRegistrationFailed(this.mSession, -4, "registration not running");
                    } else {
                        this.mProxy.onRegistrationFailed(this.mSession, -9, String.valueOf(state));
                    }
                }
                catch (Throwable t) {
                    Log.w(SipService.TAG, "setListener(): " + t);
                }
            }
        }

        public boolean isRegistered() {
            return this.mRegistered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                this.mErrorCode = 0;
                this.mErrorMessage = null;
                if (SipService.this.mConnected) {
                    SipService.this.mMyWakeLock.acquire(this.mSession);
                    this.mSession.register(3600);
                }
            }
        }

        private boolean isBehindNAT(String address) {
            try {
                byte[] d = InetAddress.getByName(address).getAddress();
                if (d[0] == 10 || (0xFF & d[0]) == 172 && (0xF0 & d[1]) == 16 || (0xFF & d[0]) == 192 && (0xFF & d[1]) == 168) {
                    return true;
                }
            }
            catch (UnknownHostException e) {
                Log.e(SipService.TAG, "isBehindAT()" + address, e);
            }
            return false;
        }

        private void restart(int duration) {
            SipService.this.mTimer.cancel(this);
            SipService.this.mTimer.set(duration * 1000, this);
        }

        private int backoffDuration() {
            int duration = 10 * this.mBackoff;
            if (duration > 3600) {
                duration = 3600;
            } else {
                this.mBackoff *= 2;
            }
            return duration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistering(ISipSession session) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mRegistered = false;
                this.mProxy.onRegistering(session);
            }
        }

        private boolean notCurrentSession(ISipSession session) {
            if (session != this.mSession) {
                ((SipSessionGroup.SipSessionImpl)session).setListener(null);
                SipService.this.mMyWakeLock.release(session);
                return true;
            }
            return !this.mRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationDone(ISipSession session, int duration) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mProxy.onRegistrationDone(session, duration);
                if (duration > 0) {
                    this.mSession.clearReRegisterRequired();
                    this.mExpiryTime = SystemClock.elapsedRealtime() + (long)(duration * 1000);
                    if (!this.mRegistered) {
                        this.mRegistered = true;
                        if ((duration -= 60) < 60) {
                            duration = 60;
                        }
                        this.restart(duration);
                        if (this.isBehindNAT(SipService.this.mLocalIp) || this.mSession.getLocalProfile().getSendKeepAlive()) {
                            if (this.mKeepAliveProcess == null) {
                                this.mKeepAliveProcess = new KeepAliveProcess(this.mSession);
                            }
                            this.mKeepAliveProcess.start();
                        }
                    }
                    SipService.this.mMyWakeLock.release(session);
                } else {
                    this.mRegistered = false;
                    this.mExpiryTime = -1L;
                    this.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationFailed(ISipSession session, int errorCode, String message) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                switch (errorCode) {
                    case -12: 
                    case -8: {
                        this.stop();
                        break;
                    }
                    default: {
                        this.restartLater();
                    }
                }
                this.mErrorCode = errorCode;
                this.mErrorMessage = message;
                this.mProxy.onRegistrationFailed(session, errorCode, message);
                SipService.this.mMyWakeLock.release(session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationTimeout(ISipSession session) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(session)) {
                    return;
                }
                this.mErrorCode = -5;
                this.mProxy.onRegistrationTimeout(session);
                this.restartLater();
                SipService.this.mMyWakeLock.release(session);
            }
        }

        private void restartLater() {
            this.mRegistered = false;
            this.restart(this.backoffDuration());
            if (this.mKeepAliveProcess != null) {
                this.mKeepAliveProcess.stop();
                this.mKeepAliveProcess = null;
            }
        }
    }

    private class KeepAliveProcess
    implements Runnable {
        private static final String TAG = "\\KEEPALIVE/";
        private static final int INTERVAL = 10;
        private SipSessionGroup.SipSessionImpl mSession;
        private boolean mRunning = false;

        public KeepAliveProcess(SipSessionGroup.SipSessionImpl session) {
            this.mSession = session;
        }

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(10000, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                SipSessionGroup.SipSessionImpl session = this.mSession.duplicate();
                try {
                    session.sendKeepAlive();
                    if (session.isReRegisterRequired()) {
                        SipService.this.mMyWakeLock.acquire(this.mSession);
                        this.mSession.register(3600);
                    }
                }
                catch (Throwable t) {
                    Log.w(TAG, "keepalive error: " + t);
                }
            }
        }

        public void stop() {
            this.mRunning = false;
            this.mSession = null;
            SipService.this.mTimer.cancel(this);
        }
    }

    private class WifiScanProcess
    implements Runnable {
        private static final String TAG = "\\WIFI_SCAN/";
        private static final int INTERVAL = 60;
        private boolean mRunning = false;
        private WifiManager mWifiManager;

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(60000, this);
        }

        WifiScanProcess() {
            this.mWifiManager = (WifiManager)SipService.this.mContext.getSystemService("wifi");
        }

        public void run() {
            this.mWifiManager.startScanActive();
        }

        public void stop() {
            this.mRunning = false;
            SipService.this.mTimer.cancel(this);
        }
    }

    private class SipSessionGroupExt
    extends SipSessionAdapter {
        private SipSessionGroup mSipGroup;
        private PendingIntent mIncomingCallPendingIntent;
        private boolean mOpenedToReceiveCalls;
        private AutoRegistrationProcess mAutoRegistration;

        public SipSessionGroupExt(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws SipException {
            this.mAutoRegistration = new AutoRegistrationProcess();
            String password = localProfile.getPassword();
            SipProfile p = this.duplicate(localProfile);
            this.mSipGroup = this.createSipSessionGroup(SipService.this.mLocalIp, p, password);
            this.mIncomingCallPendingIntent = incomingCallPendingIntent;
            this.mAutoRegistration.setListener(listener);
        }

        public SipProfile getLocalProfile() {
            return this.mSipGroup.getLocalProfile();
        }

        public boolean containsSession(String callId) {
            return this.mSipGroup.containsSession(callId);
        }

        private SipSessionGroup createSipSessionGroup(String localIp, SipProfile localProfile, String password) throws SipException {
            try {
                return new SipSessionGroup(localIp, localProfile, password, SipService.this.mMyWakeLock);
            }
            catch (IOException e) {
                Log.w(SipService.TAG, "createSipSessionGroup(): network disconnected?");
                if (localIp != null) {
                    return this.createSipSessionGroup(null, localProfile, password);
                }
                Log.wtf(SipService.TAG, "impossible! recursive!");
                throw new RuntimeException("createSipSessionGroup");
            }
        }

        private SipProfile duplicate(SipProfile p) {
            try {
                return new SipProfile.Builder(p).setPassword("*").build();
            }
            catch (Exception e) {
                Log.wtf(SipService.TAG, "duplicate()", e);
                throw new RuntimeException("duplicate profile", e);
            }
        }

        public void setListener(ISipSessionListener listener) {
            this.mAutoRegistration.setListener(listener);
        }

        public void setIncomingCallPendingIntent(PendingIntent pIntent) {
            this.mIncomingCallPendingIntent = pIntent;
        }

        public void openToReceiveCalls() throws SipException {
            this.mOpenedToReceiveCalls = true;
            if (SipService.this.mConnected) {
                this.mSipGroup.openToReceiveCalls(this);
                this.mAutoRegistration.start(this.mSipGroup);
            }
        }

        public void onConnectivityChanged(boolean connected) throws SipException {
            this.mSipGroup.onConnectivityChanged();
            if (connected) {
                this.resetGroup(SipService.this.mLocalIp);
                if (this.mOpenedToReceiveCalls) {
                    this.openToReceiveCalls();
                }
            } else {
                this.mSipGroup.close();
                this.mAutoRegistration.stop();
            }
        }

        private void resetGroup(String localIp) throws SipException {
            try {
                this.mSipGroup.reset(localIp);
            }
            catch (IOException e) {
                Log.w(SipService.TAG, "resetGroup(): network disconnected?");
                if (localIp != null) {
                    this.resetGroup(null);
                }
                Log.wtf(SipService.TAG, "impossible!");
                throw new RuntimeException("resetGroup");
            }
        }

        public void close() {
            this.mOpenedToReceiveCalls = false;
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        public ISipSession createSession(ISipSessionListener listener) {
            return this.mSipGroup.createSession(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRinging(ISipSession s, SipProfile caller, String sessionDescription) {
            SipSessionGroup.SipSessionImpl session = (SipSessionGroup.SipSessionImpl)s;
            SipService sipService = SipService.this;
            synchronized (sipService) {
                try {
                    if (!this.isRegistered() || SipService.this.callingSelf(this, session)) {
                        session.endCall();
                        return;
                    }
                    SipService.this.addPendingSession(session);
                    Intent intent = SipManager.createIncomingCallBroadcast(session.getCallId(), sessionDescription);
                    this.mIncomingCallPendingIntent.send(SipService.this.mContext, 101, intent);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.w(SipService.TAG, "pendingIntent is canceled, drop incoming call");
                    session.endCall();
                }
            }
        }

        public void onError(ISipSession session, int errorCode, String message) {
        }

        public boolean isOpenedToReceiveCalls() {
            return this.mOpenedToReceiveCalls;
        }

        public boolean isRegistered() {
            return this.mAutoRegistration.isRegistered();
        }

        private String getUri() {
            return this.mSipGroup.getLocalProfileUri();
        }
    }
}

